/**

>       Yep.  My handler just wait()s until it catches the pid; no more.

are you reaping dead children? do you know that you can do a    

        signal(SIGCHLD, SIG_IGN)                                                

so that you don't even have to wait() for child processes..


 **/

/*
 * $Id: muuzaudio.c,v 1.4 2000/02/06 07:08:17 kline Exp kline $
 *
 *  Direct sin wave information and misc audio *.au headers to use used,
 *  optionally, in the final muuz suite.
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include <signal.h>
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"



#include "errMessage.h"
#include "mixerControls.h"

extern errMessage program;  // for emsg()

pid_t beatsPid = 0;

/*
 * idea: stay at one note level and up N+ for each freq increase.
 * start at DO for  delta; RE for theta; MI for alpha; FA for beta
 * 14 to 17; SO for beta 18 to 24; LA for beta 25 to 30; TI for beta 31
 * to 35; and the next higher DO for beta 36 to 40.
 *
 * Of course, not regularly using Hz .gt. 30....
 */

octave_t octave; /* LOW, MID, UPPER, HIGH */
char *upper_o[] =
{
"262 263", /* 1 delta */
"262 264", /* 2 delta */
"262 265", /* 3 delta */
"294 298", /* 4 theta */
"294 299", /* 5 theta */
"294 300", /* 6 thera */
"294 301", /* 7 theta */
"294 302", /* 8 theta */
"311 320", /* 9 altheta */  /* Re # */
"330 340", /* 10 alpha */
"330 341", /* 11 alpha */
"330 342", /* 12 alpha */
"330 343", /* 13 alpha */
"349 363", /* 14 beta  */
"349 364",/* 15 beta  */
"349 365",/* 16 beta  */
"349 366",/* 17 beta  */
"392 410",/* 18 beta  */
"392 411",/* 19 beta  */
"392 412",/* 20 beta  */
"392 413",/* 21 beta */
"392 414",/* 22 beta */
"392 415",/* 23 beta */
"392 416",/* 24 beta */
"440 465",/* 25 beta */
"440 466",/* 26 beta */
"440 467",/* 27 beta */
"440 468",/* 28 beta */
"440 469",/* 29 beta */
"440 470", /* 30 beta */
"494  278", /* 31 beta */
"494  279", /* 32 beta */
"494  280", /* 33 beta */
"494  281", /* 34 beta */
"494  282", /* 35 beta */
"523  298", /* 36 beta */
"523  299", /* 37 beta */
"523  300", /* 38 beta */
"523  301", /* 39 beta */
"523  302", /* 40 beta */
(char *) 0
};



char *high_o[] =
{
"523 524", /* 1 delta */
"523 525", /* 2 delta */
"523 526", /* 3 delta */
"587 591", /* 4 theta */
"587 592", /* 5 theta */
"587 593", /* 6 thera */
"587 594", /* 7 theta */
"587 595", /* 8 theta */
"622 631", /* 9 altheta */  /* Re # */
"659 669", /* 10 alpha */
"659 670", /* 11 alpha */
"659 671", /* 12 alpha */
"659 672", /* 13 alpha */
"698 363", /* 14 beta  */
"698 713",/* 15 beta  */
"698 714",/* 16 beta  */
"698 715",/* 17 beta  */
"784 802",/* 18 beta  */
"784 803",/* 19 beta  */
"784 804",/* 20 beta  */
"784 805",/* 21 beta */
"784 806",/* 22 beta */
"784 807",/* 23 beta */
"784 808",/* 24 beta */
"880 905",/* 25 beta */
"880 906",/* 26 beta */
"880 907",/* 27 beta */
"880 908",/* 28 beta */
"880 909",/* 29 beta */
"880 910", /* 30 beta */
"988  278", /* 31 beta */
"988  279", /* 32 beta */
"988  280", /* 33 beta */
"988  281", /* 34 beta */
"988  282", /* 35 beta */
"1046  298", /* 36 beta */
"1046  299", /* 37 beta */
"1046  300", /* 38 beta */
"1046  301", /* 39 beta */
"1046  302", /* 40 beta */
(char *) 0
};

/*
 * beats frequencies
 */
char *medium_o[] =
{
"131  132", /*1 delta */
"131  133", /*2 delta */
"131  134", /*3 delta */
"147  151", /*4 theta */
"147  152", /*5 theta */
"147  153", /*6 theta */
"147  154", /*7 theta */
"147  155", /*8 theta */
"156  165", /*9 altheta Re# */
"165  175", /*10 alpha */
"165  176", /*11 alpha */
"165  177", /*12 alpha */
"165  178", /*13 alpha */
"175  189", /*14 beta  */
"175  190", /*15 beta  */
"175  191", /*16 beta  */
"175  192", /*17 beta  */
"196  214", /*18 beta  */
"196  215", /*19 beta  */
"196  216", /*20 beta  */
"196  217", /*21 beta  */
"196  218", /*22 beta  */
"196  219", /*23 beta  */
"196  220", /*24 beta  */   /* solid beta */ /* to here 21:50, 27jan97 */
"220  245", /*25 beta  */
"220  246", /*26 beta  */
"220  247", /*27 beta  */
"220  248", /*28 beta  */
"220  249", /*29 beta  */
"220  250", /*30 beta  */
/* unused because unrealistic for audio beats; besides, too much for flashes */
"247  278", /* 31 beta */
"247  279", /* 32 beta */
"247  280", /* 33 beta */
"247  281", /* 34 beta */
"247  282", /* 35 beta */
"262  298", /* 36 beta */
"262  299", /* 37 beta */
"262  300", /* 38 beta */
"262  301", /* 39 beta */
"262  302", /* 40 beta */   /* fone 26jan97 */
(char *) 0
};


char *low_o[] =
{
"65 66", /* 1 delta */
"65 67", /* 2 delta */
"65 68", /* 3 delta */
"73 77", /* 4 theta */
"73 78", /* 5 theta */
"73 79", /* 6 thera */
"73 80", /* 7 theta */
"73 81", /* 8 theta */
"78 87", /* 9 altheta */ /* Re # */
"82 92", /* 10 alpha */
"82 93", /* 11 alpha */
"82 94", /* 12 alpha */
"82 95", /* 13 alpha */
"87 101", /* 14 beta  */
"87 102",/* 15 beta  */
"87 103",/* 16 beta  */
"87 104",/* 17 beta  */
"98 116",/* 18 beta  */
"98 117",/* 19 beta  */
"98 118",/* 20 beta  */
"98 119",/* 21 beta */
"98 120",/* 22 beta */
"98 121",/* 23 beta */
"98 122",/* 24 beta */
"110 135",/* 25 beta */
"110 136",/* 26 beta */
"110 137",/* 27 beta */
"110 138",/* 28 beta */
"110 139",/* 29 beta */
"110 140", /* 30 beta */
"123  154", /* 31 beta */
"123  155", /* 32 beta */
"123  156", /* 33 beta */
"123  157", /* 34 beta */
"123  158", /* 35 beta */
"131  167", /* 36 beta */
"131  168", /* 37 beta */
"131  169", /* 38 beta */
"131  170", /* 39 beta */
"131  171", /* 40 beta */
(char *) 0
};

#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>

int kill_id;

/*
 * given a beats string from the above arrays, do_beats calls ./beats
 * to play the binaural beats
 */

#ifndef __FreeBSD__
#include <sys/wait.h>  /* try with FBSD too... */
#endif

void
do_beats(char *two_tones) 
{
  char            tone_one[8], tone_two[8];
  int             id, pid, status, i;
  extern toggle   playing;

  program.emsg(nprint, "DEBUG: entering do_beats with [%s]\n",two_tones,_fl_);

  sscanf(two_tones, "%s %s", tone_one, tone_two);
  program.emsg(nprint, "\nENTERING\
    do_beats(): t1 = [%s], t2 = [%s], beatsPid = (%d)\n", 
    tone_one, tone_two, beatsPid, _fl_);

  if (beatsPid)   // catch virtually every muuzbeats_Pid here... .
  {
    kill_id = beatsPid;
    kill (beatsPid, SIGINT);
  }

  id = fork();
  switch (id) {
  case -1:
    program.emsg(error, "fork error\n", _fl_ );
    exit(1);

  case 0:
    execl(BEATSPATH, BEATSNAME, tone_one, tone_two, 0);
  }
  beatsPid = id;
  playing = on;
  program.emsg(nprint, "\nspawned muuzaudio pid=%d\n",beatsPid);
}


/***  audio headers and embedded audio-play routines ***/

#include "click.h"

void
do_click ()
{
  int    leftchannel, rightchannel;
  FILE *audio_fd;
  void XMuuzSetRightandLeftVolume(int, int);
  mixerControls audio;

  audio.getBothChannels(&rightchannel, &leftchannel);
  audio.XMuuzSetBothVolume( CLICK_VOLUME );

  if ((audio_fd = fopen ("/dev/audio", "w")) != NULL)
  {
      fwrite (click, CLICKSIZ, 1, audio_fd);
      fclose (audio_fd);
  }
  else
  {
      /* todo: put into XMuuzError ()  */

      program.emsg(error,  "Sorry: No `/dev/audio' available.\n", _fl_ );
  }
  audio.setRightAndLeftChannels(rightchannel, leftchannel);
}
