extern "C"
{
#include	<stdio.h>
#include <stdlib.h>
#include <string.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<sys/stat.h>
#include	<sys/types.h>
#include	<sys/ioctl.h>
#include	<machine/soundcard.h>
#include	<errno.h>
#include	<math.h>
}
#include "copyright.h"


#define DEF_DSP_DEVICE		"/dev/dsp"
#define	DEF_DSP_SPEED		44025	/* was 8000 hz */
#define	DEF_DSP_BITS		8	/* 8 bit dac */
#define	DEF_DSP_STEREO		1   	/* mono = 0, stereo = 1 */

char	*dsp_device = 	DEF_DSP_DEVICE;
int	speed =		DEF_DSP_SPEED;
int	bits =		DEF_DSP_BITS;
int	stereo =	DEF_DSP_STEREO;

#if	(DEF_DSP_BITS == 8)
typedef	unsigned char O_SIZE;
#define	ZERO	0x80
#elif	(DEF_DSP_BITS == 16)
typedef unsigned short O_SIZE;
#define	ZERO	0x8000
#else
error "Number of bits may only be 8 or 16."
#endif

#define FIFO_MODE 0777

int	beat1 = 256;	/* 400 hz */
int	beat2 = 264;	/* 600 hz */

main(int ac, char *av[])
{
	int	mkval, dsp;
	double	x1, x2, x;
	int	i, j;
	O_SIZE	o_buf[DEF_DSP_SPEED][DEF_DSP_STEREO + 1];

	if(ac > 1)
		beat1 = atoi(av[1]);
	if(ac > 2)
		beat2 = atoi(av[2]);

	if(beat1 > speed/8 || beat2 > speed/8) {
		fprintf(stderr, "%s: speed to high for dac setting.\n", av[0]);
		exit (1);
	}

	if((dsp=open(dsp_device, O_WRONLY, 0)) < 0) {
		fprintf(stderr, "%s: Couldn't open %s: %s.\n",
			av[0], dsp_device, strerror(errno));
		exit(-1);
	}

	/* Set speed, bits, stereo */
	if(ioctl(dsp, SNDCTL_DSP_SPEED, &speed) < 0) 
		fprintf(stderr, "%s: Couldn't set speed %s: %s.\n",
			av[0], speed, strerror(errno));
	if(ioctl(dsp, SNDCTL_DSP_STEREO, &stereo) < 0) 
		fprintf(stderr, "%s: Couldn't set channels %s: %s.\n",
			av[0], speed, strerror(errno));
	if(ioctl(dsp, SNDCTL_DSP_SAMPLESIZE, &bits) < 0) 
		fprintf(stderr, "%s: Couldn't set bits %s: %s.\n",
			av[0], speed, strerror(errno));
	x1 = 2 * M_PI * beat1 / speed;	/* left or mono channel */
	x2 = 2 * M_PI * beat2 / speed;	/* right channel */
	for(i=0; i < speed; i++) {
		o_buf[i][0] =
			(O_SIZE)((double)ZERO*(sin((double)i*x1)+(double)1.0));
		if(stereo) 
			o_buf[i][1] = 
			 (O_SIZE)((double)ZERO*(sin((double)i*x2)+(double)1.0));
	}
			
	for(;;) 
	{
		  write(dsp, o_buf, sizeof(o_buf));
	}

	close (dsp);
	exit(fprintf(stdout, "\n\n%s exiting\n", av[0]));
}
