
/*
 * $Id: muuzerror.c,v 1.3 2000/03/28 18:17:09 kline Exp kline $
 *
 *  here find error and warning messages.
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include "copyright.h"


short int proceed = 1;

void
XMuuzColorLookupError(const char *color)
{
        program.emsg(error, "Color Lookup error with color [%s]\n", color);
}
void
XMuuzColorAllocError(int which, const char *color)
{
  if (which == 0)
        program.emsg(error, "Default color allocation error with color [%s]\n",
          color);
  else if (which == 1)
        program.emsg(error, "Color allocation error with color [%s]\n", color);
}

void
XMuuzAudioFailure(int n, char *routine)
{
  program.emsg(error, "Audio Failure from [%s()]:  ", routine);
  switch(n)
  {
  case -1:
    program.emsg(error, " Failure Level 1\n");
    return;
    break;
  case -2:
    program.emsg(error, " Failure Level 2\n");
    return;
    break;
  case -3:
    program.emsg(error, " Failure Level 3\n");
    return;
    break;
  case -4:
    program.emsg(error, "Lethal Failure Level 4\n");
    exit(1);
  }
}


/* X11-error handler */
void XMuuzErrHandler(char *text)
{
#define  SBANG " ! "   /* bang string */
#define  SOKAY "Okay"  /* okay string */
  XFontStruct *init_font(Display *display, const char *fontName);  
   int slen = strlen(text);
   static XFontStruct *bangFont, *okayFont, *warningFont;
   Widget shell, dialogform;
   Widget command, exclaim, message;
   void  popupCentered(Widget _w);
   /**void bzero(void *, size_t );  * SunOS */
   void closeErrorCB(Widget w, XtPointer client_data, XtPointer call_data);

   XtCallbackRec   PopDown[2];  /* NOTE */ /* was [2] */
   static short int wstrlen = 300;  /* warning strlen */

   bzero(PopDown, sizeof(PopDown));

   PopDown[0].callback = closeErrorCB;
   if (slen <= 30) wstrlen = 300;
   else if (slen > 30 && slen <= 40) wstrlen = 400;
   else if (slen > 40) wstrlen = 500;


   shell = XtVaCreatePopupShell("dialog_shell", transientShellWidgetClass, top,
				XtNwidth, Do.resizeW(wstrlen), // req'd
				XtNheight, Do.resizeH(100), /* req'd */
				NULL);

   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, shell,
				XtNlabel, "",
				NULL);
    bangFont = init_font(display, NCS20);
    exclaim = XtVaCreateManagedWidget("exclaim", labelWidgetClass, dialogform,
				XtNfont, bangFont,
				XtNlabel, SBANG,
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight, Do.resizeH(25),
				XtNborderWidth, 0,
				XtNfromHoriz, NULL,
				XtNfromVert, NULL,
				XtNtop, XawChainTop,
				XtNbottom, XawChainTop,
				XtNleft, XawChainLeft,
				XtNright, XawChainLeft,
				NULL);
    warningFont = init_font(display, TBOLD18);
    message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
				XtNfont, warningFont,
				XtNlabel, text,
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight, Do.resizeH(25),
				XtNborderWidth, 0,
				XtNfromHoriz, NULL,
				XtNfromVert, exclaim,
				XtNtop, XawChainTop,
				XtNbottom, XawChainTop,
				XtNleft, XawChainLeft,
				XtNright, XawChainLeft,
				NULL);
   okayFont = init_font(display, NCS20);
   command = XtVaCreateManagedWidget("command", commandWidgetClass, dialogform,
				XtNfont, okayFont,
				XtNlabel, "Okay",
				XtNheight, Do.resizeH(25),
				XtNwidth, Do.resizeW(wstrlen),
				XtNborderWidth, 0,
				XtNfromHoriz, NULL,
				XtNfromVert, message,
				XtNcallback, PopDown,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
				NULL);
   popupCentered(shell);

}

void 
closeErrorCB(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(display);
}


void popupInUpperRight(Widget w)
{
#define Y_FROM_UPPER_RIGHT  10
#define X_FROM_UPPER_RIGHT 500

   extern int gheight, gwidth; /* gleaned in main.c */
   int win_x, win_y;
   int x, y;
   Dimension width, height, b_width;
   unsigned int mask;
   Window root, child;
   int num_args;
   Arg args[9];


   XtRealizeWidget(w);

   XQueryPointer(display, XtWindow(w),
                 &root,                 /* root window under the pointer */
                 &child,                /* child window under the pointer */
                 &x, &y,                /* pointer coords relative to root */
                 &win_x, &win_y,        /* pointer coords relative to window */
                 &mask);                /* state of modifier keys and buttons */

   num_args = 0;
   /**
   XtSetArg(args[num_args], XtNwidth, &width); num_args++;
   XtSetArg(args[num_args], XtNheight, &height); num_args++;
   XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;
   XtGetValues(w, args, num_args);

   width += 2 * b_width;
   height += 2 * b_width;

   x -= ((int) width/2);
   y -= ( (Position) height/2 );
    **/


   x = gwidth - X_FROM_UPPER_RIGHT;
   x = 770;  // very roughly 1280-502 (root width - popup width)
   y = 10;
   y = Y_FROM_UPPER_RIGHT;

   printf("PDEB: X = (%d), Y = (%d), WID = (%d), HEI = (%d)\n",
	x,y,width, height);

   num_args = 0;
   XtSetArg(args[num_args], XtNx, x); num_args++;
   XtSetArg(args[num_args], XtNy, y); num_args++;
   XtSetValues(w, args, num_args);

   // 
   // the XtGrabNone below means "don't freeze the buttons waiting for OK"
   //
   XtPopup(w, XtGrabNone);
}



static Widget shell_yesno;

/* X11-error handler */
void 
graphicWarning(Widget top)
{
  void popupOffCentered(Widget w);
  XtCallbackRec   KillProgram[2], CloseWarning[2];  /* NOTE */
  XFontStruct *warningFont, *noFont, *yesFont;
  char *warningString= W_STRING;
  Widget message, yes, no, dialogform;
  void popupCentered(Widget _w);
  void closeWarningWindowCB(Widget w,XtPointer client_data,XtPointer c_data);
  void quitAltogetherCB(Widget w, XtPointer client_data, XtPointer call_data);
  XFontStruct *init_font(Display *display, const char *fontName);  


  bzero(KillProgram, sizeof(KillProgram));
  bzero(CloseWarning, sizeof(CloseWarning));
  KillProgram[0].callback = quitAltogetherCB;
  CloseWarning[0].callback = closeWarningWindowCB;

   //
   // leave this the same size within reason and with Do.resize[HW]
   //
   shell_yesno = XtVaCreatePopupShell("dialog_shell",transientShellWidgetClass,
     top,
     XtNwidth, Do.resizeW(800), // 758
     XtNheight, Do.resizeH(625), /* this (shellWidget) must be larger because of yes/no */
     NULL);

  if (depth > 8)
  {
   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, 
     shell_yesno,
     XtNbackground, yellow_color.pixel,
     XtNlabel, "",
     NULL);
  }
  else
  {
   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, 
     shell_yesno,
     XtNbackground, yellow,
     XtNlabel, "",
     NULL);
  }


   warningFont = init_font(display, NCS18);
  if(depth>8)
   message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
                                XtNfont, warningFont,
                                XtNlabel, warningString,
      				XtNforeground,darkblue_color.pixel,
      				XtNbackground,  red_color.pixel,
                                XtNwidth, Do.resizeW(800),
                                XtNheight, Do.resizeH(575),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
				NULL);
  else
   message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
                                XtNfont, warningFont,
                                XtNlabel, warningString,
      				XtNforeground,darkblue,
      				XtNbackground,  red, //orange,
                                XtNwidth, Do.resizeW(800),
                                XtNheight, Do.resizeH(575),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
				NULL);

   yesFont = init_font(display, NCS14);
  if(depth>8)
   yes = XtVaCreateManagedWidget("yes", commandWidgetClass, dialogform,
                                XtNfont, yesFont,
                                XtNlabel, W_YES, //"Yes",
      				XtNbackground,   yellow_color.pixel,
      				XtNforeground, blue_color.pixel,
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(50),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, message,
                                XtNcallback, CloseWarning,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
  else
   yes = XtVaCreateManagedWidget("yes", commandWidgetClass, dialogform,
                                XtNfont, yesFont,
                                XtNlabel, W_YES, //"Yes",
      				XtNbackground,   yellow,
      				XtNforeground, blue,
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(50),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, message,
                                XtNcallback, CloseWarning,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);

   noFont = init_font(display, NCS14);
  if(depth>8)
   no = XtVaCreateManagedWidget("no", commandWidgetClass, dialogform,
                                XtNfont, noFont,
                                XtNlabel, W_NO, //"No",
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(50),
      				XtNbackground, blue_color.pixel,
      				XtNforeground, yellow_color.pixel,
                                XtNborderWidth, 0,
                                XtNfromHoriz, yes,
                                XtNfromVert, message,
                                XtNcallback, KillProgram,
				XtNtop, XawChainTop, 
				XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
  else
   no = XtVaCreateManagedWidget("no", commandWidgetClass, dialogform,
                                XtNfont, noFont,
                                XtNlabel, W_NO, //"No",
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(50),
      				XtNbackground, blue,
      				XtNforeground, yellow,
                                XtNborderWidth, 0,
                                XtNfromHoriz, yes,
                                XtNfromVert, message,
                                XtNcallback, KillProgram,
				XtNtop, XawChainTop, 
				XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
   //popupCentered(shell_yesno);
   popupOffCentered (shell_yesno);
}

void 
closeWarningWindowCB(Widget w, XtPointer client_data, XtPointer call_data)
{
   extern Widget shell_yesno;

   /**puts("DEB: closed down Warning: ready to continue program??");**/
   XtPopdown(shell_yesno);
   XtDestroyWidget(shell_yesno);
   XFlush(display);
}

void 
quitAltogetherCB(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(display);
   exit(0);
}


void 
popupCentered(Widget w)
{
   int win_x, win_y, x, y, num_args = 0;
   Dimension width, height, b_width;
   unsigned int mask;
   Window root, child;
   Arg args[9];

   XtRealizeWidget(w);
   XQueryPointer(display, XtWindow(w),
                 &root,                 /* root window under the pointer */
                 &child,                /* child window under the pointer */
                 &x, &y,                /* pointer coords relative to root */
                 &win_x, &win_y,        /* pointer coords relative to window */
                 &mask);                /* state of modifier keys and buttons */

   XtSetArg(args[num_args], XtNwidth, &width); num_args++;
   XtSetArg(args[num_args], XtNheight, &height); num_args++;
   XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;
   XtGetValues(w, args, num_args);

   width += 2 * b_width;
   height += 2 * b_width;

   x -= ((int) width/2);
   y -= ( (Position) height/2 );

   num_args = 0;
   XtSetArg(args[num_args], XtNx, x); num_args++;
   XtSetArg(args[num_args], XtNy, y); num_args++;
   XtSetValues(w, args, num_args);

   XtPopup(w, XtGrabExclusive);
}

short int popOnce = 0;
/*
 * X11 information of each pre-programmed program status. (until finished) 
 *  thereafter, this popup may be a large label with a description of the
 *  pre-programmed performance.
 */


void 
XMuuzPrepInformation(char *function, char *version)
{
#define  SBANG " ! "   /* bang string */
#define  SINFO " is a preliminary version:"
#define  SOKAY "Okay"  /* okay string */
   XFontStruct *init_font(Display *display, const char *fontName);
   static XFontStruct *bangFont, *dismissFont, *warningFont;
   Widget pi_shell, dialogform; // re-naming this shell -> pi_shell if goes Gbl
   Widget command, exclaim, message;
   void  popupCentered(Widget _w);
   void closeErrorCB(Widget w, XtPointer client_data, XtPointer call_data);
   char informational[64];
   XtCallbackRec   PopDown[2];
   static short int wstrlen = 300;  /* default warning strlen: npixels */
   int slen;
  
   bzero(PopDown, sizeof(PopDown));
   sprintf(informational, "%s %s %s", function, SINFO, version);
   proceed = 0;
   slen = strlen(informational);
   PopDown[0].callback = closeErrorCB;
   if (slen <= 30) wstrlen = 300;
   else if (slen > 30 && slen <= 40) wstrlen = 400;
   else if (slen > 40) wstrlen = 500;


   pi_shell =XtVaCreatePopupShell("dialog_shell",transientShellWidgetClass,top,
                                XtNwidth, Do.resizeW(wstrlen), /* req'd: was `300' */
                                XtNheight, Do.resizeH(100), /* req'd */
                                NULL);

   dialogform = XtVaCreateManagedWidget ("dialogform",formWidgetClass,pi_shell,
                                XtNlabel, "",
                                NULL);
    bangFont = init_font(display, NCS20);
    exclaim = XtVaCreateManagedWidget("exclaim", labelWidgetClass, dialogform,
                                XtNfont, bangFont,
                                XtNlabel, SBANG,  
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight, Do.resizeH(25),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, NULL,
                                XtNtop, XawChainTop, 
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL); 
    warningFont = init_font(display, TBOLD18);
    message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
                                XtNfont, warningFont,
                                XtNlabel, informational,
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight,Do.resizeH(25),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, exclaim,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);

   dismissFont = init_font(display, NCS20);
   command = XtVaCreateManagedWidget("command", commandWidgetClass, dialogform,
                                XtNfont, dismissFont,
                                XtNlabel, "Dismiss",
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, message,
                                XtNcallback, PopDown,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);

   popupInUpperRight(pi_shell);

}

/* Tell the user that the called functionality is not ready for PrimeTime */
void XMuuzErrUnimplemented()
{
#define  SBANG " ! "   /* bang string */
#define  SOKAY "Okay"  /* okay string */
#define  SUNIMP "This hasn't been implemented (finished!) yet"

  XFontStruct *init_font(Display *display, const char *fontName);
   //int slen = strlen(text);     May use this later on.... (27jul99)
   static XFontStruct *bangFont, *okayFont, *warningFont;
   Widget shell, dialogform;
   Widget command, exclaim, message;
   void  popupCentered(Widget _w);
   /**void bzero(void *, size_t );  * SunOS */
   void closeErrorCB(Widget w, XtPointer client_data, XtPointer call_data);

   XtCallbackRec   PopDown[2];  /* NOTE */ /* was [2] */
   static short int wstrlen = 500;  /* warning strlen */

   bzero(PopDown, sizeof(PopDown));

   PopDown[0].callback = closeErrorCB;

   /***
    *** save for possible future use.
    ***
   if (slen <= 30) wstrlen = 300;
   else if (slen > 30 && slen <= 40) wstrlen = 400;
   else if (slen > 40) wstrlen = 500;
    ***/



   shell = XtVaCreatePopupShell("dialog_shell", transientShellWidgetClass, top,
                                XtNwidth, Do.resizeW(wstrlen), /* req'd: was `300' */
                                XtNheight, Do.resizeH(100),  /* req'd */
                                NULL);

   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, shell,
                                XtNlabel, "",
                                NULL);
    bangFont = init_font(display, NCS20);
    exclaim = XtVaCreateManagedWidget("exclaim", labelWidgetClass, dialogform,
                                XtNfont, bangFont,
                                XtNlabel, SBANG,
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight, Do.resizeH(25),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, NULL,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
    warningFont = init_font(display, TBOLD18);
    message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
                                XtNfont, warningFont,
                                XtNlabel, SUNIMP,
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNheight, Do.resizeH(25),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, exclaim,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
   okayFont = init_font(display, NCS20);
   command = XtVaCreateManagedWidget("command", commandWidgetClass, dialogform,
                                XtNfont, okayFont,
                                XtNlabel, "Okay",
                                XtNheight, Do.resizeH(25),
                                XtNwidth, Do.resizeW(wstrlen),
                                XtNborderWidth, 0,
                                XtNfromHoriz, NULL,
                                XtNfromVert, message,
                                XtNcallback, PopDown,
                                XtNtop, XawChainTop,
                                XtNbottom, XawChainTop,
                                XtNleft, XawChainLeft,
                                XtNright, XawChainLeft,
                                NULL);
   popupCentered(shell);

}
/* 
 *  If fatal error, popup an explanatory message diaoolgue for the user
 *  to reply [Understand] on; then exit(1) the app.
 */
void XMuuzFatalErr(char *text)
{
#define  SBANG " ! "   /* bang string */
#define  SUNDERSTAND "Understand"  /* okay string */

  //XFontStruct *init_font(Display *display, const char *fontName);
   int slen = strlen(text); 
   static XFontStruct *bangFont, *okayFont, *warningFont;
   Widget shell, dialogform;
   Widget command, exclaim, message;
   void  popupCentered(Widget _w);
   void closeFatalCB(Widget w, XtPointer client_data, XtPointer call_data);
   XtCallbackRec   PopDown[2];  /* NOTE */ /* was [2] */
   static short int wstrlen = 500;  /* warning strlen */
   
   bzero(PopDown, sizeof(PopDown));
   PopDown[0].callback = closeFatalCB;
   
   if (slen <= 30) wstrlen = 300;
   else if (slen > 30 && slen <= 40) wstrlen = 400;
   else if (slen > 40) wstrlen = 500;
   
   shell = XtVaCreatePopupShell("dialog_shell", transientShellWidgetClass, 
     top,
     XtNwidth, wstrlen,//Do.resizeW(wstrlen),
     XtNheight, 100,//Do.resizeH(100),  /* req'd */
     NULL);
                                
   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, shell,
	XtNlabel, "", NULL);

    //bangFont = init_font(display, NCS20);
    exclaim = XtVaCreateManagedWidget("exclaim", labelWidgetClass, dialogform,
     //XtNfont, bangFont,  
     XtNlabel, SBANG,
     XtNwidth, wstrlen,//Do.resizeW(wstrlen),
     XtNheight, 25, //Do.resizeH(25),
     XtNborderWidth, 0,
     XtNfromHoriz, NULL,
     XtNfromVert, NULL,
     XtNtop, XawChainTop,
     XtNbottom, XawChainTop,
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft, NULL);

    //warningFont = init_font(display, TBOLD18);
    message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
      //XtNfont, warningFont,
      XtNlabel, text,
      XtNwidth, wstrlen, //Do.resizeW(wstrlen),
      XtNheight, 25, //Do.resizeH(25),
      XtNborderWidth, 0,
      XtNfromHoriz, NULL,
      XtNfromVert, exclaim,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);

   //okayFont = init_font(display, NCS20);
   command = XtVaCreateManagedWidget("command", commandWidgetClass, dialogform,
     //XtNfont, okayFont,
     XtNlabel, "Understood",
     XtNheight, 25, //Do.resizeH(25),
     XtNwidth, wstrlen, //Do.resizeW(wstrlen),
     XtNborderWidth, 0,
     XtNfromHoriz, NULL,
     XtNfromVert, message,
     XtNcallback, PopDown,
     XtNtop, XawChainTop,
     XtNbottom, XawChainTop,
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft, NULL);

   popupCentered(shell);
}

void
closeFatalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(display);
   exit(1);
}

/* X11-error handler */
void 
XMuuzMessagePopupHandler(char *text)
{
#define  SBANG " ! "   /* bang string */
#define  SOKAY "Okay"  /* okay string */
  XFontStruct *init_font(Display *display, const char *fontName);  
   int slen = strlen(text);
   static XFontStruct *bangFont, *okayFont, *warningFont;
   Widget shell, dialogform;
   Widget command, exclaim, message;
   void  popupCentered(Widget _w);
   void closeErrorCB(Widget w, XtPointer client_data, XtPointer call_data);
   XtCallbackRec   PopDown[2];
   short int hstrlen = 500, wstrlen = 500;

   bzero(PopDown, sizeof(PopDown));
   PopDown[0].callback = closeErrorCB;
   //if (slen <= 30) wstrlen = 500;
   //else if (slen > 30 && slen <= 40) wstrlen = 400;
   //else if (slen > 40) wstrlen = 500;


   shell = XtVaCreatePopupShell("dialog_shell", transientShellWidgetClass, top,
	XtNwidth, Do.resizeW(wstrlen), // req'd
	XtNheight, Do.resizeH(400), /* req'd */
	NULL);

   dialogform = XtVaCreateManagedWidget ("dialogform", formWidgetClass, shell,
	XtNlabel, "",
	NULL);
    bangFont = init_font(display, NCS20);
    exclaim = XtVaCreateManagedWidget("exclaim", labelWidgetClass, dialogform,
	XtNfont, bangFont,
	XtNlabel, SBANG,
	XtNwidth, Do.resizeW(wstrlen),
	XtNheight, Do.resizeH(25),
	XtNborderWidth, 0,
	XtNfromHoriz, NULL,
	XtNfromVert, NULL,
	XtNtop, XawChainTop,
	XtNbottom, XawChainTop,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft, NULL);

    warningFont = init_font(display, TBOLD18);
    message = XtVaCreateManagedWidget("message", labelWidgetClass, dialogform,
	XtNfont, warningFont,
	XtNlabel, text,
	XtNwidth, Do.resizeW(wstrlen),
	XtNheight, Do.resizeH(300),
	XtNborderWidth, 0,
	XtNfromHoriz, NULL,
	XtNfromVert, exclaim,
	XtNtop, XawChainTop,
	XtNbottom, XawChainTop,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft, NULL);

   okayFont = init_font(display, NCS20);
   command = XtVaCreateManagedWidget("command", commandWidgetClass, dialogform,
	XtNfont, okayFont,
	XtNlabel, "Okay",
	XtNheight, Do.resizeH(25),
	XtNwidth, Do.resizeW(wstrlen),
	XtNborderWidth, 0,
	XtNfromHoriz, NULL,
	XtNfromVert, message,
	XtNcallback, PopDown,
	XtNtop, XawChainTop,
	XtNbottom, XawChainTop,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft, NULL);
   popupCentered(shell);
}



void 
popupOffCentered(Widget w)
{
   Position win_x, win_y, x, y, num_args = 0;
   Arg args[2];

   XtRealizeWidget(w);
  //
  // here, rely on the global height and width and offset them from 
  // center point.
  //
   x = (Position)((gwidth/2)- (gwidth/2)*0.75);
   y = (Position)((gheight/2)-(gheight)*0.45); //0.43 ok
   num_args = 0;
   XtSetArg(args[num_args], XtNx, x); num_args++;
   XtSetArg(args[num_args], XtNy, y); num_args++;
   XtSetValues(w, args, num_args);

   XtPopup(w, XtGrabExclusive);
}
