/*
 * $Id: muuzmenu.c,v 1.6 2000/02/17 02:29:44 kline Exp kline $
 */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <signal.h>

#include "muuztypes.h"
#include "callbacks.h"
#include "muuzaudio.h"
#include "muuzmenu.h"
#include "errMessage.h"
#include "misc.h"
#include "main.h"

#include "do_colors.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"

extern errMessage program;  // for emsg()


static Widget   textShellwidget;


void
popDownMenus(Widget form)
{ 
  Widget          button1;
  Widget          button2;
  Widget          button3;
  Widget          dummybutton;
  //xcolor_t smokewhite;
  //XColor   smokewhite_color;


  /******  Create 3 menu buttons for drop-down upon click menus ******/
  button1 = XtVaCreateManagedWidget("button1",menuButtonWidgetClass,form,
    XtNmenuName, "menu1", 
    XtNlabel, " File ",
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNleft, XawChainLeft,  /* Chain *both* edges to */     
    XtNright, XawChainLeft, /* the left-most formedge*/     
    NULL);

  button2 = XtVaCreateManagedWidget("button2",menuButtonWidgetClass,form,
    XtNfromHoriz, button1,
    XtNlabel, " WhatEver ",
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNleft, XawChainLeft,  /* Chain *both* edges to */
    XtNright, XawChainLeft, /* the File button       */
   XtNmenuName, "menu2",
    NULL);

  button3 = XtVaCreateManagedWidget("button3",menuButtonWidgetClass,form,
    XtNfromHoriz, button2,
    XtNlabel, " Help ",
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNhorizDistance, Do.resizeW(655), /* set WIDTH of 'menuform' */
    XtNmenuName, "menu3",
    XtNleft, XawChainRight,   // was XawChainRight (15feb00)
    XtNright, XawChainRight,   // was XawChainRight (15feb00)
    NULL);

  /*
   *  fill out the menu bar
   */
  if (depth > 8)
    dummybutton = XtVaCreateManagedWidget("dummybutton", labelWidgetClass, form,
        XtNfromHoriz, button3,
        XtNlabel, L_DUMMY,
        XtNfromVert, NULL,
        XtNbackground, whitesmoke_color.pixel,
        XtNhorizDistance,  Do.resizeH(25),
        XtNborderWidth, 0,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft, NULL);
  else
    dummybutton = XtVaCreateManagedWidget("dummybutton", labelWidgetClass, form,
        XtNfromHoriz, button3,
        XtNlabel, L_DUMMY,
        XtNfromVert, NULL,
        XtNbackground, whitesmoke,
        XtNhorizDistance,  Do.resizeH(25),
        XtNborderWidth, 0,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft, NULL);
    
  (void) createFilePullDown(button1);
  (void)createSecondPullDown(button2);
  (void) createHelpPullDown(button3);
   
}
void
print_string(Widget w, XtPointer client, XtPointer call)
{
  // Leaving this way for now, 28aug99: printf("%s\n", (char *)client);
}

void
iconifyCB(Widget w, XtPointer client, XtPointer call)
{
  Window win = XtWindow(top);
  int screen_number = DefaultScreen(display);

/*
SYNTAX
       Status XIconifyWindow(display, w, screen_number)
             Display *display;
             Window w;
             int screen_number;
 */
  XIconifyWindow(display, win, screen_number);

}

/*
 * we prob'ly should just call the one main quitCB in cancelconfirm.c (??)
 */

void
quit_callback(Widget w, XtPointer client, XtPointer call)
{ 
  if (beatsPid)
  {
    program.emsg(nprint,"quit_callback(): exiting with beatsPid = (%d)\n",
      beatsPid,_fl_);
    kill(beatsPid, SIGINT);
  }
  exit(0);
} 
  
void
createFilePullDown(Widget button1)
{ 
  Arg wargs[1];
  int n = 0;
  Widget          entry;
  Widget          line1;
  Widget          menu1;
  Widget          quit;
  /*
   * create the first pull down menu
   */
  
  XtSetArg(wargs[n], XtNlabel, " FileLabel "); n++;
  menu1 = XtCreatePopupShell("menu1", simpleMenuWidgetClass, button1, wargs, n);
  
  entry = XtCreateManagedWidget("New File", smeBSBObjectClass, menu1, NULL, 0);
  
  XtAddCallback(entry, XtNcallback, print_string, (char *)"one");
  
  entry = XtCreateManagedWidget("Open File", smeBSBObjectClass, menu1, NULL, 0);
  
  XtAddCallback(entry, XtNcallback, print_string, (char *)"two");
  
  entry = XtCreateManagedWidget("View File", smeBSBObjectClass, menu1, NULL, 0);
  XtAddCallback(entry, XtNcallback, print_string, (char *)"ViewFile"); 
  
  entry = XtCreateManagedWidget("Iconify", smeBSBObjectClass, menu1, NULL, 0);
  XtAddCallback(entry, XtNcallback, iconifyCB, NULL); 
  
  line1 = XtCreateManagedWidget("line3", smeLineObjectClass, menu1, NULL, 0);
  
  quit = XtCreateManagedWidget("Quit", smeBSBObjectClass, menu1, NULL, 0);
  
  XtAddCallback(quit, XtNcallback, quit_callback, NULL);
  
  
} 
/* 
 * create the informational and Help pull down menu
 */
void
createHelpPullDown(Widget button3)
{ 
  Arg wargs[1];
  int n = 0;
  /****  the Help Files themselves ****/
  char *aboutMuuz  = P_HELPABOUT;
  char *helpFile00 = P_HELPOVER;
  char *helpFile01 = P_HELPCONP;  // help Console Panel
  char *helpFile02 = P_HELPPREP;
  char *helpFile03 = P_HELPUSER;
  char *acknowledgements = P_ACK;

  void Help_menusCB(Widget w, XtPointer client, XtPointer call);
  Widget entry, menu3, quit;
  
  XtSetArg(wargs[n], XtNlabel, " HelpLabel "); n++;
  menu3 = XtCreatePopupShell("menu3", simpleMenuWidgetClass, button3, wargs, n);

  entry = XtCreateManagedWidget("About ", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)aboutMuuz);

  entry = XtCreateManagedWidget("Overview", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)helpFile00);

  entry = XtCreateManagedWidget("Help 1", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)helpFile01);

  entry = XtCreateManagedWidget("Help 2", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)helpFile02);

  entry = XtCreateManagedWidget("Help 3", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)helpFile03);

  entry=XtCreateManagedWidget("Acknowledements",smeBSBObjectClass,menu3,NULL,0);
  XtVaSetValues(entry, XtNforeground, black_color,
    XtNbackground, black_color, NULL);
  XtAddCallback(entry, XtNcallback, popupHelpCB, (XtPointer)acknowledgements);

  quit = XtCreateManagedWidget("quit", smeBSBObjectClass, menu3, NULL, 0);
  XtVaSetValues(quit, XtNforeground, black_color,
    XtNbackground, black_color, NULL);

  
  XtAddCallback(quit, XtNcallback, quit_callback, NULL);
} 

void
createSecondPullDown(Widget button2)
{     
  Arg wargs[10];  /* 10 -> 1?? */
  int n = 0;  
  Widget menu2, line2, quit;
  /*
   * create the second pull down menu
   */ 
  
  XtSetArg(wargs[n], XtNlabel, " Label "); n++;
  menu2 = XtCreatePopupShell("menu2", simpleMenuWidgetClass, button2, wargs, n);
   
  line2 = XtCreateManagedWidget("line2", smeLineObjectClass, menu2, NULL, 0);  
  
  quit = XtCreateManagedWidget("quit", smeBSBObjectClass, menu2, NULL, 0);
  
  XtAddCallback(quit, XtNcallback, quit_callback, NULL);  
   
} 

//
// fg/bg poup colors go *here*
//

void
popupHelpCB(Widget w, XtPointer client_data, XtPointer call_data)
{  
  XFontStruct *init_font(Display *display, const char *fontName), *fontText;
  Widget popDownButton(Widget parent);
  Widget form, text;
  Arg wargs[10];
  char *filename = (char *)client_data;
  int             n = 0, x,y;

  /*
   * position the popup shell widget about a quarter off-center over and
   * a third down from the top of the root//CRT display
   */

  x = (Position)((gwidth/2)- (gwidth/2)*0.25);
  y = (Position)((gheight/2)-(gheight)*0.33);

  program.emsg(nprint, 5,
    "popupHelpCB():  gwidth =(%d), gheight = (%d), x = (%d), y (%d)\n",
      gwidth,gheight,x, y);

  /*
   * The asciiText box will be a pop-up widget placed at x/y.  
   */
  textShellwidget = XtVaCreatePopupShell("Informational", 
    transientShellWidgetClass, top,  XtNx, x, XtNy, y, NULL);
  /*
   * Make a form to put the buttons in.
   */
  fontText = init_font(XtDisplay(top), TBOLD14);
  form = XtCreateWidget("Buttons", formWidgetClass, textShellwidget, NULL, 0);
  XtSetArg(wargs[n], XtNfont, fontText); n++;
  XtSetArg(wargs[n], XtNfromVert, popDownButton(form)); n++;
  XtSetArg(wargs[n], XtNtype, XawAsciiFile); n++;
  XtSetArg(wargs[n], XtNstring, filename); n++;
  XtSetArg(wargs[n], XtNwidth, Do.resizeW(475) ); n++;    // popup page Width
  XtSetArg(wargs[n], XtNheight, Do.resizeH(550) ); n++;   // popup page Length
  XtSetArg(wargs[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
  XtSetArg(wargs[n], XtNscrollVertical, XawtextScrollAlways); n++;
  XtSetArg(wargs[n], XtNbackground, white_color); n++;
  XtSetArg(wargs[n], XtNforeground, black_color); n++;
  text = XtCreateManagedWidget("text", asciiTextWidgetClass, form, wargs, n);
  XtManageChild(form);   /* manage form */

  /****
  if (depth > 8)
    XtVaSetValues(text, XtNforeground, darkblue_color.pixel,
      XtNbackground, whitesmoke_color,  NULL);
  else
    XtVaSetValues(text, XtNforeground, darkblue, 
      XtNbackground, whitesmoke_color, NULL);
  		UNCLEAR HOW THIS WORKS EXACTLY...

		*/


  XtRealizeWidget(textShellwidget);  /* Realize the PopUp */

  /*
   * Pop up the confirmation box.
   */
  XtPopup(textShellwidget, XtGrabExclusive);
}
/*
 * popDownAscii - pop down the Help screen.
 */
void
popDownAscii(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown(textShellwidget);
}

Widget
popDownButton(Widget parent)
{
  Widget  framebutton;

  framebutton = XtCreateManagedWidget("Xquit",commandWidgetClass,parent,NULL,0);
    
  if (depth > 8)
    XtVaSetValues(framebutton, XtNforeground, darkblue_color.pixel,
      XtNbackground, white_color,  XtNshadowWidth, 3,  NULL);
  else
    XtVaSetValues(framebutton, XtNforeground, darkblue,  // private colormap
      XtNbackground, white_color,  XtNshadowWidth, 3, NULL);

  XtAddCallback(framebutton, XtNcallback, popDownAscii, NULL);
  return(framebutton);
}

