/*
  $Id: muuztypes.h,v 1.1 2000/01/29 20:44:40 kline Exp kline $
 *        typedefs for muuz
 */

#ifndef _MUUZTYPES_H_ 
#define _MUUZTYPES_H_ 


#define C_PP 1

#ifndef C_PP
typedef enum __boolean {false, true} boolean;
#else
typedef bool boolean;
#endif

typedef enum __toggle {off, on} toggle;
typedef int action_t;                   /* stop, pause, or play   */
typedef int audiovideo_t;                 /* audio, visual, | A+V   */
typedef int colors_t;                     /* colors in flashdisplay */
typedef int findex_t;                     /* flag counter type      */
typedef int pitch_t;                      /* 4 octaves of pitch     */
typedef int volume_t;                     /* 11 degrees of volume   */
typedef int flag_t;               /* all cXX_flag types     */
typedef int frequency_t;
typedef int octave_t;
typedef int category_t;    /* for formerly prepmode -> programCategory */
//typedef unsigned long xcolor_t;
typedef Pixel xcolor_t;


/*      Don't touch seconds_t      */
typedef int seconds_t;



extern toggle controlpanelstate, prepstate, userstate;
extern action_t sspmode;
extern audiovideo_t muuzmode;
extern colors_t colorsmode;
extern frequency_t frequency;
extern volume_t volume;
extern category_t  programCategory;


/* pre-programmed category flags */
extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
  cfu_flag;

/* prep mode counters: 1 to N */
extern findex_t ccr, clr, crx, cmd, csl, cen, cfu;


extern xcolor_t blue, green, grey, grey85, lightskyblue, orange,
    lightpink, pink, red, darkblue, slategrey, yellow;

#endif /* !_MUUZTYPES_H_ */ 

