/*
 * all or most callbacks live here
 *
 * $Id: prepcallbacks.c,v 1.7 2000/05/01 16:42:02 kline Exp kline $
 */

#include <X11/Intrinsic.h>

#include "muuztypes.h"
#include <signal.h>
#include "callbacks.h"
#include "do_colors.h"

#include "iconmuuz.h"
#include "muuz.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"
#include "flashForm.h"
#include "misc.h"
#include "main.h"
#include "muuzaudio.h"

extern errMessage program;  // for emsg()


/** 3d includes */
#include "/usr/X11R6/include/X11/Xaw3d/ThreeD.h"

/* Program mode flags  */

flag_t    ccr_flag,  /* creativity     */
	  clr_flag,  /* learning       */
	  crx_flag,  /* relaxation     */
	  cmd_flag,  /* meditation     */
	  cen_flag,  /* energize       */
	  csl_flag,  /* sleep          */
	  cfu_flag;  /* fun|recreation */

/* Program mode-flag counters: these are initialized to -1 in main.c */
findex_t ccr, clr, crx, cmd, csl, cen, cfu;


/*
 * pre-programmed categories:: the actual program selections
 */
char *c_cr[] =
{
"New Mindset",    /* 1-27Hz:: 17m */
"Visualization",    /* 3-13Hz  29m  (of ramps) */
"Alert Creativity",  /* 10-30hz:: 27m */
"Imagineering",     /* 4-30hz:: 49m */
"Problem Solving", /* 7-30Hz:: 49min */
"Inspiration",         /* 4-14hz:: 17min */
(char *)0
}; 
//#define NUM_CR  NUMBER(6)  // In prepcallbacks.h
/*                                                   | <-limit  */
  /*** Labels for c_cr (creativity) programs ***/
char *label_cr[] =
{
"New Mindset ramps to and fro throughout a 27 hertz\n\
wavestate to encourage new ways of understanding\n\
things with a renewed inspiration.  It refreshes mind\n\
and body to let you see in a creative new manner.",

"Vizualization ramps from 3 to 13Hz over 29 minutes in a manner\n\
demonstrated to enhance visualization.  This light-sound is one\n\
of the most playful and innovative in the entire series.\n\
             ",

"This program ranges over the higher alpha wavestates and the\n\
entire beta range from 14 to 30 hertz.  Ramping and sailing among\n\
a 20Hz range, the purpose of Alert Creativity is to inspire the\n\
limits of your creative ability while you are complete alert.   ",

"Ranging from the lowest theta wavestate to the highest beta,\n\
Imagineering is designed to stimulate maximum creativity and\n\
imagination.  Using ramping techniques like others in this   \n\
category, Imagineering leaves you at a relaxed-alert 13 Hertz.",


"Problem Solving spends most of its 49 minutes in the theta and\n\
alpha wavestates, ramping occassionally into the higher beta\n\
levels.  Take a break from your ordinary reality and see how   \n\
many problem you can resolve with the light-sound program.\n", 
  
"Using techiques similar to those in Problem Solving, in just\n\
17 minutes Inspiration is designed to inspire new ways of      \n\
understanding.  This programs works over a 10 hertz range, from\n\
low theta to low beta, concluding at 14Hz.                     ",

(char)0
};

 
char *c_lr[] =
{
"Logical" ,        /* 4-30hz:: 39 */
"Languages",       /* 3-12hz:: 41 */
"Preparation",     /* 3-20hz:: 27 */
"Assimilation",    /* 5-12hz:: 49 */
"Before Study",    /* 3-15Hz:: 13 */
"Retain After",    /* 1-13Hz:: 14 */
(char *)0
};
//#define NUM_LR  NUMBER(6)    // in prepcallbacks.h

char *label_lr[] =
{
"low theta to low beta, concluding at 14Hz.                     ",

(char)0
};


char *c_rx[] =
{
"Unwind",        /* 3-30Hz:: 13m */
"Tranquility",   /* 2-13hz:: 31m */
"Power Relax",   /* 8-11hz:: 17m */
"Stress Relief", /* 2-11hz:: 33m */
"Pain Relief",   /* 4-14hz:: 37m */
"Relax Return",  /* 3-17hz:: 45m */
"Cool Calmness", /* 3-13hz:: 25m */
"Deep Decompress", /* 1-30:: 31m */
(char *)0
};
//#define NUM_RX  NUMBER(8)    // in prepcallbacks.h

char *label_rx[] =
{
"Unwind is designed to unwind, relax, and calm you in only 13\n\
minutes.  Rapid decompression is achieved by descending quickly\n\
from a high 30Hz brainwave state to a mid-alpha state, then\n\
remaining for several minutes before deepening into theta and delta.",

"Beginning at the most alert alpha wavestate, Tranquility \n\
decends slowly, smoothly from the deepest alpha and further\n\
through theta to delta.  After some minutes at delta we return\n\
to the theta range and ends after several minutes at 5Hz.           ",

/*---------Range-------------------------------------------- */

"Within 17 minutes, Power Relax leads you from an 11Hz alpha \n\
wavestate to the deepest Alpha-Theta range at 8Hz.  Slowly,\n\
smoothly, this program staircases from higher to lower; after\n\
one-and-a-half steps, concluded at a relaxing, aware Altheta.     ",

"Stress Relief begins at mid-high Alpha and leads to a profound\n\
2Hz Delta wavestate where it balances, harmonizes, and centers\n\
you for 11 minutes before the program brings you back to a \n\
high-theta wavestate.                                                         ",

"Pain Relief follows the protocols of Cox and Shealy whose\n\
experimentation showed significantly improved levels of beta-\n\
endorphin using light-sound stimulation similar to this program.\n\
It spends 25 minutes at mid-alpha and 5 minutes at mid-theta.      ",

 (char *)0
};


			/* Meditations */

char *c_md[] =
{
"zazen",           /* 2-14hz:: 41m */
"sesshin",         /* 1-24hz:: 67m */
"earth meditation", /* 3-24hz:: 31m */
"AUM",  /* 2-28hz:: 35 */
"Kundalini", /*  7-16hz:: 37 */
"Awake Rest", /*  2-16hz:: 49 */
(char *)0
};
//#define NUM_MD  NUMBER(6)    // in prepcallbacks.h


char *c_sl[] =
{
"Nap",          /* 2-12hz:  33 */
"Goodnight",    /* 1-14hz:  41 */
"Relax into",  /* 1-13hz :: 37 */
"Sweet Dreams",/* 1-11hz::  31 */
"Knockout",    /* 1-10hz::  27 */  
"Sleep-Wake",  /* 1-30hz::  57 */  
(char *)0
};
//#define NUM_SL  NUMBER(6)   // in prepcallbacks.h


char *c_en[] =
{
"Zoom",       /* 5-7, 9-17:30:: 11 */
"Hi-Energy",  /* 7-23hz:: 13 */
"PowerBoost", /* 2-24hz:: 23 */
"Ramp Up",    /* 1-27hz:: 15 */
"Workout",    /* 1-21hz:: 19 */
"Fuel",       /* 4-25hz:: 17 */
"Erotic Energy", /* 17-5hz:: 19 */
(char *)0
};
//#define NUM_EN  NUMBER(7)   // in prepcallbacks.h


char *c_fu[] =
{ 
"Joker",	/* 7-17, 1,3,5,7,11,13,17,19,23,27:: 11 */
"High Fun",	/* 30-1, 27:2, 23-3, 19-5, 17-7, 13-11:: 13 */
"Zonkers",	/* 23-11, 27-2, 13,29,7,2, 25,5:: 11 */
"Wild Ride",    /* 3-30:: 17 */
"Starfire",	/* 1-30:: 23 */
"Espresso",	/* 1-7, 13-29:: 15 */
"Acid",         /* tbd  */
(char *)0 
};
//#define NUM_FU  NUMBER(7)   // in prepcallbacks.h


toggle prepstate; /* boolean: are we in the pre-programmed state frame? [y/n]*/

XFontStruct *labelFont;

char *blankDescLabel= BLANK4LINES;

XFontStruct *colorsFont, *hertzFont, *pitchFont,  *actionFont, *volumeFont;

  char *adjust_button_labels[] = {"Adjust Off", "Adjust On"};
boolean adjustflag;

/*
* begin adjust command button
*/
void
adjustbuttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  static short int count = 0;
  short int mode;

  count++;
  mode = count % XtNumber(adjust_button_labels);

 XtVaSetValues(_w, XtNlabel, adjust_button_labels[mode],NULL);

  switch (mode)
  {
  case 0:
    adjustflag = off;
    break;
  case 1:
    adjustflag = on;
    break;
  }
  program.emsg(nprint, "ADJDEB: mode = (%d), label = [%s], adjustflag = [%s]\n",
    mode, adjust_button_labels[mode], adjustflag==on?"on":"off");
}

void
selectprep_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{

  void volumeup_buttonCB(Widget _w, XtPointer, XtPointer _call_data );
  void volumedown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void sspup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void sspdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void avup_buttonCB(Widget _w, XtPointer, XtPointer _call_data );
  void avdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data );
  void progup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void progdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data );
  void prepup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void prepdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data );

  extern XFontStruct *init_font(Display *display, const char *fontName);
  extern Widget selectionup_button, selectiondown_button, progup_button,
    progdown_button;
  extern toggle prepstate;
  extern volume_t volume;
  extern action_t sspmode;
  extern audiovideo_t muuzmode;
  extern char *blankProgWin;
  extern Display *display;
  extern char *avDisplayLabels[], *sspDisplayLabels[], *volumeDisplayLabels[];
  extern Widget formbox2, labelForm, menuform;
  extern XFontStruct *labelFont;
 Widget adjustcommandbutton;
 Widget labelAv, dummycommandbutton;
 Widget avdown_button, avup_button, sspdown_button, sspup_button, 
	volumedown_button, volumeup_button;
 Widget formAv;
 Widget labelAction;
 Widget formAction;
 Widget labelVolume;
 Widget formVolume;
 XFontStruct *adjustFont, *avFont; /*** *actionFont, *volumeFont; ***/



  Widget formselection, formProgram;


  /* Note that this formbox2 is what seems to be much larger than the
     initial formbox2
   */

  if (prepstate == off)
  {
    void do_click();
    flashForm forFlash;
    extern toggle userstate;

    program.emsg(nprint, "DEBB: sspmode = (%d)\n", sspmode, _fl_);
    program.emsg(nprint,"DEBUG: select_prep: prepstate = %s, setting to = on\n",
	prepstate==on?"on":"off", _fl_ );

    do_click();      /* clicking sound, set low volume */
    if (beatsPid)
    {
      kill(beatsPid, SIGINT);
      forFlash.setFormColor(SLATEGREY);
    }
    prepstate = on;  /* we are moving to the Pre-Programmed frame */
    controlpanelstate = userstate = off; /* regardless */
  }
  else if (prepstate == on)
  {
    program.emsg(nprint,"DEBZ: prepstate already on, not redrawing; returning");
    return;
  }


  /*
   *  this is the Pre-Programmed (prep) frame in which the prep Assemblies
   *  are contained.
   */

  if (depth > 8)
  {
  formbox2 = XtVaCreateManagedWidget("formbox2", formWidgetClass, form,
        XtNheight, Do.resizeH(125), // ::133 too L
        XtNwidth,  Do.resizeW(725), // sets the width of the labelWidget
        XtNfromVert, menuform,
        XtNfromHoriz, formbox0,
	XtNbackground, blue_color.pixel, /* color entire LS prog panel blue */
        XtNborderWidth, 0,   
        XtNtop, XawChainTop,
        XtNbottom, XawChainBottom,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
  formbox2 = XtVaCreateManagedWidget("formbox2", formWidgetClass, form,
        XtNheight, Do.resizeH(125), // ::133 too L
        XtNwidth,  Do.resizeW(725), // sets the width of the labelWidget
        XtNfromVert, menuform,
        XtNfromHoriz, formbox0,
	XtNbackground, blue, /* color entire LS prog panel blue */
        XtNborderWidth, 0,   
        XtNtop, XawChainTop,
        XtNbottom, XawChainBottom, // FORMBLUE TEST
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }

  labelFont = init_font(display, NCS18);
  //
  //  This section controls the 25x300 pixel label rectangle whose 
  //  background is "blue" and forground (the font|lettering) is black.
  //
  if (depth>8)
  {
  labelForm = XtVaCreateManagedWidget("labelForm", labelWidgetClass, formbox2,
        XtNfont, labelFont,
	/*
	 * center this string (approx) above the two left-most Assemblies.
	 */
        XtNlabel, "Light-Sound Program Selections",
        XtNheight, Do.resizeH(25), // was 140 29oct99
        XtNwidth,  Do.resizeW(300),
	XtNbackground, blue_color.pixel,
	XtNforeground, black_color,
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
        XtNhorizDistance, 0,  // Zero distance needs no resizing.
        XtNvertDistance, 0,  // Zero distance needs no resizing.
        XtNborderWidth, 0,    /* zeroing border gets rid of thin-black-line */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
  labelForm = XtVaCreateManagedWidget("labelForm", labelWidgetClass, formbox2,
        XtNfont, labelFont,
	/*
	 * center this string (approx) above the two left-most Assemblies.
	 */
        XtNlabel, "Light-Sound Program Selections",
        XtNheight, Do.resizeH(25), // was 140 29oct99
        XtNwidth,  Do.resizeW(300),
	XtNbackground, blue,
	XtNforeground, black_color,
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
        XtNhorizDistance, 0,  // Zero distance needs no resizing.
        XtNvertDistance, 0,  // Zero distance needs no resizing.
        XtNborderWidth, 0,    /* zeroing border gets rid of thin-black-line */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }







  /*
   *  This is the basis for the Selections assembly
   */
  if (depth > 8)
  {
    formselection = XtVaCreateManagedWidget("formselection", formWidgetClass,
      formbox2,
      XtNheight, Do.resizeH(25),  /* must have a reasonable value here */
      XtNwidth,  Do.resizeW(291),/* was 210; larger for TBOLD12 font, 30dec98 */
      XtNfromVert, NULL,   /* Must be lowered + 32 */
      XtNvertDistance, Do.resizeH(32), /* this lowers the sections Assemblies */
      XtNfromHoriz, NULL,
      XtNbackground, whitesmoke_color.pixel,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
   }
   else
   {
    formselection = XtVaCreateManagedWidget("formselection", formWidgetClass,
      formbox2,
      XtNheight, Do.resizeH(25),  /* must have a reasonable value here */
      XtNwidth,  Do.resizeW(291),/* was 210; larger for TBOLD12 font, 30dec98 */
      XtNfromVert, NULL,   /* Must be lowered + 32 */
      XtNvertDistance, Do.resizeH(32), /* this lowers the sections Assemblies */
      XtNfromHoriz, NULL,
      XtNbackground, whitesmoke,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
   }

  /*
   * This is the basis for the Programs assembly.
   */
  if (depth < 8)
  {
    formProgram =XtVaCreateManagedWidget("formProgram",formWidgetClass, 
      formbox2,
      XtNheight, Do.resizeH(25),
      XtNwidth,  Do.resizeW(291),  /* Programs UpA [     ] DwnA  frame */
      XtNfromVert, formselection,
      XtNfromHoriz, NULL,
      XtNbackground, whitesmoke_color.pixel,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  }
  else
  {
    formProgram =XtVaCreateManagedWidget("formProgram",formWidgetClass, 
      formbox2,
      XtNheight, Do.resizeH(25),
      XtNwidth,  Do.resizeW(291),  /* Programs UpA [     ] DwnA  frame */
      XtNfromVert, formselection,
      XtNfromHoriz, NULL,
      XtNbackground, whitesmoke,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  }



selectionFont = init_font(display, NCS12);
labelSelection =
XtVaCreateManagedWidget("labelSelection", labelWidgetClass, formselection,
XtNfont, selectionFont,
XtNlabel, "Selections",
XtNbackground, white_color,
XtNforeground, black_color, 
XtNfromVert, NULL,
XtNfromHoriz, NULL,
XtNborderWidth, 0,     /* standalone    */
XtNtop, XawChainTop,
XtNbottom, XawChainTop,
XtNleft, XawChainLeft, 
XtNright, XawChainLeft, NULL);

if (depth > 8)
{
selectionup_button =
XtVaCreateManagedWidget("selectionup_button", commandWidgetClass,
formselection,
XtNbitmap, UpArrow,
XtNfromVert, NULL,
XtNfromHoriz, labelSelection,
// ARROW_COLORS
XtNbackground,grey_color.pixel,\
XtNforeground,darkblue_color.pixel, \
XtNshadowWidth,  3,
XtNtop, XawChainTop,
XtNbottom, XawChainTop,
XtNleft, XawChainLeft,
XtNright, XawChainLeft,
NULL);

}
else
{
selectionup_button =
XtVaCreateManagedWidget("selectionup_button", commandWidgetClass,
formselection,
XtNbitmap, UpArrow,
XtNfromVert, NULL,
XtNfromHoriz, labelSelection,
XtNbackground,grey,\
XtNforeground,darkblue, \
XtNshadowWidth,  3,
XtNtop, XawChainTop,
XtNbottom, XawChainTop,
XtNleft, XawChainLeft,
XtNright, XawChainLeft,
NULL);

}

XtAddCallback(selectionup_button, XtNcallback, prepup_buttonCB, NULL);



displayPrep =
XtVaCreateManagedWidget("displayPrep", labelWidgetClass, formselection,
	    XtNlabel, prepTopicsButtonLabel[0],
	    XtNfromVert, NULL,
	    XtNfromHoriz, selectionup_button,
	    XtNtop, XawChainTop,
	    XtNbottom, XawChainTop,
	    XtNleft, XawChainLeft,
	    XtNright, XawChainLeft,
	    NULL);


if (depth > 8)
{
selectiondown_button =
XtVaCreateManagedWidget("selectiondown_button", commandWidgetClass,
formselection,
XtNbackground, whitesmoke_color.pixel,
	    XtNbitmap, DownArrow,
	    XtNfromVert, NULL,
	    XtNfromHoriz, displayPrep,
			    // ARROW_COLORS
			    XtNbackground,grey_color.pixel,\
			    XtNforeground,darkblue_color.pixel, \
			    XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  }
  else
  {
  selectiondown_button =
    XtVaCreateManagedWidget("selectiondown_button", commandWidgetClass,
      formselection,
	      XtNbackground, whitesmoke_color.pixel,
                            XtNbitmap, DownArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, displayPrep,
			    XtNbackground,grey,\
			    XtNforeground,darkblue, \
			    XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);


  }
  XtAddCallback(selectiondown_button, XtNcallback, prepdown_buttonCB, NULL);
  /* end formselection form */




  /* start program stuff */
  /**programFont = init_font(display, TBOLD12);*/

  programFont = init_font(display, NCS12);
  labelProgram  =
    XtVaCreateManagedWidget("labelProgram ", labelWidgetClass, formProgram,
      XtNfont, programFont,
      XtNlabel, "Programs ", /* Font Label (note blank)*/
      XtNfromVert, NULL,
      XtNfromHoriz, NULL,
      XtNbackground, white_color,
      XtNforeground, black_color,
      XtNborderWidth, 0,     /* standalone    */
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

/* Labels//labels */
  if (depth > 8)
  {
  progup_button =
    XtVaCreateManagedWidget("progup_button", commandWidgetClass, formProgram,
                            XtNbitmap, UpArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, labelProgram,
			      // ARROW_COLORS
			      XtNbackground,grey_color.pixel,\
			      XtNforeground,darkblue_color.pixel, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  }
  else
  {
    progup_button =
      XtVaCreateManagedWidget("progup_button", commandWidgetClass, formProgram,
                            XtNbitmap, UpArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, labelProgram,
			      XtNbackground,grey,\
			      XtNforeground,darkblue, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);


  }
  XtAddCallback(progup_button, XtNcallback, progup_buttonCB, NULL);

  displayProg =
    XtVaCreateManagedWidget("displayProg", labelWidgetClass, formProgram,
                            XtNlabel, blankProgWin, /* blank label:22oct98 */
                            XtNfromVert, NULL,
                            XtNfromHoriz, progup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);


  if (depth > 8)
  {
  progdown_button =
    XtVaCreateManagedWidget("progdown_button", commandWidgetClass, formProgram,
                            XtNbitmap, DownArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, displayProg,
			      // ARROW_COLORS
			      XtNbackground,grey_color.pixel,\
			      XtNforeground,darkblue_color.pixel, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  }
  else
  {
  progdown_button =
    XtVaCreateManagedWidget("progdown_button", commandWidgetClass, formProgram,
                            XtNbitmap, DownArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, displayProg,
			      XtNbackground,grey,\
			      XtNforeground,darkblue, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  }
  XtAddCallback(progdown_button, XtNcallback, progdown_buttonCB, NULL);
  /* end "Selections", "Programs":: below, mode, actions, volume buttons */






  /*** Here, on the `prep' Pre-Programmed Frame are, horizontal-ward the ***/
  /*** controlButton widgets for  Mode, Action, and Volune               ***/

  // 
  // Here is where to insert a small ``A'' ADJUST|adjust button
  //

  /*
   * In Pre-programmed mode, Prep form.
   * begin Mode Assembly: AV-trio: Audio, Video, Audiovideo
   */

  /* BEGIN formAv:: action forms code */
  if (depth >8)
  {
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formbox2,
        XtNheight, Do.resizeH(25),
        XtNwidth, Do.resizeW(175),  // was 213
	// ASSEMBLY BACKGROUND COLOR AND SHADOW
	XtNbackground, whitesmoke_color.pixel, \
	XtNshadowWidth,  2,
        XtNfromVert, formProgram,
        XtNfromHoriz, NULL,  /* ``flush'' or default */
        XtNhorizDistance, Do.resizeH(15),  // 15 in from Flush (?)
        XtNvertDistance, Do.resizeH(3),
        XtNtop, XawChainTop,
        XtNbottom, XawChainBottom,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formbox2,
        XtNheight, Do.resizeH(25),
        XtNwidth, Do.resizeW(175),  // was 213
        XtNbackground, whitesmoke, \
	XtNshadowWidth,  2,
        XtNfromVert, formProgram,
        XtNfromHoriz, NULL,  /* ``flush'' or default */
        XtNhorizDistance, Do.resizeH(15),  // NEW 03mar00 NOTE
        XtNvertDistance, Do.resizeH(3),
        XtNtop, XawChainTop,
        XtNbottom, XawChainBottom,  // was XawChainTop ... 
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }

  avFont = init_font(display, NCS12);
  labelAv =
    XtVaCreateManagedWidget("labelAv", labelWidgetClass, formAv,
        XtNfont, avFont,
        XtNlabel, L_MODE,
	//  LABEL_COLORS
	XtNbackground, white_color, \
	XtNforeground, black_color, \
	XtNshadowWidth,  2,
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
        XtNborderWidth, 0,      /* standalone    */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  if (depth > 8)
  {
  avup_button =
    XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
        XtNbitmap, UpArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, labelAv,
	  // ARROW_COLORS
	  XtNbackground,grey_color.pixel,\
	  XtNforeground,darkblue_color.pixel, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }
  else
  {
  avup_button =
    XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
        XtNbitmap, UpArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, labelAv,
	  XtNbackground,grey,\
	  XtNforeground,darkblue, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  XtAddCallback(avup_button, XtNcallback, avup_buttonCB, NULL);

  avFont = init_font(display, NCS12);
  displayAv =
    XtVaCreateManagedWidget("displayAv", labelWidgetClass, formAv,
	XtNfont, avFont,
        XtNlabel,  avDisplayLabels[muuzmode],
        XtNfromVert, NULL,
        XtNfromHoriz, avup_button,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  if (depth > 8)
  {
  avdown_button =
    XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
        XtNbitmap, DownArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, displayAv,
	  // ARROW_COLORS
	  XtNbackground,grey_color.pixel,\
	  XtNforeground,darkblue_color.pixel, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }
  else
  {
  avdown_button =
    XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
        XtNbitmap, DownArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, displayAv,
	  XtNbackground,grey,\
	  XtNforeground,darkblue, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }


  XtAddCallback(avdown_button, XtNcallback, avdown_buttonCB, NULL);
  /* END   AV trio     */

  /*
   * BEGIN Action assembly  :: start, pause, stop.
   */
  if (depth > 8)
  {
    formAction =XtVaCreateManagedWidget("formAction", formWidgetClass, formbox2,
          XtNheight, Do.resizeH(25),
          XtNwidth, Do.resizeW(175),  // was 213
	  // ASSEMBLY BACKGROUND COLOR AND SHADOW
	  XtNbackground, whitesmoke_color.pixel, \
	  XtNshadowWidth,  2,
        XtNfromVert, formProgram,
        XtNfromHoriz, formAv,
	XtNhorizDistance, Do.resizeW(9), /* new :: 08mar99 */
	XtNvertDistance, Do.resizeH(3),  /* new :: 26feb99: was 12. Moving trio North */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
    formAction =XtVaCreateManagedWidget("formAction", formWidgetClass, formbox2,
          XtNheight, Do.resizeH(25),
          XtNwidth, Do.resizeW(175),  // was 213
          XtNbackground, whitesmoke, \
	  XtNshadowWidth,  2,
        XtNfromVert, formProgram,
        XtNfromHoriz, formAv,
	XtNhorizDistance, Do.resizeW(9), /* new :: 08mar99 */
	XtNvertDistance, Do.resizeH(3),  /* new :: 26feb99: was 12. Moving trio North */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }

  actionFont = init_font(display, NCS12);
  labelAction =
    XtVaCreateManagedWidget("labelAction", labelWidgetClass, formAction,
        XtNfont, actionFont,
        XtNlabel, L_ACTION,
	//  LABEL_COLORS
	XtNbackground, white_color, \
	XtNforeground, black_color, \
	XtNshadowWidth,  2,
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
        XtNborderWidth, 0,      /* standalone    */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  
  /* begin SSP trio */
  if (depth > 8)
  {
  sspup_button =
    XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
        XtNbitmap, UpArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, labelAction, 
	  // ARROW_COLORS
	  XtNbackground,grey_color.pixel,\
	  XtNforeground,darkblue_color.pixel, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
  sspup_button =
    XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
        XtNbitmap, UpArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, labelAction, 
	  XtNbackground,grey,\
	  XtNforeground,darkblue, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }

  XtAddCallback(sspup_button, XtNcallback, sspup_buttonCB, NULL);

  /**sspDisplayFont = init_font(display, TBOLD12);*/

  sspDisplayFont = init_font(display, NCS12);
  displayAction =
    XtVaCreateManagedWidget("displayAction", labelWidgetClass, formAction,
	XtNfont, sspDisplayFont,
        XtNlabel, sspDisplayLabels[sspmode],
        XtNfromVert, NULL, 
        XtNfromHoriz, sspup_button,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop, 
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
 
  if (depth > 8)
  {
  sspdown_button =
    XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
        XtNbitmap, DownArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, displayAction,
	  // ARROW_COLORS
	  XtNbackground,grey_color.pixel,\
	  XtNforeground,darkblue_color.pixel, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
  sspdown_button =
    XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
        XtNbitmap, DownArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, displayAction,
	  XtNbackground,grey,\
	  XtNforeground,darkblue, \
	  XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  XtAddCallback(sspdown_button, XtNcallback, sspdown_buttonCB, NULL);


  /* end   SSP trio     */
  /*
   * begin VOL widget 
   */


  if (depth > 8)
  {
  formVolume = 
   XtVaCreateManagedWidget("formVolume", formWidgetClass, formbox2,
        XtNfromVert, formProgram,
        XtNfromHoriz, formAction,
	XtNhorizDistance, Do.resizeW(9), /* new :: 07mar99 */
        XtNvertDistance, Do.resizeH(3),  /* new :: 26feb99: was 12. Moving trio North */
        XtNheight, Do.resizeH(25),
        XtNwidth, Do.resizeW(165),      /* Volume labelbutton width */
	  // ASSEMBLY BACKGROUND COLOR AND SHADOW
	  XtNbackground, whitesmoke_color.pixel, \
	  XtNshadowWidth,  2,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  }
  else
  {
  formVolume = 
   XtVaCreateManagedWidget("formVolume", formWidgetClass, formbox2,
        XtNfromVert, formProgram,
        XtNfromHoriz, formAction,
	XtNhorizDistance, Do.resizeW(9), /* new :: 07mar99 */
        XtNvertDistance, Do.resizeH(3),  /* new :: 26feb99: was 12. Moving trio North */
        XtNheight, Do.resizeH(25),
        XtNwidth, Do.resizeW(165),       /* Volume labelbutton width */
          XtNbackground, whitesmoke, \
	  XtNshadowWidth,  2,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }
  


  volumeFont = init_font(display, NCS12);
  labelVolume =
    XtVaCreateManagedWidget("labelVolume", labelWidgetClass, formVolume,
                            XtNfont, volumeFont,
                            XtNlabel, L_VOLUME,
			    //  LABEL_COLORS
			    XtNbackground, white_color, \
			    XtNforeground, black_color, \
			    XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,  /* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);
  
  /* begin volume trio */
  if (depth > 8)
  {
  volumeup_button =
    XtVaCreateManagedWidget("volumeup_button", commandWidgetClass,
                            formVolume,
                            XtNbitmap, UpArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, labelVolume,
			      // ARROW_COLORS
			      XtNbackground,grey_color.pixel,\
			      XtNforeground,darkblue_color.pixel, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);
  }
  else
  {
  volumeup_button =
    XtVaCreateManagedWidget("volumeup_button", commandWidgetClass,
      formVolume,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelVolume,
      XtNbackground,grey,\
      XtNforeground,darkblue, \
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);

  }

  
  XtAddCallback(volumeup_button, XtNcallback, volumeup_buttonCB, NULL);

  /*volumeDisplayFont = init_font(display, TBOLD12);*/

  volumeDisplayFont = init_font(display, NCS12);
  displayVolume =
    XtVaCreateManagedWidget("displayVolume", labelWidgetClass, formVolume,
    XtNfont, volumeDisplayFont,
    XtNlabel,  volumeDisplayLabels[volume],
    XtNfromVert, NULL,
    XtNfromHoriz, volumeup_button,
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);
      
  if (depth > 8)
  {
  volumedown_button =
    XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
                            formVolume,
                            XtNbitmap, DownArrow,
                            XtNfromVert, NULL,

                            XtNfromHoriz, displayVolume,
			      // ARROW_COLORS
			      XtNbackground,grey_color.pixel,\
			      XtNforeground,darkblue_color.pixel, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);
  }
  else
  {
    volumedown_button =
      XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
                            formVolume,
                            XtNbitmap, DownArrow,
                            XtNfromVert, NULL,
                            XtNfromHoriz, displayVolume,
			      XtNbackground,grey,\
			      XtNforeground,darkblue, \
			      XtNshadowWidth,  3,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  }
  
  XtAddCallback(volumedown_button, XtNcallback, volumedown_buttonCB, NULL);
   
  /* end volume trio */


  /* end formProgram stuff */

  //
  // THE ADJ / NOADJ  button goes here
  //
  /* BEGIN formAv:: action forms code */
  adjustFont = init_font(display, TBOLD18);
    adjustcommandbutton = XtVaCreateManagedWidget("adjustcommandbutton", 
      commandWidgetClass, formbox2,
        XtNheight, Do.resizeH(25),
        XtNwidth, Do.resizeW(85), 
  	XtNfont, adjustFont,
        XtNlabel, adjust_button_labels[0],
        XtNshadowWidth,  3,
        XtNfromVert, formProgram, 
        XtNfromHoriz, formVolume, 
        XtNhorizDistance, Do.resizeH(35),
        XtNvertDistance, Do.resizeH(3),
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,  // was XawChainTop ...
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  
  if (depth > 8)
  {
    if (adjustflag == off)
      XtVaSetValues(adjustcommandbutton, XtNforeground, darkred_color.pixel,  
				       XtNbackground, orange, NULL);
    else if (adjustflag == on)
      XtVaSetValues(adjustcommandbutton, XtNforeground, orange_color.pixel,
				       XtNbackground, darkred_color.pixel,NULL);
  }
  else
  {
    if (adjustflag == off)
      XtVaSetValues(adjustcommandbutton, XtNforeground, darkred,  
				       XtNbackground, orange, NULL);
    else if (adjustflag == on)
      XtVaSetValues(adjustcommandbutton, XtNforeground, orange,  
				       XtNbackground, darkred, NULL);

  }


  XtAddCallback(adjustcommandbutton, XtNcallback, adjustbuttonCB, NULL);


  /*
   *  This is the large white rectangle that briefly described the 
   *  pre-programmed selections.
   *  
   *  This form was 24 and 32 pixels from the top of its boundary.
   *  Now it is only 8 pixels below the top.
   */

  labelFont = init_font(display, NCS12); 
  labelDesc = XtVaCreateManagedWidget("labelDesc", labelWidgetClass, 
	formbox2,
	XtNlabel, blankDescLabel,
	XtNfont,  labelFont,
        XtNheight, Do.resizeH(75), /* helps determine size of formbox2 :: was 90::*/
        XtNwidth,  Do.resizeW(377),  /* larger into formbox2 :: was 300 :: 363 fits! */
        XtNfromVert, NULL,  /* Must be lowered by +32 */
        XtNvertDistance, Do.resizeH(8),   /* was 32 */
        XtNfromHoriz, formProgram,  /* FIX here and hxw */
        XtNhorizDistance, Do.resizeW(3),   /* was 15: 07jan99 :: 5, 08mar99*/
	XtNborderWidth, 2,      /* testing:: 07jan99 */
	XtNshadowWidth,  3,
	//  LABEL_COLORS
	XtNbackground, white_color,  // special monochrome 
	XtNforeground, black_color,  // special monochrome 
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);


}


