/*
 * $Id: prepengine.c,v 1.1 2000/01/29 20:44:46 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include <sys/types.h>
#include <signal.h>

#include "errMessage.h"
#include "muuzaudio.h"
#include "flashForm.h"
#include "setAudioValues.h"
#include "misc.h"
#include "main.h"
#include "copyright.h"


extern errMessage program;  // for emsg()



XtIntervalId preptimeout;
int  prepcount = 0;
boolean prepdone = false;
unsigned int flashcyclecount;

/*  prepengine debug flag */
static int pdebug = 0;
static int category;    // delete this probly...


/*
    this calls play stuff: sets flashes for n seconds an n hertz; returns
    when done
 */

static seconds_t seconds = 0;
frequency_t frequency = 0;

void
startPrep(int prog)
{
  int n = 0;
  Arg wargs[10];
  extern short int proceed;
  audioValues show;
  void prepE(frequency_t frequency, volume_t volume, octave_t octave, 
    seconds_t seconds, unsigned long int hertz);
  extern action_t sspmode;
  void preptimeout_proc(XtPointer _client_data, XtIntervalId *_id);
  void selectGlobalColor( int color);
  void instStates(instance_t *instance, frequency_t, 
    seconds_t, colors_t, pitch_t, volume_t, int);
  void soundroutine(volume_t volume, octave_t octave, frequency_t frequency);
  extern octave_t octave;
  extern frequency_t frequency;
  extern volume_t  volume;
  extern seconds_t seconds;
  extern unsigned long  hertz;
  extern instance_t progCreativity[100];
  extern instance_t progEnergize[100];
  extern instance_t progFun[100];
  extern instance_t progLearning[100];
  extern instance_t progMeditation[100];
  extern instance_t progRelax[100];
  extern instance_t progSleep[100];
  extern findex_t  ccr, clr, crx, cmd, csl, cen, cfu; 
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	      cfu_flag;



#ifdef WWW
  if (!proceed)
  {
    sspmode--;
    XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] ); n++;
    XtSetValues(displayAction, wargs, n);
    return;
  }
#endif

  program.emsg(nprint, "entering startPrep(), prog = (%d), play = (%d)\n",
    prog, play, _fl_);
   /*
    *   deal with the stop/pause/play button.  it must be set to PLAY;
    *   assuming not, readjust up or down the counter, off up|downflag,
    *   and return
    */
	if (ccr_flag == 1)
	{
	    if (ccr == 1) ccr = 0; /* WRETCHED kludge */
	    category = ccr;
            frequency = (frequency_t)progCreativity[0].freq;
            volume = (volume_t)progCreativity[0].volume;
            octave = (octave_t)progCreativity[0].pitch;
            seconds = (seconds_t)progCreativity[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progCreativity[0].colors);
            program.emsg(nprint,"ccr_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (clr_flag == 1)
	{
	    if (clr == 1) clr = 0; /* WRETCHED kludge */
	    category = clr;
            frequency = (frequency_t)progLearning[0].freq;
            volume = (volume_t)progLearning[0].volume;
            octave = (octave_t)progLearning[0].pitch;
            seconds = (seconds_t)progLearning[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progLearning[0].colors);
            program.emsg(nprint,"clr_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (crx_flag == 1)
	{
	    category = crx;
            frequency = (frequency_t)progRelax[0].freq;
            volume = (volume_t)progRelax[0].volume;
            octave = (octave_t)progRelax[0].pitch;
            seconds = (seconds_t)progRelax[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progRelax[0].colors);
            program.emsg(nprint,"crx_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cmd_flag == 1)
	{
	    category = cmd;
            frequency = (frequency_t)progMeditation[0].freq;
            volume = (volume_t)progMeditation[0].volume;
            octave = (octave_t)progMeditation[0].pitch;
            seconds = (seconds_t)progMeditation[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progMeditation[0].colors);
            program.emsg(nprint,"cmd_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cen_flag == 1)
	{
	    category = cen;
            frequency = (frequency_t)progEnergize[0].freq;
            volume = (volume_t)progEnergize[0].volume;
            octave = (octave_t)progEnergize[0].pitch;
            seconds = (seconds_t)progEnergize[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progEnergize[0].colors);
            program.emsg(nprint,"cen_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (csl_flag == 1)
	{

	    if (csl == 1) csl = 0; /* WRETCHED kludge :: 25feb99 */
	    category = csl;
            frequency = (frequency_t)progSleep[0].freq;
            volume = (volume_t)progSleep[0].volume;
            octave = (octave_t)progSleep[0].pitch;
            seconds = (seconds_t)progSleep[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progSleep[0].colors);
            program.emsg(nprint,"csl_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cfu_flag == 1)
	{
	    category = cfu;
            frequency = (frequency_t)progFun[0].freq;
            volume = (volume_t)progFun[0].volume;
            octave = (octave_t)progFun[0].pitch;
            seconds = (seconds_t)progFun[0].seconds;
            hertz = HzArray[frequency]; /* get correct hertz for state */
            selectGlobalColor( (int)progFun[0].colors);
            program.emsg(nprint,"cfu_flag: frequency = (%d)\n", frequency,_fl_);
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	if ( sspmode == PLAY)
	{
	  show.volumeDisplay(volume);
	  soundroutine(volume, octave, frequency);
          preptimeout = XtAppAddTimeOut(app,(unsigned long)(1.0/frequency)*1000,
			preptimeout_proc, NULL);   /*,  (XtPointer)program );*/
	}

}

void
selectGlobalColor (int color)
{
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow;
  extern unsigned long global_flash_color, white_color;   
  extern XColor   blue_color, exact_color, pink_color, grey_color, 
    orange_color, hotpink_color, yellow_color, skyblue_color;

  switch (color)
  {
    case WHITE:
      global_flash_color = white_color; /* spl case */
      break;
    case YELLOW:
      if(depth>8)
	global_flash_color = yellow_color.pixel;
      else
	global_flash_color = yellow;
      break;
    case ORANGE:
      if(depth>8)
	global_flash_color = orange_color.pixel;
      else
	global_flash_color = orange;
      break;
    case VRED:
      if(depth>8)
	global_flash_color = pink_color.pixel;
      else
	global_flash_color = lightpink;
      break;
    case SKYBLUE:
      if(depth>8)
	global_flash_color = skyblue_color.pixel;
      else
	global_flash_color = lightskyblue;
      break;
  }

}

void
soundroutine(volume_t volume, octave_t octave, frequency_t frequency)
{
  audioValues setAudio;
  
  if (pdebug)
  {
    program.emsg(nprint,"entering soundroutine(): volume = (%d) \n",
      volume*10, _fl_);
  }

  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
    program.emsg(nprint,"soundroutine(): binaural beats were playing \n", _fl_);
  }

  setAudio.Octave();
  setAudio.Volume();
}

void 
instStates ( instance_t *instance, frequency_t hz, seconds_t seconds, 
colors_t colors, pitch_t pitch, volume_t volume, int flashform)
{
instance->freq = (frequency_t)hz; 
instance->seconds = (seconds_t)seconds; 
instance->colors = (colors_t)colors;
instance->pitch= (pitch_t)pitch; 
instance->volume = (volume_t)volume; 
instance->screenflashform=flashform;

//program.emsg(nprint, "instStates(): freq = (%d), seconds = (%d)\n",
//instance->freq,instance->seconds,  _fl_);

}


/*
* debugging
*/
void
prepE(frequency_t frequency, volume_t volume, octave_t octave, seconds_t seconds, unsigned long int hertz)
{
program.emsg(nprint, "frequency = (%d)\nvolume = (%d)\noctave = (%d)\nseconds = (%d)\nhertz = (%ld)\n", frequency, volume, octave, seconds, hertz);
}

void
preptimeout_proc(XtPointer _client_data, XtIntervalId *_id)
{
audioValues show;
void preptimeout_proc(XtPointer _client_data, XtIntervalId *_id);
extern Display  *flashdisplay;
extern GC flashgc;
extern XGCValues flashes_gcv;
extern seconds_t seconds;
extern frequency_t frequency;
  extern int HzArray[];
  extern unsigned long hertz;
  extern XtIntervalId preptimeout;
  extern octave_t octave;
  static unsigned int icount = 0;
  extern instance_t progCreativity[100];
  extern instance_t progEnergize[100]; 
  extern instance_t progFun[100];
  extern instance_t progLearning[100];
  extern instance_t progMeditation[100];
  extern instance_t progRelax[100];
  extern instance_t progSleep[100];
  void preptimeout_proc(), selectGlobalColor(int color); 
  void soundroutine(volume_t volume, octave_t octave, frequency_t frequency);
  flashForm forFlash;



  program.emsg(nprint,"prepCount():frequency = %d, seconds = %d, icount = %d\n",
    frequency, seconds, icount,  _fl_);
  prepcount++;
  if (prepcount == frequency*seconds) 
  {
    program.emsg(nprint, "DEBUG: prepcount = (%d)\n", prepcount, _fl_);
    prepdone = true;
  }

  if (prepdone == true)
  {
  	icount++;
    program.emsg(nprint, "--DEBUG: icount = (%d)\n", icount, _fl_);
	if (ccr_flag == 1)
	{
  	    frequency = (frequency_t)progCreativity[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progCreativity[icount].seconds;

	    selectGlobalColor((int)progCreativity[icount].colors);
	    octave = (octave_t)progCreativity[icount].pitch;
	    volume = (volume_t)progCreativity[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (clr_flag == 1)
	{
  	    frequency = (frequency_t)progLearning[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progLearning[icount].seconds;
	    selectGlobalColor((int)progLearning[icount].colors);
	    octave = (octave_t)progLearning[icount].pitch;
	    volume = (volume_t)progLearning[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (crx_flag == 1)
	{
  	    frequency = (frequency_t)progRelax[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progRelax[icount].seconds;
	    selectGlobalColor((int)progRelax[icount].colors);
	    octave = (octave_t)progRelax[icount].pitch;
	    volume = (volume_t)progRelax[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cmd_flag == 1)
	{
  	    frequency = (frequency_t)progMeditation[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progMeditation[icount].seconds;
	    selectGlobalColor((int)progMeditation[icount].colors);
	    octave = (octave_t)progMeditation[icount].pitch;
	    volume = (volume_t)progMeditation[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cen_flag == 1)
	{
  	    frequency = (frequency_t)progEnergize[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progEnergize[icount].seconds;
	    selectGlobalColor((int)progEnergize[icount].colors);
	    octave = (octave_t)progEnergize[icount].pitch;
	    volume = (volume_t)progEnergize[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (csl_flag == 1)
	{
  	    frequency = (frequency_t)progSleep[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progSleep[icount].seconds;
	    selectGlobalColor((int)progSleep[icount].colors);
	    octave = (octave_t)progSleep[icount].pitch;
	    volume = (volume_t)progSleep[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}
	else if (cfu_flag == 1)
	{
  	    frequency = (frequency_t)progFun[icount].freq;
  	    hertz = HzArray[frequency];       /* get correct hertz for state */
	    seconds =  (seconds_t)progFun[icount].seconds;
	    selectGlobalColor((int)progFun[icount].colors);
	    octave = (octave_t)progFun[icount].pitch;
	    volume = (volume_t)progFun[icount].volume;
	    if (pdebug)
	      prepE(frequency, volume, octave, seconds, hertz);
	}


	if (sspmode == PLAY)
	{
	/*  should this be marked if (sspmode == PLAY) */
	  show.volumeDisplay(volume);

	program.emsg(nprint,"AT-sound &&& XtREMOVE");
        soundroutine(volume, octave, frequency);
	prepcount =  0;
	prepdone = false;
	XtRemoveTimeOut(preptimeout);
	}

       program.emsg(nprint,"PDEB: Just before end-run");

       /*
        * end of the run.....
        */
	if (ccr_flag == 1)
	{
	    if (frequency == END && seconds == END )
            {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	      XtRemoveTimeOut(preptimeout);
	      icount = 0;
	      forFlash.setFormColor(SLATEGREY);
	      return;
            }
	}
	else if (clr_flag == 1)
	{
	    if (frequency == END && seconds == END )
            {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	      XtRemoveTimeOut(preptimeout);
	      icount = 0;
	      forFlash.setFormColor(SLATEGREY);
	      return;
            }
	}
	else if (crx_flag == 1)
	{
          if (frequency == END && seconds == END)
          {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	     XtRemoveTimeOut(preptimeout);
	     icount = 0;
	     forFlash.setFormColor(SLATEGREY);
	     return;
          }
	}
	else if (cmd_flag == 1)
	{
          if (frequency == END && seconds == END)
          {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	     XtRemoveTimeOut(preptimeout);
	     icount = 0;
	     forFlash.setFormColor(SLATEGREY);
	     return;
          }
	}
	else if (cen_flag == 1)
	{
          if (frequency == END && seconds == END)
          {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	     XtRemoveTimeOut(preptimeout);
	     icount = 0;
	     forFlash.setFormColor(SLATEGREY);
	     return;
          }
	}
	else if (csl_flag == 1)
	{
          if (frequency == END && seconds == END)
          {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	     XtRemoveTimeOut(preptimeout);
	     icount = 0;
	     forFlash.setFormColor(SLATEGREY);
	     return;
          }
	}
	else if (cfu_flag == 1)
	{
          if (frequency == END && seconds == END)
          {
  	      if (beatsPid)
  	      {
		kill(beatsPid, SIGINT);
                show.volumeDisplay(VOFF);
  	      }
	     XtRemoveTimeOut(preptimeout);
	     icount = 0;
	     forFlash.setFormColor(SLATEGREY);
	     return;
          }
	}
  }

  if (sspmode == PAUSE)
  {
    /*
     * no grey paint after 1st pause: window left black.
     */
    forFlash.setFormColor(GREY);
    return;
  }

  if (prepdone == false)
  {
    flashes_gcv.foreground = global_flash_color;    /* defaults to orange */
    XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
    XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
      Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
    (void)usleep(hertz);
    XSync(flashdisplay, False);   /* must be False */
    flashes_gcv.foreground = black_color;

    XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
    XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
      Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
    (void)usleep(hertz);
    XSync(flashdisplay, False);   /* must be False */

    if (sspmode == STOP)
    {
      flashForm sforFlash;

       program.emsg(nprint,"\n\nDEB: STOP_FLASH_HERE");
       if (beatsPid)
       {
		kill(beatsPid, SIGINT);
      }
      XtRemoveTimeOut(preptimeout);
      icount = 0;
      forFlash.setFormColor(SLATEGREY);
      return;

    }
    /* restablish timeout - remember interval is in milliseconds */
    preptimeout = XtAppAddTimeOut(app, (unsigned long)(1/frequency)*1000,
              preptimeout_proc,NULL);

// REND

  }
}
