/*
 * $Id: relaxation.c,v 1.1 2000/01/29 20:44:48 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "muuzaudio.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "flashes.h"   /* for toggle playing */
#include "errMessage.h"
#include "misc.h"
#include "main.h"
#include "muuzerror.h"
#include "prepengine.h"
#include "copyright.h"



#define TQ "tranquility()"
#define VERTQ "0.25"  
#define PR "power_relax()"
#define VERPR "0.30"  
#define SR "stress_relief()"
#define VERSR "0.25"  
#define PF "pain_relief()"
#define VERPF "0.29"  
#define RR "relax_return()"
#define VERRR "0.25"  
#define CC "CoolCalmness()"
#define VERCC "0.23"
#define DD "DeepDecompression()"
#define VERDD "0.20"
#define FU "fast_unwing()"
#define VERFU "0.31"


instance_t progRelax[100];
void do_relaxation(int);
void fast_unwind(int);
void tranquility(int);
void power_relax(int);
void stress_relief(int);
void pain_relief(int);
void relax_return(int);
void cool_calmness(int);
void deep_decompress(int);

void
do_relaxation(int prog)
{
  program.emsg(nprint,"do_relation: selecting prog = (%d)\n", prog);
  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
  }


  switch(prog)
  {
  case 0:
    fast_unwind(prog);
    break;
  case 1:
    tranquility(prog);
    break;
    break;
  case 2:
    power_relax(prog);
    break;
  case 3:
    stress_relief(prog);
    break;
  case 4:
    pain_relief(prog);
      break;
  case 5:
    relax_return(prog);
    break;
  case 6:
    cool_calmness(prog);
    break;
  case 7:
    deep_decompress(prog);
    break;
  default:
    program.emsg(error, "Should never get here: line %d in file %s: #(%d)\n",
    __LINE__, __FILE__, prog );

  }
  return;
}

/* 
 * ramp quickly down from 30 to 14. a bit more slowly from 14 to 8;
 * stay 2 minutes at 8; then downto 3 for around 5 minutes; then quickly
 * ramp up to 17Hz.
 */
void
fast_unwind(int prog)
{
  unsigned short I= UINIT;

    XMuuzPrepInformation(FU, VERFU);
  program.emsg(nprint,"entering fast_unwind()\n\tand calling startPrep(%d)\n",
    prog);
  program.emsg(nprint,"playing = (%d), sspmode = (%d)\n", playing, sspmode);

  instStates ( &progRelax[++I], 30, 5, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 29, 5, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 28, 5, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 27, 5, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 26, 4, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 25, 4, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 24, 4, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 23, 4, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 22, 4, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++], 21, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],20, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],19, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],18, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],17, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],16, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],15, 3, WHITE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],14, 3, SKYBLUE,  UPPER, 2, 0);
  instStates ( &progRelax[I++],14, 9, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],13, 11, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],12, 11, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],11, 3, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],11, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],10, 9, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],9, 9, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],8, 3, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],8, 5, VRED,  MID, 2, 0);
  instStates ( &progRelax[I++],8, 2, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++],8, 117, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],7, 7, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],6, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],5, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],4, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++],3, 7, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],3, 297, SKYBLUE,  LOW, 5, 0);
  instStates ( &progRelax[I++],4, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],5, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],6, 3, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],7, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],8, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],9, 3, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],10, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],11, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],12, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],13, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],14, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],15, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],16, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],17, 3, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++],18, 3, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++],19, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],20, 3, ORANGE,  MID, 2, 0);
  instStates ( &progRelax[I++],21, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],22, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++],23, 17, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 *  quickly from 27 to 7 Hz; 3 mins at 7Hz; then slowly to 11Hz 
 *  where hold 2 mins; then slowly to 5Hz and hold for 7 mins;
 *  then rise to 7 for one minute; then down to 3 Hz for 11minutes;
 *  then back to 11Hz for 2 minutes; then down to 1Hz for 13minutes.
 *  color changes at each hold.
 */
void
tranquility(int prog)
{
  unsigned short int I= UINIT;

  program.emsg(nprint,"entering tranquility()\n\tand calling startPrep(%d)\n",
    prog);

  instStates ( &progRelax[++I], 27, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 26, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 25, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 24, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 23, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 22, 3, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 21, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 20, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 19, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 18, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 17, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 16, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 15, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 14, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 13, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 12, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 11, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 5, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 180, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 11, 120, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 17, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 5, 411, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 13, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 5, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 4, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 3, 660, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 4, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 5, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 7, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 11, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 5, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 4, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 3, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 2, 60, YELLOW,  MID, 2, 0);
  instStates ( &progRelax[I++], 1, 780, YELLOW,  MID, 2, 0);
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 * 19 very rapidly to 11 and freeze for 180 secs (colorchanging at 180 3 times);
 * then rapidly to 3 for 970 (colorchanging 6 times);
 */
void
power_relax(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(PR, VERPR);
  instStates ( &progRelax[++I], 19, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 18, 4, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++], 17, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 16, 4, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++], 15, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 14, 4, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++], 13, 4, VRED,  MID, 2, 0);
  instStates ( &progRelax[I++], 12, 4, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 11, 179, WHITE,  MID, 2, 0); // 3 colorchanges
  instStates ( &progRelax[I++], 10, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 7, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 6, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 5, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 4, 2, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 3, 970, WHITE,  MID, 2, 0);// 6 colorchanges
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 * 21 to 13-- (75sec); JUMPTO 7--(979sec); 
 */

void
stress_relief(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(SR, VERSR);
  instStates ( &progRelax[++I], 21, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 20, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 19, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 18, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 17, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 16, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 15, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 14, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 13, 175, WHITE,  MID, 2, 0); // 3 colorchanges
  // JUMP state:: 13 to 7 hold 379, 7 colorchanges.
  instStates ( &progRelax[I++], 7, 379, WHITE,  MID, 2, 0);
  // JUMP 7 to 5 979  7 colchanges.
  instStates ( &progRelax[I++], 5, 979, WHITE,  MID, 2, 0);
  // JUMP 5 to 3, 979
  instStates ( &progRelax[I++], 3, 979, WHITE,  MID, 2, 0);
  // JUMP 3 to 1, 779
  instStates ( &progRelax[I++], 1, 779, WHITE,  MID, 2, 0);
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}
/* 
 * ramp quickly down from 14 to 8; pre-alpha to high-theta.  waves,
 * slowly, of 4,5,6,7,8 Hz wavestates at theta.
 * fcolor and octaves keep life interesting.
 */
void
pain_relief(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(PF, VERPF);
  instStates ( &progRelax[++I], 14, 17, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 13, 7, SKYBLUE,  MID, 2, 0);
  instStates ( &progRelax[I++], 12, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 11, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 10, 17, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 9, 7, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 8, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 7, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 6, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 5, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 4, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 4, 327, WHITE,  MID, 2, 0); // 5 colorchanges
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 *   from 23Hz downto 5 (around 11s); hold for 20*60s; then upto 29Hz (~5s)
 */

void
relax_return(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(RR, VERRR);
  instStates ( &progRelax[++I], 23, 75, WHITE,  MID, 2, 0); // 3 Crchanges
  instStates ( &progRelax[I++], 22, 11, WHITE,  MID, 2, 0); // 2 ColorChanges
  instStates ( &progRelax[I++], 21, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 20, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 19, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 18, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 17, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 16, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 15, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 14, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 13, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 12, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 11, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 10, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 9, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 8, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 7, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 6, 11, WHITE,  MID, 2, 0); 
  instStates ( &progRelax[I++], 5, 1200, WHITE,  MID, 2, 0); // 75 ColorChanges
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 *  13hz for 5*60s downto 2 hz and last 11*60s
 */
void
cool_calmness(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(CC, VERCC);
  instStates ( &progRelax[I++], 13, 300, WHITE,  MID, 2, 0); // 7 colorchanges
  instStates ( &progRelax[I++], 12, 23, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 11, 23, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 10, 23, WHITE,  MID, 2, 0); // 5 colorchanges
  instStates ( &progRelax[I++], 9, 23, WHITE,  MID, 2, 0); // 4 colorchanges
  instStates ( &progRelax[I++], 8, 23, WHITE,  MID, 2, 0); // 4 colorchanges
  instStates ( &progRelax[I++], 7, 23, WHITE,  MID, 2, 0); // 4 colorchanges
  instStates ( &progRelax[I++], 6, 23, WHITE,  MID, 2, 0); // 3 colorchanges
  instStates ( &progRelax[I++], 5, 23, WHITE,  MID, 2, 0); // 3 colorchanges
  instStates ( &progRelax[I++], 4, 23, WHITE,  MID, 2, 0); // 3 colorchanges
  instStates ( &progRelax[I++], 3, 23, WHITE,  MID, 2, 0); // 2 colorchanges
  instStates ( &progRelax[I++], 2, 660, WHITE,  MID, 2, 0); // 11 colorchanges
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

/*
 *  17 to 13 (13s)
 *  JUMP to 5hz (79s);
 *  JUMP ro 1Hz (797s) 11 changes at random spaces.
 */

void
deep_decompress(int prog)
{
  unsigned short int I = UINIT;

  XMuuzPrepInformation(DD, VERDD);
  instStates ( &progRelax[I++], 17, 13, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 16, 13, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 15, 13, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 14, 13, WHITE,  MID, 2, 0);
  instStates ( &progRelax[I++], 13, 13, WHITE,  MID, 2, 0);
  // JUMP to 9 (29s)
  instStates ( &progRelax[I++], 9, 29, WHITE,  MID, 2, 0);
  // JUMP to 5Hz
  instStates ( &progRelax[I++], 5, 79, WHITE,  MID, 2, 0);
  // JUMP to 1Hz
  instStates ( &progRelax[I++], 1, 797, WHITE,  MID, 2, 0); // 11 rand clrchgs
  // end of vector.
  instStates ( &progRelax[I++], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}

