/*
 * $Id: setAudioValues.c,v 1.1 2000/01/29 20:44:54 kline Exp kline $
 *       sound (volume and beats) routines.  invokes from various muuz
 *       functions.
 */

#include "globals.h"
#include "muuz.h"
#include "mixerControls.h"
#include "setAudioValues.h"
#include "muuztypes.h"
#include "muuzaudio.h"
#include "copyright.h"

#include "errMessage.h"

extern errMessage program;  // for emsg()
int doing_beats = 0;

void audioValues::
Octave()
{
  extern frequency_t frequency;
  extern octave_t octave;
  void do_beats(char *);

  program.emsg(nprint, "entering Octave with oct = (%d), freq = (%d)\n",
    octave, frequency);
    switch (octave)
    {
    case LOW:
      do_beats(low_o[frequency]);
      break;
    case MID:
      do_beats(medium_o[frequency]);
      break;
    case UPPER:
      do_beats(upper_o[frequency]);
      break; 
    case HIGH:
      do_beats(high_o[frequency]);
      break;
    } 
}
void audioValues::
Volume()
{
  class mixerControls audio;
  extern volume_t volume;

    program.emsg(nprint, "entering Volume, volume = (%d)\n", volume);

    switch(volume)
    {
    case 0:
      audio.doVolume(SET_VOLUME, VOFF, VOFF);
      break;
    case 1:
      audio.doVolume(SET_VOLUME, 10, 10);
      break;
    case 2:
      audio.doVolume(SET_VOLUME, 20, 20);
      break;
    case 3:
      audio.doVolume(SET_VOLUME, 30, 30);
      break;
    case 4:
      audio.doVolume(SET_VOLUME, 40, 40);
      break;
    case 5:
      audio.doVolume(SET_VOLUME, 50, 50);
      break;
    case 6:
      audio.doVolume(SET_VOLUME, 60, 60);
      break;
    case 7:
      audio.doVolume(SET_VOLUME, 70, 70);
      break;
    case 8:
      audio.doVolume(SET_VOLUME, 80, 80);
      break;
    case 9:
      audio.doVolume(SET_VOLUME, 90, 90);
      break;
    case 10:
      audio.doVolume(SET_VOLUME, 100, 100);
      break;
    }
}

void audioValues::
OffVolume()
{
  Arg wargs[1];
  short int n = 0;
  extern char *volumeDisplayLabels[];
  extern Widget displayVolume;
  class mixerControls audio;

puts("Turning Off");
  audio.doVolume(SET_VOLUME, 0, 0);
  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[VOFF] ); n++;
  XtSetValues(displayVolume, wargs, n);

  audio.ZXMuuzGetChannel();

}

void audioValues::
volumeDisplay(volume_t volume)
{
  Arg wargs[1];
  short int n = 0;
  extern char *volumeDisplayLabels[];
  extern Widget displayVolume;

  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[volume] ); n++;
  XtSetValues(displayVolume, wargs, n);
}


void audioValues::
OffVolumeDisplay()
{
  Arg wargs[1];
  short int n = 0;
  extern char *volumeDisplayLabels[];
  extern Widget displayVolume;

puts("Turning Off Vol Display!!");
  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[VOFF] ); n++;
  XtSetValues(displayVolume, wargs, n);
}



void audioValues::
displayCurrentVolume()
{
  class mixerControls audio;
  Arg wargs[1];
  int left, n = 0, right;
  extern char *volumeDisplayLabels[];
  extern Widget displayVolume;

  audio.getBothChannels(&right, &left);
  volume = (volume_t)(left/10);
  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[volume] ); n++;
  XtSetValues(displayVolume, wargs, n);
}


