/*
 * $Id: sleep.c,v 1.1 2000/01/29 20:45:00 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "muuzaudio.h"
#include "structs.h"
#include "xbm.h"
#include "copyright.h"

#include "xfonts.h"

#include "errMessage.h"

extern errMessage program;  // for emsg()


instance_t progSleep[100];


void
do_sleep(int prog)
{
  void XMuuzPrepInformation(char *function, char *version);
  void nap(int), goodnight(int), relax_into(int), sweet_dreams(int), 
    knockout(int), sleep_wake(int);

  program.emsg(nprint,"DO_SLEEP(): selecting prog = (%d)\n", prog,_fl_);

  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
  }



        switch(prog)
        {
        case 0:
		nap(prog);
		break;
        case 1:
		goodnight(prog);
		break;
        case 2:
		relax_into(prog);
		break;
        case 3:
		sweet_dreams(prog);
		break;
        case 4:
		knockout(prog);
		break;
        case 5:
		sleep_wake(prog);
		break;

        }

}

/*
 * 2-12hz 33
 */
void
nap(int prog)
{
#define NP "Nap()"
#define VERNP "0.00"
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progSleep[100];

  XMuuzPrepInformation(NP, VERNP);
  program.emsg(nprint, "ENTERING nap(): play = (%d), csl_flag = (%d)\n",
    play,csl_flag, _fl_);
  instStates ( &progSleep[++I], 12, 47, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 11, 51, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 10, 51, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 9, 51, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 8, 37, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 12, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 11, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 10, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 9, 23, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 8, 29, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 7, 23, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 19, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 7, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 17, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 13, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 13, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 13, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 13, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 31, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 31, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 31, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 11, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 2, 1500, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 3, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 7, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 8, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 9, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 10, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 11, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 12, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 4, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 5, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 7, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 8, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 9, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 10, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 11, 7, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 12, 39, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);

}

/*
 * 3-14: 27
 */

void 
goodnight(int prog)
{
#define GN "Goodnight()"
#define VERGN "0.00"
  //void XMuuzErrUnimplemented();
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progSleep[100];

  XMuuzPrepInformation(GN, VERGN);
  program.emsg(nprint, "ENTERING goodnight(): prog = (%d), csl_flag = (%d)\n",
    prog,csl_flag, _fl_);
  instStates ( &progSleep[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 1, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 1, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}

/*
 * 1-13hz: 37
 */

void 
relax_into(int prog)
{
#define RI "RelaxInto()"
#define VERRI "0.00"
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progSleep[100];

  XMuuzPrepInformation(RI, VERRI);
  program.emsg(nprint, "ENTERING nap(): play = (%d), csl_flag = (%d)\n",
    play,csl_flag, _fl_);
  instStates ( &progSleep[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 1, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], 6, 1, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);


}

/*
 * 2-11: 31
 */

void
sweet_dreams(int prog)
{
#define SD "SweetDreams()"
#define VERSD "0.00"
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);

  void startPrep(int);
  extern instance_t progSleep[100];

  XMuuzPrepInformation(SD, VERSD);
  program.emsg(nprint, "ENTERING goodnight(): play = (%d), csl_flag = (%d)\n",
    play,csl_flag, _fl_);
  instStates ( &progSleep[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 1, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);


}

/*
 * 1-10: 23
 */

void
knockout(int prog)
{
#define KO "Knockout()"
#define VERKO "0.00"
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progSleep[100]; 


  XMuuzPrepInformation(RI, VERRI);
  program.emsg(nprint, "ENTERING Knockout(): play = (%d), csl_flag = (%d)\n",
    play,csl_flag, _fl_);
  instStates ( &progSleep[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 1, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);

}

/*
 *  2-29: 57
 */

void
sleep_wake(int prog)
{
#define SW "SleepWake()"
#define VERSW "0.00"
  void XMuuzPrepInformation(char *function, char *version); 
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);

  void startPrep(int);
  extern instance_t progSleep[100];

  XMuuzPrepInformation(SW, VERSW);
  program.emsg(nprint, "ENTERING sleep_wake(): play = (%d), csl_flag = (%d)\n",
    play,csl_flag, _fl_);
  instStates ( &progSleep[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progSleep[I++], 1, 5, ORANGE, MID, 2, 0);
  instStates ( &progSleep[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}
