/* anim.c - Mandelbrot Explorer (animation setup and execution)
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
*/ 

#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include "mxp.h"

double atof();

/* Externals from xmandelf.c */
extern XtAppContext ctx;
extern Widget toplevel;
extern struct setup set;
extern Pixel def_bg;
extern Cursor hand_xcr;
extern void set_wm_hints();
extern void resize();

/* Externals from mandel.c */
extern struct zoomd *zoomp;
extern void resetmandel();
extern void mandel();
extern char *funits();
extern int iter;

/* Externals from file.c */
extern void read_setup();
extern void pop_down();
extern void create_gif();

/* Externals from colors.c */
extern Colormap cmap();
extern int bias;
extern int color_shift;
extern int color_mode;
extern int colors;
extern int need_cmap_upd;

/* Externals from draw.c */
extern Dimension wwidth;
extern Dimension wheight;

void do_animate();
void do_estimate();
void doit();
void anim_cancel();
void output_cb();
void progress_cb();
Boolean anim_step();

struct setup setsv;
Widget anim_popup, complete, giffs, show_p, total;
Widget go, estim, zoom_st, zoom_end, zoom_cur, stop;
Widget itr_st, itr_cur, itr_en;
Boolean show_prog = 1;
Boolean mk_gifs = 1;
int cframe;
int tot_frames;
int anim_id;
char *ptr;
char *pre;
double step;
int st_iter;
int end_iter;
double smag;
double ccmag;
double emag;
double uy2, ux2, ly2, lx2;
char st_file[MAX_NAME];
char end_file[MAX_NAME];
char dir[MAX_NAME];
char prefix[20];
char step_text[15];

void make_anim_popup()
{
	int i;
	Arg argies[6];
	Widget box, box1, temp, temp1, temp2;

	strcpy(st_file, "mxp1.rc");
	strcpy(end_file, "mxp2.rc");
	strcpy(prefix, "mand");
	strcpy(dir, "/tmp");
	strcpy(step_text, " 0.80");

	/*
	 * Creat a popup for animation setup
	 */
        i = 0;
	XtSetArg(argies[i], XtNtransient, FALSE); i++;
	anim_popup = XtCreatePopupShell("Animate", transientShellWidgetClass,
		toplevel, argies, i);
        i = 0;
        temp = XtCreateManagedWidget("animpane", panedWidgetClass,
                anim_popup, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNorientation, XtorientHorizontal); i++;
        temp1 = XtCreateManagedWidget("animpane", panedWidgetClass,
                temp, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNwidth, 120); i++;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        box = XtCreateManagedWidget("animpane", panedWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNwidth, 270); i++;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        box1 = XtCreateManagedWidget("animpane", panedWidgetClass,
                temp1, argies, i);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                box1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Starting Filename:", labelWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, MAX_NAME); i++;
        XtSetArg(argies[i], XtNstring, st_file); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        XtCreateManagedWidget("animtext", asciiTextWidgetClass,
                temp1, argies, i);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                box1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Ending Filename:  ", labelWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, MAX_NAME); i++;
        XtSetArg(argies[i], XtNstring, end_file); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        XtCreateManagedWidget("animtext", asciiTextWidgetClass,
                temp1, argies, i);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                box1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Output Directory: ", labelWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, MAX_NAME); i++;
        XtSetArg(argies[i], XtNstring, dir); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        XtCreateManagedWidget("animtext", asciiTextWidgetClass,
                temp1, argies, i);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                box1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("File Prefix:      ", labelWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, 20); i++;
        XtSetArg(argies[i], XtNstring, prefix); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        XtCreateManagedWidget("animtext", asciiTextWidgetClass,
                temp1, argies, i);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                box1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Scaling Factor:   ", labelWidgetClass,
                temp1, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNuseStringInPlace, TRUE); i++;
        XtSetArg(argies[i], XtNtype, XawAsciiString); i++;
        XtSetArg(argies[i], XtNlength, 5); i++;
        XtSetArg(argies[i], XtNstring, step_text); i++;
        XtSetArg(argies[i], XtNeditType, XawtextEdit); i++;
        XtCreateManagedWidget("animtext", asciiTextWidgetClass,
                temp1, argies, i);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	XtSetArg( argies[i], XtNstate, (XtArgVal)TRUE); i++;
	XtSetArg( argies[i], XtNlabel, "Display On"); i++;
        show_p = XtCreateManagedWidget(" ", toggleWidgetClass,
                box, argies, i);
	XtAddCallback(show_p, XtNcallback, progress_cb, (XtPointer)0);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	XtSetArg( argies[i], XtNstate, (XtArgVal)TRUE); i++;
	XtSetArg( argies[i], XtNlabel, "Create GIFs On"); i++;
        giffs = XtCreateManagedWidget(" ", toggleWidgetClass,
                box, argies, i);
	XtAddCallback(giffs, XtNcallback, output_cb, (XtPointer)0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        estim = XtCreateManagedWidget("Estimate", commandWidgetClass,
                box, argies, i);
	XtAddCallback(estim, XtNcallback, do_estimate, (XtPointer)0);
        go = XtCreateManagedWidget("GO", commandWidgetClass,
                box, argies, i);
	XtAddCallback(go, XtNcallback, do_animate, (XtPointer)0);
	XtSetArg(argies[i], XtNsensitive, FALSE); i++;
        stop = XtCreateManagedWidget("Stop", commandWidgetClass,
                box, argies, i);
	XtAddCallback(stop, XtNcallback, anim_cancel, (XtPointer)0);
	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp2 = XtCreateManagedWidget("Close", commandWidgetClass,
                box, argies, i);
	XtAddCallback(temp2, XtNcallback, anim_cancel, (XtPointer)1);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                temp, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Frames:            Estimate", labelWidgetClass,
                temp1, argies, i);
        total = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("  Curr", labelWidgetClass,
                temp1, argies, i);
        complete = XtCreateManagedWidget("     0", labelWidgetClass,
                temp1, NULL, 0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                temp, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Zoom: Start", labelWidgetClass,
                temp1, argies, i);
        zoom_st = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("   End", labelWidgetClass,
                temp1, argies, i);
        zoom_end = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("  Curr", labelWidgetClass,
                temp1, argies, i);
        zoom_cur = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);

	i = 0;
	XtSetArg( argies[i], XtNshowGrip, (XtArgVal)FALSE); i++;
        temp1 = XtCreateManagedWidget("animbox", boxWidgetClass,
                temp, argies, i);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("Iter: Start", labelWidgetClass,
                temp1, argies, i);
        itr_st = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("   End", labelWidgetClass,
                temp1, argies, i);
        itr_en = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);
        i = 0;
        XtSetArg(argies[i], XtNborderWidth, 0); i++;
        XtSetArg(argies[i], XtNbackground, def_bg); i++;
        XtCreateManagedWidget("  Curr", labelWidgetClass,
                temp1, argies, i);
        itr_cur = XtCreateManagedWidget("      ", labelWidgetClass,
                temp1, NULL, 0);

	XtRealizeWidget(anim_popup);
	set_wm_hints(anim_popup, "Animate", "Animate", NULL, hand_xcr);
}

/*
 * Process the passed string, strip leading spaces and newlines
 */
char *trim_string(str)
char *str;
{
	char *st;

        for (st=str; st!='\0'; st++) {
                if (!isspace(*st)) {
                        break;
                }
        }
	return(st);
}

void animate()
{
	Arg arg[1];

	/*
	 * Save current setup info
	 */
	memcpy(&setsv, &set, sizeof(struct setup));

	XtSetArg(arg[0], XtNlabel, "     0");
        XtSetValues(total, arg, 1);
        XtSetValues(complete, arg, 1);
        XtSetValues(zoom_st, arg, 1);
        XtSetValues(zoom_end, arg, 1);
        XtSetValues(zoom_cur, arg, 1);
        XtSetValues(itr_st, arg, 1);
        XtSetValues(itr_en, arg, 1);
        XtSetValues(itr_cur, arg, 1);

        XtPopup(anim_popup, XtGrabExclusive);
}

void do_animate()
{
	doit(1);
	doit(0);
}

void do_estimate()
{
	doit(1);
}

void doit(estimate)
int estimate;
{
	Arg arg[1];
	char text[10];
	double ux1, uy1, lx1, ly1;
	double dist;
	double uxd, lxd;

	XtSetArg(arg[0], XtNsensitive, FALSE);
        XtSetValues(go, arg, 1);
        XtSetValues(estim, arg, 1);
	XtSetArg(arg[0], XtNsensitive, TRUE);
        XtSetValues(stop, arg, 1);

	step = atof(step_text);
	if (step >= 1.0) {
		step = 0.999;
	}
       	sprintf(step_text, "%4.3f\n", step);

	ptr = trim_string(st_file);
	read_setup(ptr, 0);
	ux1 = set.upper_x;
	lx1 = set.lower_x;
	uy1 = set.upper_y;
	ly1 = set.lower_y;
	smag = set.mag;
	st_iter = set.iter;

	ptr = trim_string(end_file);
	read_setup(ptr, 0);
	ux2 = set.upper_x;
	lx2 = set.lower_x;
	uy2 = set.upper_y;
	ly2 = set.lower_y;
	emag = set.mag;
	end_iter = set.iter;
	ccmag = ux1 - lx1;
	cframe = 0;

	if (estimate) {
		while (ux1 > ux2) {
			dist = (ux1 - lx1) * (1.0 - step);
			uxd = ux1 - ux2;
			lxd = lx2 - lx1;
			ux1 -= dist * uxd / (uxd + lxd);
			lx1 += dist * lxd / (uxd + lxd);
			cframe++;
		}
		XtSetArg(arg[0], XtNlabel, text);
       		sprintf(text, "%6d", cframe);
		XtSetValues(total, arg, 1);
		tot_frames = cframe;
		XtSetArg(arg[0], XtNsensitive, TRUE);
		XtSetValues(go, arg, 1);
		XtSetValues(estim, arg, 1);
		XtSetArg(arg[0], XtNsensitive, FALSE);
		XtSetValues(stop, arg, 1);
		return;
	}

	color_mode = set.color_mode;
	color_shift = set.color_shift;
	colors = set.colors;
	bias = set.bias;
	need_cmap_upd = 1;
	if (wwidth != set.win_wid || wheight != set.win_hgt) {
		resize(set.win_wid, set.win_hgt, -1);
	}

	XtSetArg(arg[0], XtNlabel, text);
       	sprintf(text, "%6s", funits(smag, 6, 1));
	XtSetValues(zoom_st, arg, 1);
       	sprintf(text, "%6s", funits(emag, 6, 1));
	XtSetValues(zoom_end, arg, 1);
       	sprintf(text, "%6d", end_iter);
	XtSetValues(itr_en, arg, 1);
       	sprintf(text, "%6d", st_iter);
	XtSetValues(itr_st, arg, 1);

	zoomp->ux = ux1;
	zoomp->lx = lx1;
	zoomp->uy = uy1;
	zoomp->ly = ly1;
	iter = st_iter;

	ptr = trim_string(dir);
	pre = trim_string(prefix);

	anim_id = XtAppAddWorkProc(ctx, anim_step, (XtPointer)0);
}

Boolean anim_step()
{
	Arg arg[1];
	char text[80];
	double dist;
	double uxd, lxd, uyd, lyd;
	
	if (show_prog) {
		mandel(M_SYNC);
	} else {
		mandel(M_NODISP|M_SYNC);
	}

	if (mk_gifs) {
		sprintf(text, "%s/%s%.3d.gif", ptr, pre, cframe);
		create_gif(text);
	}

	XtSetArg(arg[0], XtNlabel, text);
       	sprintf(text, "%6d", ++cframe);
	XtSetValues(complete, arg, 1);
       	sprintf(text, "%6d", iter);
	XtSetValues(itr_cur, arg, 1);
       	sprintf(text, "%6s", funits((smag*ccmag)/(zoomp->ux-zoomp->lx), 6, 1));
	XtSetValues(zoom_cur, arg, 1);

	iter += (end_iter - st_iter) / tot_frames;

	dist = (zoomp->ux - zoomp->lx) * (1.0 - step);
	uxd = zoomp->ux - ux2;
	lxd = lx2 - zoomp->lx;
	zoomp->ux -= dist * uxd / (uxd + lxd);
	zoomp->lx += dist * lxd / (uxd + lxd);
	dist = (zoomp->uy - zoomp->ly) * (1.0 - step);
	uyd = zoomp->uy - uy2;
	lyd = ly2 - zoomp->ly;
	zoomp->uy -= dist * uyd / (uyd + lyd);
	zoomp->ly += dist * lyd / (uyd + lyd);
	if ((zoomp->ux - zoomp->lx) < (ux2 - lx2)) {
		XtSetArg(arg[0], XtNsensitive, TRUE);
		XtSetValues(go, arg, 1);
		XtSetValues(estim, arg, 1);
		XtSetArg(arg[0], XtNsensitive, FALSE);
		XtSetValues(stop, arg, 1);
		return(TRUE);
	}
	return(FALSE);
}

void anim_cancel(w, close)
Widget w;
int close;
{
	Arg arg[1];

	if (anim_id != 0) {
                XtRemoveWorkProc(anim_id);
        }
	XtSetArg(arg[0], XtNsensitive, TRUE);
        XtSetValues(go, arg, 1);
        XtSetValues(estim, arg, 1);
	if (close) {
	        XtPopdown(anim_popup);

		/*
	 	 * Restore setup info
	 	 */
		memcpy(&set, &setsv, sizeof(struct setup));
		if (wwidth != set.win_wid || wheight != set.win_hgt) {
			resize(set.win_wid, set.win_hgt, -1);
		}
		resetmandel(0);
	}
}

void output_cb()
{
	Arg arg[1];
	
	XtSetArg(arg[0], XtNstate, &mk_gifs);
        XtGetValues(giffs, arg, 2);

	if (mk_gifs) {
		XtSetArg(arg[0], XtNlabel, "Create GIFs On");
	} else {
		XtSetArg(arg[0], XtNlabel, "Create GIFs Off");
	}
        XtSetValues(giffs, arg, 1);
}
	
void progress_cb()
{
	Arg arg[1];
	
	XtSetArg(arg[0], XtNstate, &show_prog);
        XtGetValues(show_p, arg, 1);

	if (show_prog) {
		XtSetArg(arg[0], XtNlabel, "Display On");
	} else {
		XtSetArg(arg[0], XtNlabel, "Display Off");
	}
        XtSetValues(show_p, arg, 1);
}
