/* menu.c - Mandelbrot Explorer (setup for pull down menus)
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include "mxp.h"

#define SME	1
#define LINE	2
void exit();

/* externals from colors.c */
extern int color_mode;
extern int color_shift;
extern int mode;
extern void color_scheme();
extern void color_seq();

/* externals from draw.c */
extern void set_aspect();
extern void menu_resize();

/* externals from xmandelf.c */
extern Pixmap marker;
extern void quit();

/* externals from file.c */
extern void clear_defaults();
extern void save_setup();
extern void save_setup_as();
extern void load_setup();
extern void write_image();
extern void animate();
extern void dump_data();

/* externals from mandel.c */
extern void resetmandel();
extern void animate();

/* externals from file.c */
struct menud *get_menu();
struct menud *size_menu;
struct menud *scheme_menu;
struct menud *seq_menu;

void create_menu();
void free_menu();

void make_menus(parent)
Widget parent;
{
	int i;
	struct menud *file_menu;

	/*
	 * Create file menu
	 */
	file_menu = get_menu(12);
	file_menu->name = "file";
	file_menu->label = "File ->";
	file_menu->margin = 5;
	i = 0;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Save Default";
	file_menu->entry[i].callb = save_setup;
	file_menu->entry[i].data = (XtPointer)0;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Reset Defaults";
	file_menu->entry[i].callb = clear_defaults;
	file_menu->entry[i].data = (XtPointer)0;
	i++;
	file_menu->entry[i].label = "Save Setup";
	file_menu->entry[i].callb = save_setup_as;
	file_menu->entry[i].data = (XtPointer)0;
	file_menu->entry[i].type = SME;
	i++;
	file_menu->entry[i].label = "Load Setup";
	file_menu->entry[i].callb = load_setup;
	file_menu->entry[i].data = (XtPointer)0;
	file_menu->entry[i].type = SME;
	i++;
	file_menu->entry[i].type = LINE;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Animate";
	file_menu->entry[i].callb = animate;
	file_menu->entry[i].data = (XtPointer)0;
	i++;
	file_menu->entry[i].type = LINE;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Create GIF";
	file_menu->entry[i].callb = write_image;
	file_menu->entry[i].data = (XtPointer)write_image;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Dump Xplot Data";
	file_menu->entry[i].callb = dump_data;
	file_menu->entry[i].data = (XtPointer)0;
	i++;
	file_menu->entry[i].type = LINE;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Reset";
	file_menu->entry[i].callb = resetmandel;
	file_menu->entry[i].data = (XtPointer)1;
	i++;
	file_menu->entry[i].type = SME;
	file_menu->entry[i].label = "Quit";
	file_menu->entry[i].callb = quit;
	file_menu->entry[i].data = (XtPointer)0;
	create_menu(file_menu, parent);
	free_menu(file_menu);
	
	/*
	 * Create size menu
	 */
	size_menu = get_menu(15);
	size_menu->name = "size";
	size_menu->label = "Size ->";
	size_menu->margin = 15;
	i = 0;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 128 x 96";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)0;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 192 x 144";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)1;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 320 x 240";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)2;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 512 x 384";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)3;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 640 x 480";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)4;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 800 x 600";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)5;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 896 x 672";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)6;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 1024 x 768";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)7;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 1280 x 1024";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)8;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 1600 x 1200";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)9;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 4000 x 2730";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)10;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " 8000 x 5470";
	size_menu->entry[i].callb = menu_resize;
	size_menu->entry[i].data = (XtPointer)11;
	i++;
	size_menu->entry[i].type = LINE;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " Fixed Aspect";
	size_menu->entry[i].callb = set_aspect;
	size_menu->entry[i].data = (XtPointer)13;
	i++;
	size_menu->entry[i].type = SME;
	size_menu->entry[i].label = " Var Aspect";
	size_menu->entry[i].callb = set_aspect;
	size_menu->entry[i].data = (XtPointer)14;
	create_menu(size_menu, parent);
	
	/*
	 * Create color Scheme menu
	 */
	scheme_menu = get_menu(11);
	scheme_menu->name = "color_sch";
	scheme_menu->label = "Color Scheme ->";
	scheme_menu->margin = 15;
	i = 0;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Default";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)0;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Bright";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)1;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Dark";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)2;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Sharp";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)3;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Blue-White";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)4;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Purple-White";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)5;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Blue-Green";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)6;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Red-Blue";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)7;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Red-Green";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)8;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Gray Scale";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)9;
	i++;
	scheme_menu->entry[i].type = SME;
	scheme_menu->entry[i].label = " Gray Scale Rv";
	scheme_menu->entry[i].callb = color_scheme;
	scheme_menu->entry[i].data = (XtPointer)10;
	create_menu(scheme_menu, parent);
	
	/*
	 * Create color Scheme menu
	 */
	seq_menu = get_menu(10);
	seq_menu->name = "color_seq";
	seq_menu->label = "Color Inc ->";
	seq_menu->margin = 15;
	i = 0;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 1";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)0;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 2";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)1;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 4";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)2;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 8";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)3;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 16";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)4;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 32";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)5;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 64";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)6;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Incr 128";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)7;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Square Root";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)8;
	i++;
	seq_menu->entry[i].type = SME;
	seq_menu->entry[i].label = " Single Seq";
	seq_menu->entry[i].callb = color_seq;
	seq_menu->entry[i].data = (XtPointer)9;
	create_menu(seq_menu, parent);
}

struct menud *get_menu(count) 
int count;
{
	struct menud *me;

	if ((me = (struct menud *)malloc(sizeof(struct menud))) == NULL) {
		printf("malloc failed\n");
		exit(1);
	}
	if ((me->entry = (struct menu_ent *)malloc(count *
		sizeof(struct menu_ent))) == NULL) {
		printf("malloc failed\n");
		exit(1);
	}
	me->count = count;
	return(me);
}

void create_menu(me, parent)
struct menud *me;
Widget parent;
{
	int i, n;
	Arg arg[2];

	i = 0;
	XtSetArg( arg[i], XtNshowGrip, (XtArgVal)FALSE); i++;
	XtSetArg( arg[i], XtNmenuName, (XtArgVal)me->name); i++;
	me->button = XtCreateManagedWidget(me->label, menuButtonWidgetClass,
	    parent, arg, i);
	me->popup = XtCreatePopupShell(me->name, simpleMenuWidgetClass,
	    me->button, NULL, 0);

	i = 0;
	XtSetArg( arg[i], XtNleftMargin, (XtArgVal)me->margin); i++;
	for (n = 0; n<me->count; n++) {
		switch(me->entry[n].type) {
		case LINE:
			XtCreateManagedWidget("", smeLineObjectClass,
				me->popup, NULL, 0);
			break;
		case SME:
			me->entry[n].button = XtCreateManagedWidget(
				me->entry[n].label,
				smeBSBObjectClass, me->popup, arg, i);
				XtAddCallback(me->entry[n].button, XtNcallback,
				me->entry[n].callb, me->entry[n].data);
			break;
		}
	}
}

void free_menu(me)
struct menud *me;
{
	free(me->entry);
	free(me);
}
