# Uniconf Unifed Configuration Module for Python (Cross-Platform)
# Wrapper for GConf, WinReg, Others?
# Copyright 2004, Ryan Pavlik
# NO WARRANTY
import sys
import os
import string

def osDetect():
    global pDelim
    testpath = '/dev'
    isTWin = FALSE
    pDelim = '/'
    if not os.path.isdir(testpath):
        pDelim = '/'
        isTWin = TRUE
    return isTWin

isWin=osDetect()

if isWin:
    import _winreg
else:
    import gconf

class settings:
    # Set Application Key (name, no spaces) for use across all platforms
    global appKey
    
    def __init__(self):
        if not isWin:
            # GConf Initialize
            # Get the default client
            m_GConfClient = gconf.client_get_default()
        if isWin:
            pass

    # Read setting value.  Equivalent to .get_string on GConf
    def readValue(self, key):
        if not isWin:
            value = m_GConfClient.get_string('/apps/'+appKey+'/'+key)
        if isWin:
            value = NONE
        return value

    # Write setting value.  Equivalent to .set_string on GConf
    def setValue(self, key, value):
        if not isWin:
            m_GConfClient.set_string('/app/'+appKey+'/'key, value)
        if isWin:
            pass
        
