/********************************************************************************
NDPMon - Neighbor Discovery Protocol Monitor
Copyright (C) 2006 MADYNES Project, LORIA - INRIA Lorraine (France)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

Author Info:
  Name: Thibault Cholez
  Mail: thibault.cholez@esial.uhp-nancy.fr

Maintainer:
  Name: Frederic Beck
  Mail: frederic.beck@loria.fr

MADYNES Project, LORIA-INRIA Lorraine, hereby disclaims all copyright interest in
the tool 'NDPMon' (Neighbor Discovery Protocol Monitor) written by Thibault Cholez.

Olivier Festor, Scientific Leader of the MADYNEs Project, 20 August 2006
***********************************************************************************/


#include "alarm.h"

static int watch;


/*Define if warnings must be reported*/
void set_alarm(int b)
{
	watch = b;
}

/*Notify the waning message from buffer
 *according to the severity
 */
void notify(int result, char* buffer)
{
	if(watch)
	{
		char message[255];
		switch (result) 
		{
			case 0:
				printf("No problem \n");
				break;
			case 1:
				/*syslog advertisment*/
				printf("Warning: %s \n", buffer);
				if(!already_sent(buffer))
					syslog(LOG_INFO, " %s ", buffer);
				break;
			case 2:
				/*syslog + mail advertisment*/
				printf("Warning: %s \n", buffer);
				if(!already_sent(buffer))
				{
					sprintf(message, "Warning: %s \n", buffer);
					syslog(LOG_INFO, " %s ", buffer);
					mail(message);
				}
				break;
			default:
				printf ("No problem \n");
				break;
		}
	}
}


/*Send a mail to the admin containing the message*/
void mail(char* message)
{
	FILE *pp;
	static int init=0;
	static char args[128];/*shoule be sufficient*/

	if(!init)
	{
		sprintf(args, "mail -s NDPMon_Security_Alert %s ", admin_mail);
	}  

	printf("Sending mail alert ...\n");
	pp = popen(args, "w");
	if (pp == NULL) 
	{ 
		perror("popen error: unable to send mail"); 
	}

	fputs(message, pp); 

	pclose(pp);
}


/*Test if the message has been recently send to avoid
 *multiple warnings for the same problem
 */
int already_sent(char* message)
{
	static char old_messages[HISTORY_LENGTH][255];
	static int index=0;
	int i;

	for (i=0; i<HISTORY_LENGTH; i++)
	{
		if (!strcmp(message, old_messages[i]))
			return 1;
	}

	strcpy(old_messages[index], message);

	if(index==HISTORY_LENGTH-1)
		index=0;
	else
		index++;

	return 0;
}
