#include "routers.h"

int is_router_lla_in(router_list_t *list, struct in6_addr lla)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
			return 1;

		tmp = tmp->next;
	}

	return 0;
}

int is_router_mac_in(router_list_t *list, struct ether_addr eth)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
			return 1;

		tmp = tmp->next;
	}

	return 0;
}

int is_router_in(router_list_t *list, struct in6_addr lla, struct ether_addr eth)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
			if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
				return 1;

		tmp = tmp->next;
	}

	return 0;
}


router_list_t * get_router_lla_in(router_list_t *list, struct in6_addr lla)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
			return tmp;

		tmp = tmp->next;
	}

	return NULL;
}

router_list_t * get_router_mac_in(router_list_t *list, struct ether_addr eth)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
			return tmp;

		tmp = tmp->next;
	}

	return NULL;
}

router_list_t * get_router_in(router_list_t *list, struct in6_addr lla, struct ether_addr eth)
{
	router_list_t *tmp = list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
			if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
				return tmp;

		tmp = tmp->next;
	}

	return NULL;
}

int add_router(router_list_t **list, struct in6_addr lla, struct ether_addr eth)
{
	router_list_t *tmp = *list,*new=NULL;

	if(is_router_in(*list,lla,eth))
	{
		fprintf(stderr,"Router already in list\n");
		return 0;
	}

	if( (new=(router_list_t *)malloc(sizeof(router_list_t))) == NULL)
	{
		perror("malloc");
		return 0;
	}

	new->mac = eth;
	new->lla = lla;
	new->addresses = NULL;
	new->prefixes = NULL;
	new->next = NULL;

	if(*list != NULL)
	{
		while(tmp->next != NULL)
			tmp=tmp->next;
		tmp->next=new;
	}
	else
		 *list = new;
	
	return 1;
}

int add_prefix(router_list_t **list, struct in6_addr lla, struct ether_addr eth, struct in6_addr prefix, int mask)
{
	router_list_t *tmp = *list;
	prefix_t *new = NULL;

	/*
	if(is_prefix_in(lla,eth,prefix))
	{
		fprintf(stderr,"Prefix already in list\n");
		return 0;
	}
	*/

	if( (new=(prefix_t *)malloc(sizeof(prefix_t))) == NULL)
	{
		perror("malloc");
		return 0;
	}

	new->prefix = prefix;
	new->mask = mask;
	new->next=NULL;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
			if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
			{
				prefix_t *ptmp = tmp->prefixes;
				if(ptmp == NULL)
					tmp->prefixes = new;
				else
				{
					while(ptmp->next != NULL)
						ptmp=ptmp->next;
					ptmp->next=new;
				}
				return 1;
			}
		}
		else
			tmp = tmp->next;
	}
	
	return 0;
}


int router_has_prefix(router_list_t *list, struct in6_addr lla, struct ether_addr eth, struct in6_addr prefix, int mask)
{
	router_list_t *tmp = list;
	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
			if(IN6_ARE_ADDR_EQUAL(&lla,&(tmp->lla)))
			{
				prefix_t *ptmp = tmp->prefixes;
				while(ptmp != NULL)
				{
					if( (ptmp->mask == mask) && (IN6_ARE_ADDR_EQUAL(&prefix,&(ptmp->prefix))) )
						return 1;

					ptmp = ptmp->next;
				}
				return 0;
			}
		}
		tmp = tmp->next;
	}
	return 0;
}

int add_router_address(router_list_t **list, struct ether_addr eth, struct in6_addr addr)
{
	router_list_t *tmp = *list;
	address_t *new = NULL;

	
	if(router_has_address(*list,eth,addr))
	{
		fprintf(stderr,"Address already in list\n");
		return 0;
	}
	

	if( (new=(address_t *)malloc(sizeof(address_t))) == NULL)
	{
		perror("malloc");
		return 0;
	}

	new->address = addr;
	new->next=NULL;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
				address_t *atmp = tmp->addresses;
				if(atmp == NULL)
					tmp->addresses = new;
				else
				{
					while(atmp->next != NULL)
						atmp=atmp->next;
					atmp->next=new;
				}
				return 1;
		}
		else
			tmp = tmp->next;
	}
	
	return 0;
}


int router_has_address(router_list_t *list, struct ether_addr eth, struct in6_addr addr)
{
	router_list_t *tmp = list;
	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
				address_t *atmp = tmp->addresses;
				while(atmp != NULL)
				{
					if( IN6_ARE_ADDR_EQUAL(&addr,&(atmp->address)) )
						return 1;

					atmp = atmp->next;
				}
				return 0;
		}
		tmp = tmp->next;
	}
	return 0;
}

int nb_router(router_list_t *routers)
{
	int n = 0;
	router_list_t *tmp = routers;

	while(tmp != NULL)
	{
		n++;
		tmp=tmp->next;
	}

	return n;
}


void print_routers(router_list_t *list)
{
	router_list_t *tmp = list;
	while(tmp != NULL)
	{
		char eth[ETH_ADDRSTRLEN+1], lla[INET6_ADDRSTRLEN+1];
		prefix_t *ptmp = tmp->prefixes;
		address_t *atmp = tmp->addresses;

		ipv6_ntoa(lla,tmp->lla);
		strcpy(eth,ether_ntoa(&(tmp->mac)));
		fprintf(stderr,"Router (%s,%s) :\n", eth, lla);

		fprintf(stderr,"\tAddress(es):");
		while(atmp != NULL)
		{
			char addr[48];
			ipv6_ntoa(addr,atmp->address);
			fprintf(stderr,"\t%s", addr);
			atmp=atmp->next;
		}
		fprintf(stderr,"\n");

		fprintf(stderr,"\tPrefix(es):");
		while(ptmp != NULL)
		{
			char prefix[64];
			ipv6_ntoa(prefix,ptmp->prefix);
			sprintf(prefix,"%s/%d", prefix,ptmp->mask);
			fprintf(stderr,"\t%s", prefix);
			ptmp=ptmp->next;
		}
		fprintf(stderr,"\n\n");
		tmp=tmp->next;
	}
}

int clean_router_prefixes(router_list_t **list, struct ether_addr eth)
{
	router_list_t *tmp = *list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
			prefix_t *ptmp = tmp->prefixes, *ptodel = NULL;

			while( ptmp != NULL)
			{
				ptodel = ptmp;
				ptmp = ptmp->next;
				free(ptodel);
			}

			return 1;
		}

		tmp = tmp->next;
	}

	return 0;
}


int clean_router_addresses(router_list_t **list, struct ether_addr eth)
{
	router_list_t *tmp = *list;

	while(tmp != NULL)
	{
		if(!MEMCMP(&eth,&(tmp->mac), sizeof(struct ether_addr)))
		{
			address_t *atmp = tmp->addresses, *atodel = NULL;

			while( atmp != NULL)
			{
				atodel = atmp;
				atmp = atmp->next;
				free(atodel);
			}

			return 1;
		}

		tmp = tmp->next;
	}

	return 0;
}

int clean_routers(router_list_t **list)
{
	router_list_t *tmp = *list, *rtodel = NULL;

	while(tmp != NULL)
	{
		rtodel = tmp;
		clean_router_addresses(list,tmp->mac);
		clean_router_prefixes(list,tmp->mac);
		tmp = tmp->next;
		free(rtodel);
	}

	return 1;
}


