#ifndef _ROUTER_LIST_H_
#define _ROUTER_LIST_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <net/if.h>
#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <signal.h>
#include <time.h>

#include "print_packet_info.h"
#include "ndpmon_defs.h"

typedef struct prefix{
        struct in6_addr prefix;
	int mask;
	struct prefix *next;
}prefix_t;

typedef struct router_list{
	struct ether_addr mac;
	struct in6_addr lla;
	address_t *addresses;
	prefix_t *prefixes;
	struct router_list *next;
}router_list_t;

int is_router_lla_in(router_list_t *list, struct in6_addr lla);
int is_router_mac_in(router_list_t *list, struct ether_addr eth);
int is_router_in(router_list_t *list, struct in6_addr lla, struct ether_addr eth);

int add_router(router_list_t **list, struct in6_addr lla, struct ether_addr eth);
int add_prefix(router_list_t **list, struct in6_addr lla, struct ether_addr eth, struct in6_addr prefix, int mask);
int router_has_prefix(router_list_t *list, struct in6_addr lla, struct ether_addr eth, struct in6_addr prefix, int mask);

int router_has_address(router_list_t *list, struct ether_addr eth, struct in6_addr addr);
int add_router_address(router_list_t **list, struct ether_addr eth, struct in6_addr addr);

int nb_router(router_list_t *routers);
void print_routers(router_list_t *list);

int clean_router_prefixes(router_list_t **list, struct ether_addr eth);
int clean_router_addresses(router_list_t **list, struct ether_addr eth);
int clean_routers(router_list_t **list);

#endif
