/********************************************************************************
NDPMon - Neighbor Discovery Protocol Monitor
Copyright (C) 2006 MADYNES Project, LORIA - INRIA Lorraine (France)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

Author Info:
  Name: Thibault Cholez
  Mail: thibault.cholez@esial.uhp-nancy.fr

Maintainer:
  Name: Frederic Beck
  Mail: frederic.beck@loria.fr

MADYNES Project, LORIA-INRIA Lorraine, hereby disclaims all copyright interest in
the tool 'NDPMon' (Neighbor Discovery Protocol Monitor) written by Thibault Cholez.

Olivier Festor, Scientific Leader of the MADYNEs Project, 20 August 2006
***********************************************************************************/

#ifndef _UTILS_H_
#define _UTILS_H_ 1

#define ETHERNET_SIZE 14 /* ethernet headers are 14 bytes */
#define IPV6_SIZE 40 /* ipv6 headers without fragment ... are 40 bytes */
#define ICMP6_HEADER_SIZE 8
#define ETHERTYPE_IPV6 0x86dd

/*Size to build char* address in a readable form*/
#define IP6_STR_SIZE 40 /*xxxx:xxxx:xxx:xxxx:xxxx:xxxx:xxxx:xxxx*/
#define MAC_STR_SIZE 18 /*xx:xx:xx:xx:xx:xx*/

#define IN6_ARE_PRE_EQUAL(a,b) \
	((((__const uint32_t *) (a))[0] == ((__const uint32_t *) (b))[0])     \
	 && (((__const uint32_t *) (a))[1] == ((__const uint32_t *) (b))[1])  \
	 )

#define MEMCMP(a, b, n) memcmp((char *)a, (char *)b, n)
#define STRCMP(a, b) strcmp((char *)a, (char *)b)
#define DAY_TIME 86400
#define ETH_CHANGE_SIZE 10


typedef struct address {
        struct in6_addr address;
	struct address *next;
} address_t;

#endif
