/*--------------------------------------------------------------------
  safty profile I/O module.

    Copyright (c) 1998,1999,2000 SASAKI Shunsuke.
    All rights reserved. 
--------------------------------------------------------------------*/
#include "ed.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

void	safty_write_proc(const char *s,FILE *fp)
{
	if (s!=NULL)
		fputs(s,fp);
}

bool	safty_write(char *fn)
{
	FILE	*fp;

	if (access(fn,F_OK)==0&& access(fn,W_OK)==-1)
		return FALSE;

	fp=fopen(fn,"w"); 
	if (fp==NULL) 
		return FALSE;

	lists_proc(safty_write_proc,fp,GetTopNumber(),GetLastNumber());

	fclose(fp);

	return TRUE;
}

void	profile_write()
{
	int 	i;
	char	buf[LN_path+1],fn[LN_path+1],savedir[LN_path+1];
	FILE	*fp;
	struct	stat	st;

	char	sp[MAX_edfiles][LN_path+1];
	bool	mf;

	mf=FALSE;
	for (i=0; i<MAX_edfiles; i++)
		{
		 *sp[i]='\0';
		 if (*edbuf[i].path!='\0'&& edbuf[i].cf) 
		 	{
		 	 mf=TRUE;
		 	 break;
		 	}
		}

	if (mf)
		{
		 sysinfo_path(savedir,".neTmp");
		 if (stat((char *)savedir, &st) < 0) 
		 	{
		 	 if (mkdir(savedir, 0700)<0)
		 	 	{
		 	 	 fprintf(stderr, "Unable to create directory \"%s\"\n", savedir);
		 	 	 perror("");
		 	 	 return;
		 	 	}
		 	}
		 if (chdir(savedir) == -1)
		 	return;
		}

	for (i=0; i<MAX_edfiles; i++)
		{
		 if (*edbuf[i].path!='\0') 
		 	{
		 	 CurrentFileNo=i;
		 	 if (edbuf[i].cf)
		 	 	{
		 	 	 sprintf(buf,"Nx%06dXXXXXX",i);
		 	 	 sprintf(fn,"%s/%s",savedir,(char *)mktemp(buf));

		 	 	 if (safty_write(fn))
		 	 	 	{
		 	 	 	 strcpy(sp[i],fn);
		 	 	 	 chmod(fn,0600);
		 	 	 	}
		 	 	}
		 	 if (*sp[i]=='\0')
		 	 	strcpy(sp[i],edbuf[i].path);
		 	}
		}

	sysinfo_path(fn,".neprof");
	fp=fopen(fn,"w");
	if (fp==NULL)
		{
		 fprintf(stderr, "Unable to create profile \"%s\"\n", fn);
		 perror("");
		 return;
		}

	fprintf(fp,"%s\n",PROFILE_VERSION);
	for (i=0; i<MAX_edfiles; i++)
		{
		 if (*edbuf[i].path!='\0')
		 	{
		 	 CurrentFileNo=i;
		 	 fprintf(fp,"%s:%ld:\t%s:%d:%d\n" ,sp[i] ,GetLineOffset()
		 	 	,edbuf[i].path ,edbuf[i].kc ,edbuf[i].rm);
		 	}
		}
	fclose(fp);
}

int 	profile_read()
{
	FILE	*fp;
	char	buf[LN_path+1],fn[LN_path+1];
	char	tmp[MAXEDITLINE+1];
	char	*p,*sp,*q;
	int 	i;
	long	jl;
	struct stat	sbuf;

	sysinfo_path(fn, ".neprof");

	fp=fopen(fn,"r");
	if (fp==NULL) 
		{
failed:
/*fprintf(stderr,"failed\n");*/
		 return FALSE;
		}

	fgets(buf, LN_path, fp);
	i=strlen(buf);
	if (i>0 && buf[i-1]=='\n')
		buf[i-1] = '\0';
	if (strcmp(buf,PROFILE_VERSION)!=0)
		goto failed;

	system_msg(WAITING_MSG);
	while (fgets(buf,LN_path,fp)!=NULL) 
		{
		 sp=buf;
		 q=p=strsep(&sp,":");
		 if (!FileOpenOp(p))
		 	continue;

		 p=strsep(&sp,":");
		 if (p==NULL)
		 	continue;
		 jl=atol(p);
		 csr_setly(jl);

		 p=strsep(&sp,":");
		 if (p==NULL)
		 	continue;
		 while(isspace(*p))
		 	++p;
		 if (strcmp(edbuf[CurrentFileNo].path,p)!=0)
		 	{
			 if (edbuf[CurrentFileNo].ct==-1&&GetLastNumber()==1)
			 	{
			 	 sprintf(tmp,"profile: ե`%s'ޤ",p);
				 inkey_wait(tmp);

			 	 edbuf_rm(CurrentFileNo);
			 	 lists_clear();

			 	 FileOpenOp(p);
			 	 csr_setly(jl);
			 	} else
			 	{
			 	 strcpy(edbuf[CurrentFileNo].path,p);
		 	 	 SetFileChangeFlag();
			 	 edbuf[CurrentFileNo].ct= stat(p,&sbuf)==-1?
			 	 	-1: sbuf.st_ctime;

			 	 unlink(q);
			 	}
			}

		 p=strsep(&sp,":");
		 if (p==NULL)
		 	continue;
		 edbuf[CurrentFileNo].kc= atoi(p)%3;

		 p=strsep(&sp,":");
		 if (p==NULL)
		 	continue;
		 edbuf[CurrentFileNo].rm= atoi(p)%3;
		}
	fclose(fp);

	unlink(fn);
	sysinfo_path(fn, ".neTmp");
	rmdir(fn);

	return TRUE;
}

