/**********          ldap.c          ***********/

#include <sys/types.h>
#include <netinet/in.h>

#include <stdio.h>
#include <lber.h>
#include <ldap.h>
#include <syslog.h>

#include "nefu.h"

#define DEFAULT_TIMEOUT		10
/* XXX Shelltest and binary test are different */
#define LDAPTEST_BINDDN	"cn=mail500, ou=Miscellaneous Servers, o=University of Michigan, c=US"


    int
test_ldap( struct test *t, struct report *r )
{
    LDAP                        *ld;
    LDAPMessage                 *result;
    int                         msgid;
    int                         rc;
    struct timeval              tv;
    int				port;

    tv.tv_sec = DEFAULT_TIMEOUT;
    tv.tv_usec = 0;

    port = ntohs( t->t_sin.sin_port );

    if (( ld = ldap_init( t->t_machine->m_name, port )) == NULL ) {
        report_printf( r, "ldap_open: %m" );
        return( T_MAYBE_DOWN );
    }

    if (( msgid = ldap_simple_bind( ld, NULL, NULL )) < 0 ) {
        report_printf( r, "%s", ldap_err2string( ld->ld_errno ));
        ldap_unbind( ld );      /* don't need to check return */
        return( T_MAYBE_DOWN );
    }

    rc = ldap_result( ld, msgid, 0, &tv, &result );

    switch ( rc ) {
    case LDAP_RES_BIND:
        break;

    case 0:
        report_printf( r, "Transaction timed out" );
        return( T_MAYBE_DOWN );

    case -1:
    default:
        report_printf( r, "%s", ldap_err2string( ld->ld_errno ));
        ldap_unbind( ld );      /* don't need to check return */
        return( T_MAYBE_DOWN );
    }

    if ( ldap_msgfree( result ) != LDAP_RES_BIND ) {
        report_printf( r, "%s", ldap_err2string( ld->ld_errno ));
        ldap_unbind( ld );      /* don't need to check return */
        return( T_MAYBE_DOWN );
    }

    if ( ldap_unbind( ld ) < 0 ) {
        report_printf( r, "%s", ldap_err2string( ld->ld_errno ));
        return( T_MAYBE_DOWN );
    }

    return( T_UP );
}
