%{

/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

    #include <sys/time.h>
    #include <sys/types.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #include <stdio.h>
    #include <stdlib.h>
    #include <string.h>

    #include "nefu.h"

    #define	SPACECHARS	" ,\t"
    #define	BUF_BLOCK	512

    extern int			yylineno;

    struct machine		*m_list;
    struct machine		*m;

    struct rcode		*r_list;
    struct rcode		*r;

    char			*argv[ T_MAX_ARGS + 1 ];
    char			*yy_fname = NULL;
    char			*port;
    char			*e;

    int				argc;
    int				match;
    int				errs = 0;
%}

%union {
    char			*STRING;
    int				INTEGER;
    struct machine		*NEFU_MACHINE;
    struct rcode		*RCODE;
    struct test			*TEST;
    struct prototype		*PROTO;
    struct target		*TARGET;
};

%token t_IDENT
%token t_EOL
%token t_TEST
%token t_SHELL
%token t_PORT
%token t_ERROR

%type <STRING> t_IDENT t_PORT string_dup
%type <NEFU_MACHINE> machine machines dependancy
%type <RCODE> rcode_list rcodes


%start network

%%

network
	:	{
		    for ( argc = 0; argc < T_MAX_ARGS + 1; argc++ ) {
			argv[ argc ] = NULL;
		    }
		}
	    objects
		{
		    return( errs );
		}
	;

objects
	: objects object
	| object
	;

object
	: error
	| target tests
		{
		    m_list = NULL;
		}
	;

target
	: machines ':' dependancy ':' rcodes t_EOL
		{
		    m_list = $1;
		    r_list = $5;

		    for ( m = $1; m != NULL; m = m->m_next  ) {
			depend( m, $3 );
			machine_rcode_assign( m, $5 );
		    }
		}
	;

dependancy
	: machine
		{
		    $$ = $1;
		}
	
	|
		{
		    $$ = NULL;
		}
	;

machines
	: machines machine
		{
		    if ( $2 != NULL ) {
			match = 0;

			for ( m = $1; m != NULL; m = m->m_next  ) {
			    if ( strcasecmp( m->m_name, $2->m_name ) == 0 ) {
				yy_err_msg();
				fprintf( stderr,
					"%s is a target more than once\n",
					$2->m_name );
				match = 1;
				break;
			    }
			}

			if ( match == 0 ) {
			    $2->m_next = $1;
			    $$ = $2;
			} else {
			    $$ = $1;
			}

		    } else {
			$$ = $1;
		    }
		}

	| machine
		{
		    $$ = $1;
		    if ( $1 != NULL ) {
			$1->m_next = NULL;
		    }
		}
	;

machine
	: t_IDENT
		{
		    if (( $$ = machine_lookup( $1 )) == NULL ) {
			if (( e = machine_create( $1 )) != NULL ) {
			    yy_err_msg();
			    fprintf( stderr, "%s %s\n", $1, e );
			} else {
			    if (( $$ = machine_lookup( $1 )) == NULL ) {
				yy_err_msg();
				fprintf( stderr, "machine_lookup failed!\n" );
			    }
			}
		    }
		}
	;

rcodes
	: rcode_list
		{
		    $$ = $1;
		}

	|
		{
		    $$ = rcode_get( NEFU_DEFAULT_RCODE );
		    $$->r_next = NULL;
		}
	;

rcode_list
	: rcode_list t_IDENT
		{
		    $$ = rcode_get( $2 );

		    match = 0;

		    for ( r = $1; r != NULL; r = r->r_next ) {
			if ( r == $$ ) {
			    match = 1;
			    break;
			}
		    }

		    if ( match != 0 ) {
			yy_err_msg();
			fprintf( stderr, "rcode %s defined twice\n", $2 );
			$$ = $1;

		    } else {
			$$->r_next = $1;
		    }
		}

	| t_IDENT
		{
		    $$ = rcode_get( $1 );
		    $$->r_next = NULL;
		}
	;

tests
	: tests test
	| test
	;

test
	: t_TEST t_IDENT string_dup arglist t_EOL
		{
		    for ( m = m_list; m != NULL; m = m->m_next ){
			if (( e = test( m, r_list, $3, yylineno, argv ))
				!= NULL ) {
			    yy_err_msg();
			    fprintf( stderr, "%s %s\n", $3, e );
			}
		    }

		    free( $3 );
		    arg_reset();
		}
	;

arglist
	: args
	|
		{
		    argc = 0;
		}
	;

args
	: args t_IDENT
		{
		    if ( argc < T_MAX_ARGS ) {
			if (( argv[ argc ] = strdup( $2 )) == NULL ) {
			    perror( "strdup" );
			    exit( 1 );
			}
		    } else {
			/* we're dropping args here */
			yy_err_msg();
			fprintf( stderr, "arg dropped: %s\n", $2 );
		    }
		    argc++;
		}

	| t_IDENT
		{
		    argc = 0;
		    if ( argc < T_MAX_ARGS ) {
			if (( argv[ argc ] = strdup( $1 )) == NULL ) {
			    perror( "strdup" );
			    exit( 1 );
			}
		    } else {
			/* no args allowed, apparantly */
			yy_err_msg();
			fprintf( stderr, "no args allowed: %s\n", $1 );
		    }
		    argc++;
		}
	;

string_dup
	:
		{
		    /* just remember to free it when you're done with it */
		    if (( $$ = strdup( $<STRING>0 )) == NULL ) {
			perror( "strdup" );
			exit( 1 );
		    }
		}
	;

%%


    void
yy_err_msg( void )
{
    extern char			*bin_name;

    fprintf( stderr, "%s: ", bin_name );

    if ( yy_fname != NULL ) {
	fprintf( stderr, "file %s: ", yy_fname );
    }

    fprintf( stderr, "line %d: ", yylineno );

    errs++;
}


    void
yyerror( char *p )
{
    yy_err_msg();
    fprintf( stderr, "parse error \"%s\"\n", p );
}


    void
arg_reset( void )
{
    for ( argc = 0; argc < T_MAX_ARGS; argc++ ) {
	if ( argv[ argc ] != NULL ) {
	    free( argv[ argc ] );
	    argv[ argc ] = NULL;
	}
    }
    argc = 0;
}


    void
depend( struct machine *m, struct machine *dependancy )
{
    struct test		*t;
    struct test		*dep;

    /* have we been previously defined, if so, is it the same? */
    if ( m->m_defined != 0 ) {
	if ( m->m_parent != dependancy ) {
	    yy_err_msg();
	    fprintf( stderr, "can't redefine %s dependancy from line %d\n",
		    m->m_name, m->m_defined );
	}
	return;
    }

    /* can't be our own dependancy */
    if ( m == dependancy ) {
	yy_err_msg();
	fprintf( stderr, "%s can't be it's own dependancy\n", m->m_name );
	return;
    }

    m->m_defined = yylineno;
    m->m_parent = dependancy;
    t = m->m_test;

    /* insert a root node */
    if ( dependancy == NULL ) {
	t->t_peer = root_nodes;
	t->t_prev = NULL;
	root_nodes = t;
	if ( t->t_peer != NULL ) {
	    t->t_peer->t_prev = t;
	}
	return;
    }

    dep = dependancy->m_test;
    t->t_parent = dep;

    if (( dep->t_child == NULL ) ||
	    ( dep->t_child->t_machine != dep->t_machine )) {
	/* dependancy only has ping */
	t->t_peer = dep->t_child;
	dep->t_child = t;
	t->t_prev = NULL;
	if ( t->t_peer != NULL ) {
	    t->t_peer->t_prev = t;
	}

    } else {
	/* place dep on dependancy machine's last "internal" test */
	for ( dep = dep->t_child;
		(( dep->t_peer != NULL ) &&
		( dep->t_peer->t_machine == dep->t_machine ));
		dep = dep->t_peer );

	t->t_peer = dep->t_peer;
	if ( t->t_peer != NULL ) {
	    t->t_peer->t_prev = t;
	}
	t->t_prev = dep;
	dep->t_peer = t;
    }
}
