/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/**********          time.c          **********/

#include <sys/time.h>

#include <stdio.h>
#include <string.h>


    int
time_start( struct timeval *tv )
{
    return( gettimeofday( tv, NULL ));
}


    int
time_end( struct timeval *tv )
{
    struct timeval	now;

    if ( gettimeofday( &now, NULL ) == -1 ) {
	return( -1 );
    }

    if ( now.tv_usec < tv->tv_usec ) {
	now.tv_usec += 1000000;
	now.tv_sec--;
    }

    tv->tv_sec = ( now.tv_sec - tv->tv_sec );
    tv->tv_usec = ( now.tv_usec - tv->tv_usec );

    return( 0 );
}


    int
time_minus( struct timeval *total, struct timeval *minus )
{
    if ( total->tv_usec < minus->tv_usec ) {
	total->tv_usec += 1000000;
	total->tv_sec--;
    }

    total->tv_sec -= minus->tv_sec;
    total->tv_usec -= minus->tv_usec;

    if (( total->tv_sec < 0 ) || ( total->tv_usec < 0 )) {
	return( -1 );
    }
    return( 0 );
}

    char *
time_down( struct timeval *tv )
{
    static char		buf[ 13 ];
    int			day, hour, min, sec;

    day = ( tv->tv_sec / 86400 );
    hour = (( tv->tv_sec % 86400 ) / 3600 );
    min = (( tv->tv_sec % 3600 ) / 60 );
    sec = ( tv->tv_sec % 60 );

    if ( day > 0 ) {
	if ( day > 99 ) {
	    day = 99;
	}
	sprintf( buf, "%d+%02d:%02d:%02d", day, hour, min, sec );
    } else {
	sprintf( buf, "%02d:%02d:%02d", hour, min, sec );
    }
    return( buf );
}
