%{

/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include "y.tab.h"

int		cont = 0;
int		line = 0;
extern char	*yy_fname;

%}

Word		[~!/A-Za-z0-9._@-]+
Integer		[0-9]+
PortTest	{Word}":"{Integer}


%%

\\$		{ cont = 1; }

[#][^\\\n]*	{ ; }

{Word}		{
		    line = 1;
		    yylval.STRING = yytext;
		    return( t_IDENT );
		}

{PortTest}	{
		    line = 1;
		    yylval.STRING = yytext;
		    return( t_IDENT );
		}

\n		{   
		    if ( !cont ) {
			if ( line ) {
			    line = 0;
			    return( t_EOL );
			}
		    }
	        }

^[^\t]		{
		    cont = 0;
		}

^[\t ]+		{
		    if ( !cont ) {
			return( t_TEST );
		    } else {
			cont = 0;
		    }
		}

[\t ]		;

[:]		{ return( yytext[ 0 ]); }

.		{ return( t_ERROR ); }

%%


    int
yy_infile( char *infile )
{
    if (( yyin = fopen( infile, "r" )) == NULL ) {
	return( 1 );
    }

    yy_fname = infile;

    return( 0 );
}
