/**********	tester.c	***********/

#include <sys/types.h>
#include <netinet/in.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <syslog.h>
#include <math.h>

#include "nefu.h"

    int
main( int argc, char *argv[] )
{
    struct machine		*m;
    struct test			*t;
    struct report		*r;
    int				result;
    char			*e;

    machine_stab = NULL;
    root_nodes = NULL;

    if ( argc < 3 ) {
	printf( "Usage:\t%s machine test [ args ... ]\n", argv[ 0 ] );
	fflush( stdout );
	exit( 1 );
    }

    /* create machine */

    if (( e = machine_create( argv[ 1 ] )) != NULL ) {
	fprintf( stderr, "%s: %s %s\n", argv[ 0 ], argv[ 1 ], e );
	exit( 1 );
    }

    if (( m = machine_lookup( argv[ 1 ] )) == NULL ) {
	fprintf( stderr, "%s: %s machine_lookup error\n", argv[ 0 ], argv[ 1 ]);
	exit( 1 );
    }

    /* create test */

    if (( e = test( m, NULL, argv[ 2 ], 1, &argv[ 3 ] )) != NULL ) {
	fprintf( stderr, "%s: %s %s\n", argv[ 0 ], argv[ 2 ], e );
	exit( 1 );
    }

    if ( strcasecmp( argv[ 2 ], T_DEFAULT ) == 0 ) {
	fprintf( stderr, "%s: test %s not allowed: no raw socket\n", argv[ 0 ],
		argv[ 2 ]);
	exit( 1 );
    }

    t = m->m_test->t_child;
    
    /* create report handle */

    if (( r = report_create()) == NULL ) {
	fprintf( stderr, "report create: failed\n" );
	exit( 1 );
    }

    /* openlog, just like nefu */

    openlog( "nefutest", LOG_NDELAY, LOG_LOCAL0 );

    /* execute test */

    if (( result = ((*t->t_test)( t, r ))) != T_UP ) {
	if (( result != T_DOWN ) && ( result != T_MAYBE_DOWN )) {
	    fprintf( stderr, "%s: invalid test return\n", argv[ 0 ]);
	} else {
	    printf( "%s: test failed: %s\n", argv[ 0 ], r->r_buf );
	}

    } else {
	printf( "%s: test succeeded\n", argv[ 0 ]);
    }

    return( 0 );
}
