/**********          nefu defs          **********/

#define	HTML_DIR		"public_html"

#define	T_UP			0x0000
#define	T_DOWN			0x0001
#define	T_MAYBE_DOWN		0x0010
#define T_DOWN_MASK		0x0011
#define T_NO_DNS		0x0100

#define T_DEFAULT		"ping"
#define T_SHELL			"!"
#define	T_IMPLIED		0
#define T_DEFINED		1

#define	R_MESG_LEN		1024
#define R_BOUNCE		666

#define	T_MAX_ARGS		10

#define	DEFAULT_DNS_PASSES	10
#define	DEFAULT_PASS_TIME	60
#define	DEFAULT_TEST_TIME	0
#define	ERROR_SYSLOG		0
#define	ERROR_STDERR		1
#define	MACHINE_NO_DNS		1
#define	MACHINE_MULT_IPS	2
#define	DEFAULT_UNAME		"nefu"
#define	HTML_PLAN		"index.html"
#define	HTML_DEPMAP_ROOT	"root.html"
#define	HTML_MACHINES		"machines.html"
#define	HTML_GROUPS		"groups.html"
#define	HTML_DEPMAP_DIR		"dependencies"
#define	HTML_HISTORY_DIR	"history"
#define	HTML_RCODE_DIR		"groups"
#define	HTML_HEADER		"header.html"
#define	HTML_FOOTER		"footer.html"
#define	HTML_LOGO		"small_nefu_logo.png"
#define	NEFU_SCRIPT_DIR		"shelltests"
#define	NEFU_DEFAULT_RCODE	"nefu"
#define	NEFU_LAST_EVENT_FILE	"last_event"


struct schedule {
    struct test		*s_head;
    struct test		*s_tail;
    struct test		*s_test;
    u_long		s_pass;
    int			s_event;
    struct timeval	s_published;
    struct timeval	s_tv_pass;
    struct timeval	s_tv_pass_minimum;
    struct timeval	s_tv_service_minimum;
};

struct machine {
    char		*m_name;	/* name */
    struct test		*m_test;	/* base test */
    struct machine	*m_parent;	/* NULL if machine is a root node */
    struct machine	*m_next;	/* used in dep tree construction */
    struct machine	*m_next_dns;	/* list machines without DNS */
    struct stab_entry	*m_rcodes;	/* all rcodes for this machine */
    struct sockaddr_in	m_sin;
    char		*m_html_name;	/* path to it's html file from root */
    int			m_defined;	/* yacc, machine defined */
    int			m_ping;		/* yacc, ping explicitly defined */
    int			m_dns_status;	/* 0 if machine is found */
};

struct report {
    char		*r_buf;
    char		*r_cur;
    char		*r_end;
    int			r_len;
    struct report	*r_next;
};

struct rcode {
    char		*r_code;
    char		*r_html_name;
    struct stab_entry	*r_machines;
    struct rcode	*r_next;		/* yacc */
};

struct test {
    char		*t_name;
    char		*t_full_name;
    char		*t_rlist;
    struct stab_entry	*t_rcodes;
    struct machine	*t_machine;
    char		*t_argv[ T_MAX_ARGS + 1 ];
    int			t_argc;
    int			t_line;

    /* dep tree */
    struct test		*t_parent;
    struct test		*t_peer;
    struct test		*t_child;
    struct test		*t_prev;

    /* ordering */
    int			t_flags;
    int			t_router;
    struct test		*t_loop;

    /* needed for monitor/scheduler */
    int			t_status;
    u_long		t_tested;
    struct test		*t_route_next;
    struct test		*t_route_prev;
    int			(*t_test)(struct test *, struct report *);

    /* inet info */
    struct sockaddr_in	t_sin;

    /* needed for reporting info */
    struct report	*t_report;
    struct timeval	t_time_down;
    u_long		t_pass_down;
};

struct log_facility {
    char		*log_name;
    int			log_facility;
};

/***   GLOBAL VARS ***/

int				nodes_total;
int				nodes_leaf;
int				nefu_raw_socket;
struct machine			*machines_no_dns;
int				dns_pass;
int				dns_event;
mode_t				nefu_cmask;
char				*nefu_uname;
char				*nefu_localdomain;
char				*nefu_html_dir;
int				nefu_html_reload;
int				nefu_html_history;
int				nefu_redundant_paging;
char				*nefu_user_dir;
struct report			*reports;
struct stab_entry		*machine_stab;
struct stab_entry		*rcode_stab;
struct test			*root_nodes;
char				*nefu_version;
char				*nefu_sendmail;


/*** FUNCTIONS ***/

/* time.c */
int		time_start( struct timeval * );
int		time_end( struct timeval * );
int		time_minus( struct timeval *, struct timeval * );
char		*time_down( struct timeval * );


/* depmap.c */
void		depmap_stdout( void );
void		depmap_html( void );


/* publish.c */
void		html_init( struct schedule * );
int		html_header( int, FILE *, int, char * );
int		html_footer( int, FILE *, int );
int		publish( struct schedule * );
int		history_update( struct schedule * );


/* monitor.c */
void		monitor_network( struct schedule * ); 


/* order.c */
int		order_tree( void );


/* main.c */
int		directory( char * );


/* test.c */
void		test_rcode( struct test *, struct rcode * );
char		*test( struct machine *, struct rcode *, char *name, int line,
			char ** );


/* schedule.c */
void		schedule( struct schedule * );
int		pop_route( struct schedule * );


/* report.c */
/* if decide to do buffer allocation dynamically, need an int val for size */
#ifdef __STDC__
#define PTYPE(PROTO)	PROTO
#else /* __STDC__ */
#define PTYPE(PROTO)	()
#endif /* __STDC__ */

#define report_compare( r1, r2 ) (strcmp( (r1)->r_buf, (r2)->r_buf ))
struct report	*report_create PTYPE(( void ));
int		report_printf PTYPE(( struct report*, char*, ... ));
int		report PTYPE(( int, struct test *, struct report *,
			struct report * ));
void		report_free PTYPE(( struct report *r ));


/* rcode.c */
struct rcode	*rcode_get( char * );
struct rcode	*rcode_create( char * );
void		rcode_html_pages( void );


/* machine.c */
struct machine	*machine_lookup( char * );
char		*machine_create( char * );
int		machine_errors( void );
void		machine_rcode( struct machine *, struct rcode * );
void		machine_rcode_assign( struct machine *, struct rcode * );
