/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/**********         order.c         **********/

#include <sys/time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <stdio.h>
#include <strings.h>
#include <string.h>

#include "nefu.h"



    /* tabulate the number of levels beneath a given test */

    int
router_levels( struct test *t )
{
    int			peer_levels = 0;

    if ( t != NULL ) {
	peer_levels = router_levels( t->t_peer );

	if ( strcmp( t->t_name, T_DEFAULT ) == 0 ) {
	    t->t_router = router_levels( t->t_child );
	    if ( peer_levels > t->t_router + 1 ) {
		return( peer_levels );
	    }
	    return( t->t_router + 1 );

	} else {
	    t->t_router = 0;
	}
    }

    return( peer_levels );
}


    /* sort each level of the graph by child levels, in ascending order */

    struct test *
sort_levels( struct test *t_node )
{
    struct test		*test, *prev;
    int			x;
    int			nodes = 0;

    if ( t_node == NULL ) {
	return( NULL );
    }

    for ( test = t_node; test != NULL; test = test->t_peer ) {
	test->t_child = sort_levels( test->t_child );
	nodes++;
    }

    for ( x = 0; x < nodes; x++ ) {
	for ( test = t_node; test != NULL; test = test->t_peer ) {
	    if ( test->t_peer == NULL ) {
		break;
	    }

	    /* swapper */
	    if ( test->t_router > test->t_peer->t_router ) {
		if ( t_node == test ) {
		    t_node = test->t_peer;
		}
		prev = test->t_peer;

		test->t_peer = prev->t_peer;
		prev->t_prev = test->t_prev;
		test->t_prev = prev;
		prev->t_peer = test;
		if ( prev->t_prev != NULL ) {
		    prev->t_prev->t_peer = prev;
		}
		if ( test->t_peer != NULL ) {
		    test->t_peer->t_prev = test;
		}
	    }
	}
    }
    return( t_node );
}


    /* how many nodes do we have?  how many are leaf nodes? */

    /* note that global variables are VERY BAD. */

    void
count_nodes( struct test *t )
{
    if ( t != NULL ) {
	nodes_total++;
	if ( t->t_child == NULL ) {
	    nodes_leaf++;
	}
	count_nodes( t->t_child );
	count_nodes( t->t_peer );
    }
}


    /* init the graph */
    
    int
order_tree()
{
    int			errs;

    /* do error checking for obvious cases */

    if (( errs = machine_errors()) != 0 ) {
	fprintf( stderr, "order_tree: %d errors in map detected\n", errs );
	return( -1 );
    }

    if ( root_nodes == NULL ) {
	fprintf( stderr, "order_tree:\troot_nodes are NULL!\n" );
	return( -1 );
    }

    router_levels( root_nodes );

    root_nodes = sort_levels( root_nodes );

    /* statistical purposes only */

    nodes_leaf = 0;
    nodes_total = 0;

    count_nodes( root_nodes );

    return( 0 );
}
