/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/**********	rcode.c	**********/

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#include "nefu.h"
#include "ll.h"


    struct rcode *
rcode_get( char *rname )
{
    struct rcode	*r;
    char		html[ MAXPATHLEN ];

    if (( r = (struct rcode*)ll_lookup( rcode_stab, rname )) == NULL ) {
	if (( r = (struct rcode*)malloc( sizeof( struct rcode ))) == NULL ) {
	    perror( "malloc" );
	    exit( 1 );
	}
	memset( r, 0, sizeof( struct rcode ));

	if (( r->r_code = strdup( rname )) == NULL ) {
	    perror( "strdup" );
	    exit( 1 );
	}

	sprintf( html, "%s/%s.html", HTML_RCODE_DIR, r->r_code );

	if (( r->r_html_name = strdup( html )) == NULL ) {
	    perror( "malloc" );
	    exit( 1 );
	}

	ll_insert( &rcode_stab, r->r_code, r );
    }

    return( r );
}


    void
rcode_html_index( void )
{
    int			fd;
    FILE		*f;
    struct stab_entry	*st;
    struct rcode	*r;
    char		html[ MAXPATHLEN ];

    /* index page */
    sprintf( html, "%s/%s", nefu_html_dir, HTML_GROUPS );

    if (( fd = creat( html, 0666 )) < 0 ) {
	fprintf( stderr, "open: %s: ", html );
	perror( NULL );
	exit( 1 );
    }

    if (( f = fdopen( fd, "w" )) == NULL ) {
	perror( "fdopen" );
	exit( 1 );
    }

    /* print header */
    if ( html_header( ERROR_STDERR, f, 0, "groups" ) != 0 ) {
	exit( 1 );
    }

    for ( st = rcode_stab; st != NULL; st = st->st_next ) {
	r = (struct rcode *)st->st_data;

	/* link to the rcode's page */
	fprintf( f, "<A HREF=\"%s\">%s</A><BR>\n", r->r_html_name,
		r->r_code ); }

    /* print footer */
    if ( html_footer( ERROR_STDERR, f, 0 ) != 0 ) {
	exit( 1 );
    }

    /* done with rcode file */
    if ( fclose( f ) != 0 ) {
	perror( "fclose" );
	exit( 1 );
    }
}


    void
rcode_html( void *data )
{
    struct rcode	*r;
    char		html[ MAXPATHLEN ];
    FILE		*f;
    struct stab_entry	*st;
    struct machine	*m;
    int			fd;

    r = (struct rcode*)data;

    /* page */
    sprintf( html, "%s/%s/%s.html", nefu_html_dir, HTML_RCODE_DIR, r->r_code );

    if (( fd = creat( html, 0666 )) < 0 ) {
	fprintf( stderr, "open: %s: ", html );
	perror( NULL );
	exit( 1 );
    }

    if (( f = fdopen( fd, "w" )) == NULL ) {
	perror( "fdopen" );
	exit( 1 );
    }

    /* print header */
    if ( html_header( ERROR_STDERR, f, 1, "groups" ) != 0 ) {
	exit( 1 );
    }

    for ( st = r->r_machines; st != NULL; st = st->st_next ) {
	m = (struct machine*)st->st_data;

	fprintf( f, "<A HREF=\"../%s\">%s</A><BR>\n", m->m_html_name,
		m->m_name );
    }

    /* print footer */
    if ( html_footer( ERROR_STDERR, f, 1 ) != 0 ) {
	exit( 1 );
    }

    /* done with rcode file */
    if ( fclose( f ) != 0 ) {
	perror( "fclose" );
	exit( 1 );
    }
}


    void
rcode_html_pages( void )
{
    char		name[ MAXPATHLEN ];

    if ( nefu_html_dir == NULL ) {
	return;
    }

    rcode_html_index();

    sprintf( name, "%s/%s", nefu_html_dir, HTML_RCODE_DIR );
    if ( directory( name ) != 0 ) {
	exit( 1 );
    }

    ll_walk( rcode_stab, rcode_html );
}
