/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.launching;

import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.builder.ExternalEditorInput;
import net.sourceforge.phpeclipse.builder.FileStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PHPSourceLocator
implements IPersistableSourceLocator,
ISourcePresentation {
    private String absoluteWorkingDirectory;
    private Map pathMap = null;
    private boolean remoteDebug;
    private IPath remoteSourcePath;
    private String projectName;

    public String getAbsoluteWorkingDirectory() {
        return this.absoluteWorkingDirectory;
    }

    public String getMemento() throws CoreException {
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.absoluteWorkingDirectory = configuration.getAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", "");
        this.remoteDebug = configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG", false);
        this.pathMap = configuration.getAttribute("net.sourceforge.phpeclipse.launching.FILE_MAP", null);
        this.projectName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", "");
        this.remoteSourcePath = Platform.getOS().equals("win32") ? new Path(configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", "").toLowerCase()) : new Path(configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", ""));
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        String fileName = ((PHPStackFrame)stackFrame).getFileName();
        if (this.remoteDebug) {
            Path remotePath;
            String local;
            Iterator iterator;
            Path path = new Path(fileName);
            if (!this.remoteSourcePath.isEmpty()) {
                if (this.remoteSourcePath.isPrefixOf((IPath)path)) {
                    path = path.removeFirstSegments(this.remoteSourcePath.matchingFirstSegments((IPath)path));
                    path.toString();
                    IPath projectPath = PHPeclipsePlugin.getWorkspace().getRoot().getProject(this.projectName).getLocation();
                    return projectPath.append((IPath)path).toOSString();
                }
            } else {
                if (this.pathMap == null) {
                    return fileName;
                }
                iterator = this.pathMap.keySet().iterator();
                while (iterator.hasNext()) {
                    local = (String)iterator.next();
                    remotePath = new Path((String)this.pathMap.get(local));
                    if (!remotePath.isPrefixOf((IPath)path)) continue;
                    path = path.removeFirstSegments(remotePath.matchingFirstSegments((IPath)path));
                    Path localPath = new Path(local);
                    path = localPath.append((IPath)path);
                    IPath projectPath = PHPeclipsePlugin.getWorkspace().getRoot().getProject(this.projectName).getLocation();
                    return projectPath.append((IPath)path).toOSString();
                }
            }
            if (this.pathMap == null) {
                return fileName;
            }
            iterator = this.pathMap.keySet().iterator();
            while (iterator.hasNext()) {
                local = (String)iterator.next();
                remotePath = new Path((String)this.pathMap.get(local));
                if (!remotePath.isPrefixOf((IPath)path)) continue;
                path = path.removeFirstSegments(remotePath.matchingFirstSegments((IPath)path));
                Path localPath = new Path(local);
                return localPath.append((IPath)path).toOSString();
            }
            return fileName;
        }
        return fileName;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor((String)element).getId();
    }

    public IEditorInput getEditorInput(Object element) {
        String filename = (String)element;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getWorkbenchWindows()[0];
        IWorkbenchPage page = window.getActivePage();
        Path path = new Path(filename);
        IFile eclipseFile = PHPeclipsePlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (eclipseFile == null || !eclipseFile.exists()) {
            if (page == null) {
                PHPeclipsePlugin.log((int)1, (String)("Could not find file \"" + element + "\"."));
                return null;
            }
            FileStorage storage = new FileStorage((IPath)path);
            storage.setReadOnly();
            return new ExternalEditorInput((IStorage)storage);
        }
        return new FileEditorInput(eclipseFile);
    }
}

