/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.httpquery.config;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.httpquery.config.Configuration;
import net.sourceforge.phpdt.httpquery.config.ConfigurationWorkingCopy;
import net.sourceforge.phpdt.httpquery.config.IConfiguration;
import net.sourceforge.phpdt.httpquery.config.IConfigurationListener;
import net.sourceforge.phpdt.httpquery.config.IConfigurationWorkingCopy;
import net.sourceforge.phpdt.httpquery.config.IMemento;
import net.sourceforge.phpdt.httpquery.config.XMLMemento;
import net.sourceforge.phpdt.phphelp.PHPHelpPlugin;
import org.eclipse.core.runtime.Preferences;

public class ConfigurationManager {
    private static final int ADD = 0;
    private static final int CHANGE = 1;
    private static final int REMOVE = 2;
    protected List configurations;
    protected Map threads = new HashMap();
    protected List configurationListeners = new ArrayList();
    private Preferences.IPropertyChangeListener pcl;
    protected boolean ignorePreferenceChanges = false;
    protected static ConfigurationManager instance;

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    private ConfigurationManager() {
        this.loadConfigurations();
        this.pcl = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (ConfigurationManager.this.ignorePreferenceChanges) {
                    return;
                }
                String property = event.getProperty();
                if (property.equals("__configurations1")) {
                    ConfigurationManager.this.loadConfigurations();
                }
            }
        };
        PHPHelpPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.pcl);
    }

    protected void dispose() {
        PHPHelpPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.pcl);
    }

    public IConfigurationWorkingCopy createConfiguration() {
        return new ConfigurationWorkingCopy();
    }

    public List getConfigurations() {
        return new ArrayList(this.configurations);
    }

    protected void addConfiguration(IConfiguration configuration) {
        if (!this.configurations.contains(configuration)) {
            this.configurations.add(configuration);
        }
        this.fireConfigurationEvent(configuration, 0);
        this.saveConfigurations();
    }

    protected boolean isActive(IConfiguration configuration) {
        return this.threads.get(configuration) != null;
    }

    protected void removeConfiguration(IConfiguration configuration) {
        this.configurations.remove(configuration);
        this.fireConfigurationEvent(configuration, 2);
        this.saveConfigurations();
    }

    protected void configurationChanged(IConfiguration configuration) {
        this.fireConfigurationEvent(configuration, 1);
        this.saveConfigurations();
    }

    public void addConfigurationListener(IConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public void removeConfigurationListener(IConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    protected void fireConfigurationEvent(IConfiguration configuration, int type) {
        Object[] obj = this.configurationListeners.toArray();
        int size = obj.length;
        int i = 0;
        while (i < size) {
            IConfigurationListener listener = (IConfigurationListener)obj[i];
            if (type == 0) {
                listener.configurationAdded(configuration);
            } else if (type == 1) {
                listener.configurationChanged(configuration);
            } else if (type == 2) {
                listener.configurationRemoved(configuration);
            }
            ++i;
        }
    }

    protected void loadConfigurations() {
        this.configurations = new ArrayList();
        Preferences prefs = PHPHelpPlugin.getDefault().getPluginPreferences();
        String xmlString = prefs.getString("__configurations1");
        if (xmlString != null && xmlString.length() > 0) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
                IMemento memento = XMLMemento.loadMemento(in);
                IMemento[] children = memento.getChildren("config");
                if (children != null) {
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        ConfigurationWorkingCopy configuration = new ConfigurationWorkingCopy();
                        configuration.load(children[i]);
                        this.configurations.add(configuration);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void saveConfigurations() {
        try {
            this.ignorePreferenceChanges = true;
            XMLMemento memento = XMLMemento.createWriteRoot("__configurations1");
            Iterator iterator = this.configurations.iterator();
            while (iterator.hasNext()) {
                Configuration monitor = (Configuration)iterator.next();
                IMemento child = memento.createChild("config");
                monitor.save(child);
            }
            String xmlString = memento.saveToString();
            Preferences prefs = PHPHelpPlugin.getDefault().getPluginPreferences();
            prefs.setValue("__configurations1", xmlString);
            PHPHelpPlugin.getDefault().savePluginPreferences();
        }
        catch (Exception exception) {}
        this.ignorePreferenceChanges = false;
    }
}

