/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.httpquery.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.phpdt.httpquery.config.IMemento;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    public XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static XMLMemento createReadRoot(Reader reader) {
        block11: {
            XMLMemento xMLMemento;
            Document document = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    document = parser.parse(new InputSource(reader));
                    Node node = document.getFirstChild();
                    if (!(node instanceof Element)) break block11;
                    xMLMemento = new XMLMemento(document, (Element)node);
                    Object var5_6 = null;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    break block11;
                }
                catch (IOException iOException) {
                    break block11;
                }
                catch (SAXException sAXException) {
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            reader.close();
            return xMLMemento;
        }
        Object var5_8 = null;
        try {}
        catch (Exception exception) {
            return null;
        }
        reader.close();
        return null;
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                return new XMLMemento(this.factory, element2);
            }
            ++nX;
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                list.add(element2);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    public byte[] getContents() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return out.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getId() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    public String getName() {
        return this.element.getNodeName();
    }

    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public List getNames() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            Node node = map.item(i);
            String name = node.getNodeName();
            list.add(name);
            ++i;
        }
        return list;
    }

    public static IMemento loadMemento(InputStream in) {
        return XMLMemento.createReadRoot(new InputStreamReader(in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMemento loadCorruptMemento(InputStream in) {
        block11: {
            XMLMemento xMLMemento;
            Document document = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    document = parser.parse(in);
                    Node node = document.getFirstChild();
                    if (!(node instanceof Element)) break block11;
                    xMLMemento = new XMLMemento(document, (Element)node);
                    Object var5_6 = null;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    break block11;
                }
                catch (IOException iOException) {
                    break block11;
                }
                catch (SAXException sAXException) {
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            in.close();
            return xMLMemento;
        }
        Object var5_8 = null;
        try {}
        catch (Exception exception) {
            return null;
        }
        in.close();
        return null;
    }

    public static IMemento loadMemento(String filename) throws IOException {
        return XMLMemento.createReadRoot(new FileReader(filename));
    }

    public static IMemento loadMemento(URL url) throws IOException {
        return XMLMemento.createReadRoot(new InputStreamReader(url.openStream()));
    }

    private void putElement(Element element2) {
        NamedNodeMap nodeMap = element2.getAttributes();
        int size = nodeMap.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
            ++i;
        }
        NodeList nodes = element2.getChildNodes();
        size = nodes.getLength();
        int i2 = 0;
        while (i2 < size) {
            Node node = nodes.item(i2);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node);
            }
            ++i2;
        }
    }

    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    public void putMemento(IMemento memento) {
        XMLMemento xmlMemento = (XMLMemento)memento;
        this.putElement(xmlMemento.element);
    }

    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void save(Writer writer) throws IOException {
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void save(OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void saveToFile(String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 59->63)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String saveToString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return out.toString("UTF-8");
    }

    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        if ("true".equalsIgnoreCase(strValue)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public void putBoolean(String key, boolean value) {
        this.element.setAttribute(key, value ? "true" : "false");
    }
}

