/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.httpquery.preferences;

import java.util.ArrayList;
import net.sourceforge.phpdt.httpquery.config.IConfigurationWorkingCopy;
import net.sourceforge.phpdt.phphelp.PHPHelpPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigurationDialog
extends Dialog {
    protected IConfigurationWorkingCopy fConfiguration;
    protected boolean isEdit;
    private Button okButton;
    private Text fName;
    private Text fUrl;

    public ConfigurationDialog(Shell parentShell, IConfigurationWorkingCopy configuration) {
        super(parentShell);
        this.fConfiguration = configuration;
        this.isEdit = true;
    }

    public ConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.fConfiguration = PHPHelpPlugin.createConfiguration();
        this.isEdit = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(PHPHelpPlugin.getResource("%editConfig"));
        } else {
            shell.setText(PHPHelpPlugin.getResource("%newConfig"));
        }
    }

    protected Label createLabel(Composite comp, String txt) {
        Label label = new Label(comp, 0);
        label.setText(txt);
        label.setLayoutData((Object)new GridData(34));
        return label;
    }

    protected Text createPassword(Composite comp, String txt, final StringModifyListener listener) {
        final Text text = new Text(comp, 0x400800);
        if (txt != null) {
            text.setText(txt);
        }
        GridData data = new GridData(770);
        data.widthHint = 150;
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(text.getText());
                }
            });
        }
        return text;
    }

    protected Text createText(Composite comp, String txt, final StringModifyListener listener) {
        final Text text = new Text(comp, 2048);
        if (txt != null) {
            text.setText(txt);
        }
        GridData data = new GridData(770);
        data.widthHint = 150;
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(text.getText());
                }
            });
        }
        return text;
    }

    protected Combo createTypeCombo(Composite comp, final ArrayList types, String sel, final TypeModifyListener listener) {
        final Combo combo = new Combo(comp, 12);
        int size = types.size();
        String[] items = new String[size];
        int index = -1;
        int i = 0;
        while (i < size) {
            items[i] = (String)types.get(i);
            if (items[i].equals(sel)) {
                index = i;
            }
            ++i;
        }
        combo.setItems(items);
        if (index >= 0) {
            combo.select(index);
        }
        GridData data = new GridData(258);
        data.widthHint = 150;
        combo.setLayoutData((Object)data);
        if (listener != null) {
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    listener.valueChanged((String)types.get(combo.getSelectionIndex()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        return combo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.createLabel(composite, PHPHelpPlugin.getResource("%name"));
        this.fName = this.createText(composite, String.valueOf(this.fConfiguration.getName()), new StringModifyListener(){

            public void valueChanged(String name) {
                ConfigurationDialog.this.fConfiguration.setName(name);
                ConfigurationDialog.this.validateFields();
            }
        });
        Group group = new Group(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(PHPHelpPlugin.getResource("%configGroup"));
        this.createLabel((Composite)group, PHPHelpPlugin.getResource("%url"));
        this.fUrl = this.createText((Composite)group, this.fConfiguration.getURL(), new StringModifyListener(){

            public void valueChanged(String s) {
                ConfigurationDialog.this.fConfiguration.setURL(s);
                ConfigurationDialog.this.validateFields();
            }
        });
        this.createLabel((Composite)group, PHPHelpPlugin.getResource("%parseType"));
        this.createTypeCombo((Composite)group, PHPHelpPlugin.getTypes(), this.fConfiguration.getType(), new TypeModifyListener(){

            public void valueChanged(String fType) {
                ConfigurationDialog.this.fConfiguration.setType(fType);
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.fConfiguration.save();
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonControl = super.createButtonBar(parent);
        this.validateFields();
        return buttonControl;
    }

    private void setOKButtonEnabled(boolean curIsEnabled) {
        if (this.okButton == null) {
            this.okButton = this.getButton(0);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(curIsEnabled);
        }
    }

    protected void validateFields() {
        boolean result = true;
        this.setOKButtonEnabled(result);
    }

    static interface StringModifyListener {
        public void valueChanged(String var1);
    }

    static interface BooleanModifyListener {
        public void valueChanged(boolean var1);
    }

    static interface TypeModifyListener {
        public void valueChanged(String var1);
    }
}

