/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.launcher;

import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.util.PHPFileSelector;
import net.sourceforge.phpdt.internal.ui.util.PHPProjectSelector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class PHPEntryPointTab
extends AbstractLaunchConfigurationTab {
    protected String originalFileName;
    protected String originalProjectName;
    protected PHPProjectSelector projectSelector;
    protected PHPFileSelector fileSelector;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        new Label(composite, 0).setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.projectLabel"));
        this.projectSelector = new PHPProjectSelector(composite);
        this.projectSelector.setBrowseDialogMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.projectSelectorMessage"));
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0).setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.fileLabel"));
        this.fileSelector = new PHPFileSelector(composite, this.projectSelector);
        this.fileSelector.setBrowseDialogMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.fileSelectorMessage"));
        this.fileSelector.setLayoutData((Object)new GridData(768));
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected IResource getContext() {
        IWorkbenchPage page = PHPDebugUiPlugin.getActivePage();
        if (page != null) {
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IResource) {
                return (IResource)obj;
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IResource file;
                IEditorInput input = part.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IResource)input.getAdapter((Class)clazz)) != null) {
                    return file;
                }
            }
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResource file = this.getContext();
        if (file != null) {
            configuration.setAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", file.getProject().getName());
            configuration.setAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", file.getProjectRelativePath().toOSString());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.originalProjectName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", "");
            this.originalFileName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", "");
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.projectSelector.setSelectionText(this.originalProjectName);
        if (!"".equals(this.originalFileName)) {
            this.fileSelector.setSelectionText(new Path(this.originalFileName).toOSString());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", this.projectSelector.getSelectionText());
        IFile file = this.fileSelector.getSelection();
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", file == null ? "" : file.getProjectRelativePath().toString());
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.name");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String projectName = launchConfig.getAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", "");
            if (projectName.length() == 0) {
                this.setErrorMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.invalidProjectSelectionMessage"));
                return false;
            }
            String fileName = launchConfig.getAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", "");
            if (fileName.length() == 0) {
                this.setErrorMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEntryPoint.invalidFileSelectionMessage"));
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable t) {
        PHPDebugUiPlugin.log(t);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public Image getImage() {
        return PHPUiImages.get((String)"net.sourceforge.phpdt.internal.ui.php_page.gif");
    }
}

