/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import net.sourceforge.phpdt.internal.debug.ui.preferences.EditPathMapDialog;
import net.sourceforge.phpdt.internal.debug.ui.preferences.PHPInterpreterPreferencePage;
import net.sourceforge.phpdt.internal.launching.PHPInterpreter;
import net.sourceforge.phpdt.internal.launching.PHPRuntime;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PHPEnvironmentTab
extends AbstractLaunchConfigurationTab {
    protected ListViewer loadPathListViewer;
    protected List installedInterpretersWorkingCopy;
    protected Combo interpreterCombo;
    protected Button fRemoteDebugCheckBox;
    protected Button fRemoteDebugTranslate;
    protected Button fOpenDBGSessionInBrowserCheckBox;
    protected Button fPathMapRemoveButton;
    protected Button fPathMapAddButton;
    protected Button fPathMapEditButton;
    protected Text fRemoteSourcePath;
    protected Table fRemoteDebugPathMapTable;
    protected TabFolder tabFolder;
    private static final String EMPTY_STRING = "";
    private RemoteDebugTabListener fListener = new RemoteDebugTabListener();
    private static final boolean DEFAULT_REMOTE_DEBUG = false;
    private static final boolean DEFAULT_REMOTE_DEBUG_TRANSLATE = false;
    private static final boolean DEFAULT_OPEN_DBGSESSION_IN_BROWSER = true;
    static String[] columnTitles = new String[]{PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMapTableTitle.local"), PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMapTableTitle.remote")};

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        this.tabFolder = new TabFolder(composite, 0);
        GridData gridData = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gridData);
        this.addInterpreterTab(this.tabFolder);
        this.addRemoteDebugTab(this.tabFolder);
    }

    protected void addRemoteDebugTab(TabFolder tabFolder) {
        TabItem remoteDebugTab = new TabItem(tabFolder, 0, 0);
        remoteDebugTab.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.label"));
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout());
        remoteDebugTab.setControl((Control)comp);
        this.fRemoteDebugCheckBox = new Button(comp, 32);
        this.fRemoteDebugCheckBox.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.RemoteCheckBox.label"));
        this.fRemoteDebugCheckBox.setLayoutData((Object)new GridData(32));
        this.fRemoteDebugCheckBox.addSelectionListener((SelectionListener)this.fListener);
        this.fRemoteDebugTranslate = new Button(comp, 32);
        this.fRemoteDebugTranslate.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.RemoteTranslate.label"));
        this.fRemoteDebugTranslate.setLayoutData((Object)new GridData(32));
        this.fRemoteDebugTranslate.addSelectionListener((SelectionListener)this.fListener);
        this.fOpenDBGSessionInBrowserCheckBox = new Button(comp, 32);
        this.fOpenDBGSessionInBrowserCheckBox.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.OpenDBGSessionInBrowserCheckBox.label"));
        this.fOpenDBGSessionInBrowserCheckBox.setLayoutData((Object)new GridData(32));
        this.fOpenDBGSessionInBrowserCheckBox.addSelectionListener((SelectionListener)this.fListener);
        Label label = new Label(comp, 0);
        label.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.RemoteSourcePath.label"));
        this.fRemoteSourcePath = new Text(comp, 2052);
        GridData gd = new GridData(768);
        this.fRemoteSourcePath.setLayoutData((Object)gd);
        this.fRemoteSourcePath.addModifyListener((ModifyListener)this.fListener);
        this.createVerticalSpacer(comp, 1);
        Composite pathMapComp = new Composite(comp, 0);
        gd = new GridData(1808);
        pathMapComp.setLayoutData((Object)gd);
        GridLayout parametersLayout = new GridLayout();
        parametersLayout.numColumns = 2;
        parametersLayout.marginHeight = 0;
        parametersLayout.marginWidth = 0;
        pathMapComp.setLayout((Layout)parametersLayout);
        Label pathMapLabel = new Label(pathMapComp, 0);
        pathMapLabel.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        pathMapLabel.setLayoutData((Object)gd);
        this.fRemoteDebugPathMapTable = new Table(pathMapComp, 2050);
        TableLayout tableLayout = new TableLayout();
        this.fRemoteDebugPathMapTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        this.fRemoteDebugPathMapTable.setLayoutData((Object)gd);
        TableColumn column1 = new TableColumn(this.fRemoteDebugPathMapTable, 0);
        column1.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.Table.Title.local"));
        TableColumn column2 = new TableColumn(this.fRemoteDebugPathMapTable, 0);
        column2.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.Table.Title.remote"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.fRemoteDebugPathMapTable.setHeaderVisible(true);
        this.fRemoteDebugPathMapTable.setLinesVisible(true);
        this.fRemoteDebugPathMapTable.addSelectionListener((SelectionListener)this.fListener);
        this.fRemoteDebugPathMapTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PHPEnvironmentTab.this.setPathMapButtonsEnableState();
                if (PHPEnvironmentTab.this.fPathMapEditButton.isEnabled()) {
                    PHPEnvironmentTab.this.handlePathMapEditButtonSelected();
                }
            }
        });
        Composite envButtonComp = new Composite(pathMapComp, 0);
        GridLayout envButtonLayout = new GridLayout();
        envButtonLayout.marginHeight = 0;
        envButtonLayout.marginWidth = 0;
        envButtonComp.setLayout((Layout)envButtonLayout);
        gd = new GridData(258);
        envButtonComp.setLayoutData((Object)gd);
        this.fPathMapAddButton = this.createPushButton(envButtonComp, PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.Button.Add.label"), null);
        this.fPathMapAddButton.addSelectionListener((SelectionListener)this.fListener);
        this.fPathMapEditButton = this.createPushButton(envButtonComp, PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.Button.Edit.label"), null);
        this.fPathMapEditButton.addSelectionListener((SelectionListener)this.fListener);
        this.fPathMapRemoveButton = this.createPushButton(envButtonComp, PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.remoteDebugTab.PathMap.Button.Remove.label"), null);
        this.fPathMapRemoveButton.addSelectionListener((SelectionListener)this.fListener);
    }

    void handlePathMapAddButtonSelected() {
        EditPathMapDialog dialog = new EditPathMapDialog(this.getShell(), "Edit File Map", new String[]{EMPTY_STRING, EMPTY_STRING});
        this.openNewPathMapDialog(dialog, null);
        this.setPathMapButtonsEnableState();
    }

    void handlePathMapRemoveButtonSelected() {
        int[] selectedIndices = this.fRemoteDebugPathMapTable.getSelectionIndices();
        this.fRemoteDebugPathMapTable.remove(selectedIndices);
        this.setPathMapButtonsEnableState();
        this.updateLaunchConfigurationDialog();
    }

    void handlePathMapEditButtonSelected() {
        TableItem selectedItem = this.fRemoteDebugPathMapTable.getSelection()[0];
        String local = selectedItem.getText(0);
        String remote = selectedItem.getText(1);
        EditPathMapDialog dialog = new EditPathMapDialog(this.getShell(), "Edit File Map", new String[]{local, remote});
        this.openNewPathMapDialog(dialog, selectedItem);
    }

    private void setRemoteTabEnableState() {
        boolean state = this.fRemoteDebugCheckBox.getSelection();
        this.fRemoteSourcePath.setEnabled(state);
        this.fRemoteDebugTranslate.setEnabled(state);
        this.fRemoteDebugPathMapTable.setEnabled(state);
        if (!state) {
            this.fPathMapEditButton.setEnabled(false);
            this.fPathMapRemoveButton.setEnabled(false);
            this.fPathMapAddButton.setEnabled(false);
            this.fOpenDBGSessionInBrowserCheckBox.setEnabled(false);
        } else {
            this.setPathMapButtonsEnableState();
        }
        this.updateLaunchConfigurationDialog();
    }

    private void setPathMapButtonsEnableState() {
        if (this.fRemoteDebugCheckBox.getSelection()) {
            this.fOpenDBGSessionInBrowserCheckBox.setEnabled(true);
            this.fRemoteDebugTranslate.setEnabled(true);
            int selectCount = this.fRemoteDebugPathMapTable.getSelectionIndices().length;
            if (selectCount < 1) {
                this.fPathMapEditButton.setEnabled(false);
                this.fPathMapRemoveButton.setEnabled(false);
            } else {
                this.fPathMapRemoveButton.setEnabled(true);
                if (selectCount == 1) {
                    this.fPathMapEditButton.setEnabled(true);
                } else {
                    this.fPathMapEditButton.setEnabled(false);
                }
            }
            this.fPathMapAddButton.setEnabled(true);
        }
    }

    private void openNewPathMapDialog(EditPathMapDialog dialog, TableItem updateItem) {
        if (dialog.open() != 0) {
            return;
        }
        String[] pathPair = dialog.getPathPair();
        TableItem tableItem = updateItem;
        if (tableItem == null && (tableItem = this.getTableItemForName(pathPair[0])) == null) {
            tableItem = new TableItem(this.fRemoteDebugPathMapTable, 0);
        }
        tableItem.setText(pathPair);
        this.fRemoteDebugPathMapTable.setSelection(new TableItem[]{tableItem});
        this.updateLaunchConfigurationDialog();
    }

    private TableItem getTableItemForName(String candidateName) {
        TableItem[] items = this.fRemoteDebugPathMapTable.getItems();
        int i = 0;
        while (i < items.length) {
            String name = items[i].getText(0);
            if (name.equals(candidateName)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    protected SelectionListener getLoadPathSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Loadpath list selection occurred: " + e.getSource());
            }
        };
    }

    protected SelectionListener getLoadPathDefaultButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPEnvironmentTab.this.setUseLoadPathDefaults(((Button)e.getSource()).getSelection());
            }
        };
    }

    protected void addInterpreterTab(TabFolder tabFolder) {
        Composite interpreterComposite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        interpreterComposite.setLayout((Layout)layout);
        interpreterComposite.setLayoutData((Object)new GridData(768));
        this.createVerticalSpacer(interpreterComposite, 2);
        this.interpreterCombo = new Combo(interpreterComposite, 8);
        this.interpreterCombo.setLayoutData((Object)new GridData(768));
        this.initializeInterpreterCombo(this.interpreterCombo);
        this.interpreterCombo.addModifyListener(this.getInterpreterComboModifyListener());
        Button interpreterAddButton = new Button(interpreterComposite, 8);
        interpreterAddButton.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.interpreterAddButton.label"));
        interpreterAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PHPInterpreter newInterpreter = new PHPInterpreter(null);
                File phpRuntime = PHPInterpreterPreferencePage.getFile(PHPEnvironmentTab.this.getShell(), null);
                if (phpRuntime != null) {
                    newInterpreter.setInstallLocation(phpRuntime);
                    PHPRuntime.getDefault().addInstalledInterpreter(newInterpreter);
                    PHPEnvironmentTab.this.interpreterCombo.add(newInterpreter.getInstallLocation().toString());
                    PHPEnvironmentTab.this.interpreterCombo.select(PHPEnvironmentTab.this.interpreterCombo.indexOf(newInterpreter.getInstallLocation().toString()));
                }
            }
        });
        TabItem interpreterTab = new TabItem(tabFolder, 0);
        interpreterTab.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.interpreterTab.label"));
        interpreterTab.setControl((Control)interpreterComposite);
    }

    protected ModifyListener getInterpreterComboModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        PHPInterpreter selectedInterpreter = PHPRuntime.getDefault().getSelectedInterpreter();
        if (selectedInterpreter != null) {
            String interpreterLocation = selectedInterpreter.getInstallLocation().toString();
            configuration.setAttribute("net.sourceforge.phpeclipse.launching.SELECTED_INTERPRETER", interpreterLocation);
        }
        try {
            IProject project;
            String projectName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", EMPTY_STRING);
            if (projectName != EMPTY_STRING && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
                IPath remotePath = project.getLocation();
                String fileName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", EMPTY_STRING);
                if (fileName != EMPTY_STRING) {
                    Path filePath = new Path(fileName);
                    remotePath = remotePath.append(filePath.removeLastSegments(1));
                }
                configuration.setAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", remotePath.toOSString());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeInterpreterSelection(configuration);
        this.initializeRemoteDebug(configuration);
    }

    protected void initializeRemoteDebug(ILaunchConfiguration configuration) {
        try {
            this.fRemoteDebugCheckBox.setSelection(configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG", false));
        }
        catch (CoreException coreException) {
            this.fRemoteDebugCheckBox.setSelection(false);
        }
        try {
            this.fRemoteDebugTranslate.setSelection(configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG_TRANSLATE", false));
        }
        catch (CoreException coreException) {
            this.fRemoteDebugTranslate.setSelection(false);
        }
        try {
            this.fOpenDBGSessionInBrowserCheckBox.setSelection(configuration.getAttribute("net.sourceforge.phpeclipse.launching.OPEN_DBGSESSION_IN_BROWSER", true));
        }
        catch (CoreException coreException) {
            this.fOpenDBGSessionInBrowserCheckBox.setSelection(true);
        }
        this.setRemoteTabEnableState();
        try {
            this.fRemoteSourcePath.setText(configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {
            this.fRemoteSourcePath.setText(EMPTY_STRING);
        }
        this.updatePathMapFromConfig(configuration);
    }

    private void updatePathMapFromConfig(ILaunchConfiguration config) {
        Map envVars = null;
        try {
            if (config != null) {
                envVars = config.getAttribute("net.sourceforge.phpeclipse.launching.FILE_MAP", null);
            }
            this.updatePathMapTable(envVars, this.fRemoteDebugPathMapTable);
            this.setPathMapButtonsEnableState();
        }
        catch (CoreException ce) {
            this.log(ce);
        }
    }

    private void updatePathMapTable(Map map, Table tableWidget) {
        tableWidget.removeAll();
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)map.get(key);
            TableItem tableItem = new TableItem(tableWidget, 0);
            tableItem.setText(new String[]{key, value});
        }
    }

    protected void setUseLoadPathDefaults(boolean useDefaults) {
        this.loadPathListViewer.getList().setEnabled(!useDefaults);
    }

    protected void initializeInterpreterSelection(ILaunchConfiguration configuration) {
        String interpreterName = null;
        try {
            interpreterName = configuration.getAttribute("net.sourceforge.phpeclipse.launching.SELECTED_INTERPRETER", EMPTY_STRING);
        }
        catch (CoreException e) {
            this.log(e);
        }
        if (interpreterName != null && !interpreterName.equals(EMPTY_STRING)) {
            this.interpreterCombo.select(this.interpreterCombo.indexOf(interpreterName));
        }
    }

    protected void initializeInterpreterCombo(Combo interpreterCombo) {
        this.installedInterpretersWorkingCopy = new ArrayList();
        this.installedInterpretersWorkingCopy.addAll(PHPRuntime.getDefault().getInstalledInterpreters());
        String[] interpreterNames = new String[this.installedInterpretersWorkingCopy.size()];
        int interpreterIndex = 0;
        while (interpreterIndex < this.installedInterpretersWorkingCopy.size()) {
            PHPInterpreter interpreter = (PHPInterpreter)this.installedInterpretersWorkingCopy.get(interpreterIndex);
            interpreterNames[interpreterIndex] = interpreter.getInstallLocation().toString();
            ++interpreterIndex;
        }
        interpreterCombo.setItems(interpreterNames);
        PHPInterpreter selectedInterpreter = PHPRuntime.getDefault().getSelectedInterpreter();
        if (selectedInterpreter != null) {
            interpreterCombo.select(interpreterCombo.indexOf(selectedInterpreter.getInstallLocation().toString()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int selectionIndex = this.interpreterCombo.getSelectionIndex();
        if (selectionIndex >= 0) {
            configuration.setAttribute("net.sourceforge.phpeclipse.launching.SELECTED_INTERPRETER", this.interpreterCombo.getItem(selectionIndex));
        }
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG", this.fRemoteDebugCheckBox.getSelection());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG_TRANSLATE", this.fRemoteDebugTranslate.getSelection());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.FILE_MAP", this.getMapFromPathMapTable());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", this.fRemoteSourcePath.getText());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.OPEN_DBGSESSION_IN_BROWSER", this.fOpenDBGSessionInBrowserCheckBox.getSelection());
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createVerticalSpacer(composite, 2);
        this.setControl((Control)composite);
        return composite;
    }

    private Map getMapFromPathMapTable() {
        TableItem[] items = this.fRemoteDebugPathMapTable.getItems();
        if (items.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            String key = item.getText(0);
            String value = item.getText(1);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public String getName() {
        return PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.name");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String selectedInterpreter = launchConfig.getAttribute("net.sourceforge.phpeclipse.launching.SELECTED_INTERPRETER", EMPTY_STRING);
            if (selectedInterpreter.length() == 0) {
                this.setErrorMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPEnvironment.interpreter_not_selected_error_message"));
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable t) {
        PHPDebugUiPlugin.log(t);
    }

    public Image getImage() {
        return PHPUiImages.get((String)"net.sourceforge.phpdt.internal.ui.php.gif");
    }

    private class RemoteDebugTabListener
    extends SelectionAdapter
    implements ModifyListener {
        RemoteDebugTabListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPEnvironmentTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PHPEnvironmentTab.this.fRemoteDebugPathMapTable) {
                PHPEnvironmentTab.this.setPathMapButtonsEnableState();
            } else if (source == PHPEnvironmentTab.this.fPathMapAddButton) {
                PHPEnvironmentTab.this.handlePathMapAddButtonSelected();
            } else if (source == PHPEnvironmentTab.this.fPathMapEditButton) {
                PHPEnvironmentTab.this.handlePathMapEditButtonSelected();
            } else if (source == PHPEnvironmentTab.this.fPathMapRemoveButton) {
                PHPEnvironmentTab.this.handlePathMapRemoveButtonSelected();
            } else if (source == PHPEnvironmentTab.this.fRemoteDebugCheckBox) {
                PHPEnvironmentTab.this.setRemoteTabEnableState();
            } else if (source == PHPEnvironmentTab.this.fRemoteDebugTranslate) {
                PHPEnvironmentTab.this.setRemoteTabEnableState();
            } else {
                PHPEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

