/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.preferences.PHPInterpreterContentProvider;
import net.sourceforge.phpdt.internal.debug.ui.preferences.PHPInterpreterLabelProvider;
import net.sourceforge.phpdt.internal.launching.PHPInterpreter;
import net.sourceforge.phpdt.internal.launching.PHPRuntime;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PHPInterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected CheckboxTableViewer tableViewer;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = this.createPageRoot(parent);
        Table table = this.createInstalledInterpretersTable(composite);
        this.createInstalledInterpretersTableViewer(table);
        this.createButtonGroup(composite);
        this.tableViewer.setInput((Object)PHPRuntime.getDefault().getInstalledInterpreters());
        PHPInterpreter selectedInterpreter = PHPRuntime.getDefault().getSelectedInterpreter();
        if (selectedInterpreter != null) {
            this.tableViewer.setChecked((Object)selectedInterpreter, true);
        }
        this.enableButtons();
        return composite;
    }

    protected void createButtonGroup(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setText(PHPDebugUiMessages.getString("PHPInterpreterPreferencePage.addButton.label"));
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PHPInterpreterPreferencePage.this.addInterpreter();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(PHPDebugUiMessages.getString("PHPInterpreterPreferencePage.editButton.label"));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PHPInterpreterPreferencePage.this.editInterpreter();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.setText(PHPDebugUiMessages.getString("PHPInterpreterPreferencePage.removeButton.label"));
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PHPInterpreterPreferencePage.this.removeInterpreter();
            }
        });
    }

    protected void createInstalledInterpretersTableViewer(Table table) {
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PHPInterpreterLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new PHPInterpreterContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                PHPInterpreterPreferencePage.this.enableButtons();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PHPInterpreterPreferencePage.this.updateSelectedInterpreter(event.getElement());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                PHPInterpreterPreferencePage.this.editInterpreter();
            }
        });
    }

    protected Table createInstalledInterpretersTable(Composite composite) {
        Table table = new Table(composite, 67616);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn column = new TableColumn(table, 0);
        column.setText(PHPDebugUiMessages.getString("PHPInterpreterPreferencePage.PHPInterpreterTable.interpreterPath"));
        column.setWidth(400);
        return table;
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void addInterpreter() {
        PHPInterpreter newInterpreter = new PHPInterpreter(null);
        File phpRuntime = PHPInterpreterPreferencePage.getFile(this.getShell(), null);
        if (phpRuntime != null) {
            newInterpreter.setInstallLocation(phpRuntime);
            this.tableViewer.add((Object)newInterpreter);
        }
    }

    protected void removeInterpreter() {
        this.tableViewer.remove((Object)this.getSelectedInterpreter());
    }

    protected void enableButtons() {
        if (this.getSelectedInterpreter() != null) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void updateSelectedInterpreter(Object interpreter) {
        Object[] checkedElements = this.tableViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            this.tableViewer.setChecked(checkedElements[i], false);
            ++i;
        }
        this.tableViewer.setChecked(interpreter, true);
    }

    protected void editInterpreter() {
        PHPInterpreter anInterpreter = this.getSelectedInterpreter();
        File phpRuntime = anInterpreter.getInstallLocation();
        if (phpRuntime != null) {
            File parent = phpRuntime.getParentFile();
            phpRuntime = PHPInterpreterPreferencePage.getFile(this.getShell(), parent);
        } else {
            phpRuntime = PHPInterpreterPreferencePage.getFile(this.getShell(), null);
        }
        if (phpRuntime != null) {
            anInterpreter.setInstallLocation(phpRuntime);
            this.tableViewer.update((Object)anInterpreter, null);
        }
    }

    protected PHPInterpreter getSelectedInterpreter() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        return (PHPInterpreter)selection.getFirstElement();
    }

    public boolean performOk() {
        TableItem[] tableItems = this.tableViewer.getTable().getItems();
        ArrayList<Object> installedInterpreters = new ArrayList<Object>(tableItems.length);
        int i = 0;
        while (i < tableItems.length) {
            installedInterpreters.add(tableItems[i].getData());
            ++i;
        }
        PHPRuntime.getDefault().setInstalledInterpreters(installedInterpreters);
        Object[] checkedElements = this.tableViewer.getCheckedElements();
        if (checkedElements.length > 0) {
            PHPRuntime.getDefault().setSelectedInterpreter((PHPInterpreter)checkedElements[0]);
        }
        return super.performOk();
    }

    public static File getFile(Shell shell, File startingDirectory) {
        String file;
        String operatingSystem;
        FileDialog dialog = new FileDialog(shell, 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if ((operatingSystem = Platform.getOS()).equals("win32")) {
            String[] extensions = new String[]{"*.exe"};
            dialog.setFilterExtensions(extensions);
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }
}

