/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import net.sourceforge.phpdt.externaltools.util.StringUtil;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import net.sourceforge.phpeclipse.externaltools.PHPConsole;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ExternalPHPParser {
    private static final String PROBLEM_ID = "net.sourceforge.phpeclipse.problem";
    private static final String PARSE_ERROR_STRING = "Parse error";
    private static final String PARSE_WARNING_STRING = "Warning";
    public static final int ERROR = 2;
    public static final int WARNING = 1;
    public static final int INFO = 0;
    public static final int TASK = 3;
    protected final IFile fFileToParse;

    public ExternalPHPParser(IFile file) {
        this.fFileToParse = file;
    }

    public void phpExternalParse() {
        IPreferenceStore store = ExternalToolsPlugin.getDefault().getPreferenceStore();
        String filename = this.fFileToParse.getLocation().toString();
        String[] arguments = new String[]{filename};
        MessageFormat form = new MessageFormat(store.getString("_external_parser"));
        String command = form.format(arguments);
        String parserResult = this.getParserOutput(command, "External parser: ");
        try {
            this.createMarkers(parserResult, this.fFileToParse);
        }
        catch (CoreException coreException) {}
    }

    protected void createMarkers(String output, IFile file) throws CoreException {
        int brIndx;
        file.deleteMarkers(PROBLEM_ID, false, 0);
        int indx = 0;
        boolean flag = true;
        while ((brIndx = output.indexOf("<br />", indx)) != -1) {
            this.scanLine(output, file, indx, brIndx);
            indx = brIndx + 6;
            flag = false;
        }
        if (flag) {
            while ((brIndx = output.indexOf("<br>", indx)) != -1) {
                this.scanLine(output, file, indx, brIndx);
                indx = brIndx + 4;
            }
        }
    }

    private void scanLine(String output, IFile file, int indx, int brIndx) throws CoreException {
        int onLine;
        StringBuffer lineNumberBuffer = new StringBuffer(10);
        String current = output.substring(indx, brIndx);
        if ((current.indexOf(PARSE_WARNING_STRING) != -1 || current.indexOf(PARSE_ERROR_STRING) != -1) && (onLine = current.indexOf("on line <b>")) != -1) {
            lineNumberBuffer.delete(0, lineNumberBuffer.length());
            int i = onLine;
            while (i < current.length()) {
                char ch = current.charAt(i);
                if ('0' <= ch && '9' >= ch) {
                    lineNumberBuffer.append(ch);
                }
                ++i;
            }
            int lineNumber = Integer.parseInt(lineNumberBuffer.toString());
            Hashtable<String, Integer> attributes = new Hashtable<String, Integer>();
            current = StringUtil.replaceAll(current, "\n", "");
            current = StringUtil.replaceAll(current, "<b>", "");
            current = StringUtil.replaceAll(current, "</b>", "");
            MarkerUtilities.setMessage(attributes, (String)current);
            if (current.indexOf(PARSE_ERROR_STRING) != -1) {
                attributes.put("severity", new Integer(2));
            } else if (current.indexOf(PARSE_WARNING_STRING) != -1) {
                attributes.put("severity", new Integer(1));
            } else {
                attributes.put("severity", new Integer(0));
            }
            MarkerUtilities.setLineNumber(attributes, (int)lineNumber);
            MarkerUtilities.createMarker((IResource)file, attributes, (String)PROBLEM_ID);
        }
    }

    private void setMarker(IFile file, String message, int charStart, int charEnd, int errorLevel) throws CoreException {
        if (file != null) {
            Hashtable<String, Integer> attributes = new Hashtable<String, Integer>();
            MarkerUtilities.setMessage(attributes, (String)message);
            switch (errorLevel) {
                case 2: {
                    attributes.put("severity", new Integer(2));
                    break;
                }
                case 1: {
                    attributes.put("severity", new Integer(1));
                    break;
                }
                case 0: {
                    attributes.put("severity", new Integer(0));
                    break;
                }
                case 3: {
                    attributes.put("severity", new Integer("org.eclipse.core.resources.taskmarker"));
                }
            }
            MarkerUtilities.setCharStart(attributes, (int)charStart);
            MarkerUtilities.setCharEnd(attributes, (int)charEnd);
            MarkerUtilities.createMarker((IResource)file, attributes, (String)PROBLEM_ID);
        }
    }

    private void setMarker(IFile file, String message, int line, int errorLevel, String location) throws CoreException {
        if (file != null) {
            String markerKind = PROBLEM_ID;
            Hashtable<String, Object> attributes = new Hashtable<String, Object>();
            MarkerUtilities.setMessage(attributes, (String)message);
            switch (errorLevel) {
                case 2: {
                    attributes.put("severity", new Integer(2));
                    break;
                }
                case 1: {
                    attributes.put("severity", new Integer(1));
                    break;
                }
                case 0: {
                    attributes.put("severity", new Integer(0));
                    break;
                }
                case 3: {
                    attributes.put("severity", new Integer(0));
                    markerKind = "org.eclipse.core.resources.taskmarker";
                }
            }
            attributes.put("location", location);
            MarkerUtilities.setLineNumber(attributes, (int)line);
            MarkerUtilities.createMarker((IResource)file, attributes, (String)markerKind);
        }
    }

    private void setMarker(String message, int charStart, int charEnd, int errorLevel, String location) throws CoreException {
        if (this.fFileToParse != null) {
            this.setMarker(this.fFileToParse, message, charStart, charEnd, errorLevel, location);
        }
    }

    private void setMarker(IFile file, String message, int charStart, int charEnd, int errorLevel, String location) throws CoreException {
        if (file != null) {
            Hashtable<String, Object> attributes = new Hashtable<String, Object>();
            MarkerUtilities.setMessage(attributes, (String)message);
            switch (errorLevel) {
                case 2: {
                    attributes.put("severity", new Integer(2));
                    break;
                }
                case 1: {
                    attributes.put("severity", new Integer(1));
                    break;
                }
                case 0: {
                    attributes.put("severity", new Integer(0));
                    break;
                }
                case 3: {
                    attributes.put("severity", new Integer("org.eclipse.core.resources.taskmarker"));
                }
            }
            attributes.put("location", location);
            MarkerUtilities.setCharStart(attributes, (int)charStart);
            MarkerUtilities.setCharEnd(attributes, (int)charEnd);
            MarkerUtilities.createMarker((IResource)file, attributes, (String)PROBLEM_ID);
        }
    }

    private String getParserOutput(String command, String consoleMessage) {
        try {
            PHPConsole console = new PHPConsole();
            try {
                console.println(String.valueOf(consoleMessage) + command);
            }
            catch (Throwable throwable) {}
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(command);
            InputStream stream = p.getInputStream();
            String consoleOutput = PHPConsole.getStringFromStream(stream);
            if (console != null) {
                console.print(consoleOutput);
            }
            return consoleOutput;
        }
        catch (IOException e) {
            MessageDialog.openInformation(null, (String)"IOException: ", (String)e.getMessage());
            return "";
        }
    }
}

