/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.launchConfigurations;

import net.sourceforge.phpdt.externaltools.group.IGroupDialogPage;
import net.sourceforge.phpdt.externaltools.internal.dialog.ExternalToolVariableForm;
import net.sourceforge.phpdt.externaltools.internal.model.ExternalToolsImages;
import net.sourceforge.phpdt.externaltools.internal.registry.ExternalToolVariable;
import net.sourceforge.phpdt.externaltools.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import net.sourceforge.phpdt.externaltools.model.ToolUtil;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExternalToolsRefreshTab
extends AbstractLaunchConfigurationTab
implements IGroupDialogPage {
    private ExternalToolVariableForm variableForm;
    protected Button refreshField;
    protected Button recursiveField;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createVerticalSpacer(mainComposite, 1);
        this.createRefreshComponent(mainComposite);
        this.createRecursiveComponent(mainComposite);
        this.createScopeComponent(mainComposite);
    }

    protected void createRecursiveComponent(Composite parent) {
        this.recursiveField = new Button(parent, 32);
        this.recursiveField.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Recursively_&include_sub-folders_1"));
        GridData data = new GridData(256);
        this.recursiveField.setLayoutData((Object)data);
        this.recursiveField.setFont(parent.getFont());
        this.recursiveField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsRefreshTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createRefreshComponent(Composite parent) {
        this.refreshField = new Button(parent, 32);
        this.refreshField.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.&Refresh_resources_after_running_tool_1"));
        GridData data = new GridData(256);
        this.refreshField.setLayoutData((Object)data);
        this.refreshField.setFont(parent.getFont());
        this.refreshField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsRefreshTab.this.updateEnabledState();
                ExternalToolsRefreshTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createScopeComponent(Composite parent) {
        String label = ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Choose_scope_v&ariable___2");
        ExternalToolVariable[] vars = ExternalToolsPlugin.getDefault().getRefreshVariableRegistry().getRefreshVariables();
        this.variableForm = new ExternalToolVariableForm(label, vars);
        this.variableForm.createContents(parent, this);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateRefresh(configuration);
        this.updateRecursive(configuration);
        this.updateScope(configuration);
    }

    private void updateScope(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_SCOPE", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Exception_reading_launch_configuration_3"), ce);
        }
        String varName = null;
        String varValue = null;
        if (scope != null) {
            ToolUtil.VariableDefinition varDef = ToolUtil.extractVariableTag(scope, 0);
            varName = varDef.name;
            varValue = varDef.argument;
        }
        this.variableForm.selectVariable(varName, varValue);
    }

    private void updateRecursive(ILaunchConfiguration configuration) {
        boolean recursive = true;
        try {
            recursive = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_RECURSIVE", false);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Exception_reading_launch_configuration_3"), ce);
        }
        this.recursiveField.setSelection(recursive);
    }

    private void updateRefresh(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_SCOPE", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Exception_reading_launch_configuration_3"), ce);
        }
        this.refreshField.setSelection(scope != null);
        this.updateEnabledState();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.refreshField.getSelection()) {
            configuration.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_SCOPE", this.variableForm.getSelectedVariable());
        } else {
            configuration.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_SCOPE", null);
        }
        this.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_RECURSIVE", configuration, this.recursiveField.getSelection(), false);
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsRefreshTab.Refres&h_6");
    }

    protected void updateEnabledState() {
        if (this.refreshField != null) {
            if (this.recursiveField != null) {
                this.recursiveField.setEnabled(this.refreshField.getSelection());
            }
            if (this.variableForm != null) {
                this.variableForm.setEnabled(this.refreshField.getSelection());
            }
        }
    }

    public int convertHeightHint(int chars) {
        return 0;
    }

    public GridData setButtonGridData(Button button) {
        return null;
    }

    public void setMessage(String newMessage, int newType) {
        this.setMessage(newMessage);
    }

    public void updateValidState() {
        this.updateLaunchConfigurationDialog();
    }

    public int getMessageType() {
        if (this.getErrorMessage() != null) {
            return 3;
        }
        if (this.getMessage() != null) {
            return 2;
        }
        return 0;
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("net.sourceforge.phpeclipse.externaltools.IMG_ACTION_REFRESH");
    }
}

