/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import net.sourceforge.phpdt.externaltools.internal.model.ExternalToolsModelMessages;
import net.sourceforge.phpdt.externaltools.internal.model.VariableContextManager;
import net.sourceforge.phpdt.externaltools.internal.registry.ExternalToolMigration;
import net.sourceforge.phpdt.externaltools.internal.registry.RefreshScopeVariable;
import net.sourceforge.phpdt.externaltools.internal.registry.RefreshScopeVariableRegistry;
import net.sourceforge.phpdt.externaltools.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import net.sourceforge.phpdt.externaltools.model.ToolUtil;
import net.sourceforge.phpdt.externaltools.variable.ExpandVariableContext;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class ExternalToolsUtil {
    private static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";

    private ExternalToolsUtil() {
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse.externaltools", code, message, exception));
    }

    public static ExpandVariableContext getVariableContext() {
        return VariableContextManager.getDefault().getVariableContext();
    }

    public static IPath getLocation(ILaunchConfiguration configuration, ExpandVariableContext context) throws CoreException {
        String location = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            ExternalToolsUtil.abort(MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.Location_not_specified_by_{0}_1"), configuration.getName()), null, 0);
        } else {
            MultiStatus status = new MultiStatus("net.sourceforge.phpeclipse.externaltools", 0, ExternalToolsModelMessages.getString("RunExternalToolAction.runProblem"), null);
            String expandedLocation = ToolUtil.expandFileLocation(location, context, status);
            if (status.isOK()) {
                if (expandedLocation == null || expandedLocation.length() == 0) {
                    String msg = ExternalToolsModelMessages.format("DefaultRunnerContext.invalidLocation", new Object[]{configuration.getName()});
                    ExternalToolsUtil.abort(msg, null, 0);
                } else {
                    File file = new File(expandedLocation);
                    if (file.isFile()) {
                        return new Path(expandedLocation);
                    }
                    String msg = ExternalToolsModelMessages.format("DefaultRunnerContext.invalidLocation", new Object[]{configuration.getName()});
                    ExternalToolsUtil.abort(msg, null, 0);
                }
            } else {
                throw new CoreException((IStatus)status);
            }
        }
        return null;
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration, ExpandVariableContext context) throws CoreException {
        String location = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null) {
            MultiStatus status = new MultiStatus("net.sourceforge.phpeclipse.externaltools", 0, ExternalToolsModelMessages.getString("RunExternalToolAction.runProblem"), null);
            String expandedLocation = ToolUtil.expandDirectoryLocation(location, context, status);
            if (status.isOK()) {
                if (expandedLocation != null && expandedLocation.length() > 0) {
                    File path = new File(expandedLocation);
                    if (path.isDirectory()) {
                        return new Path(expandedLocation);
                    }
                    String msg = ExternalToolsModelMessages.format("DefaultRunnerContext.invalidDirectory", new Object[]{configuration.getName()});
                    ExternalToolsUtil.abort(msg, null, 0);
                }
            } else {
                throw new CoreException((IStatus)status);
            }
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration, ExpandVariableContext context) throws CoreException {
        String args = configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            MultiStatus status = new MultiStatus("net.sourceforge.phpeclipse.externaltools", 0, ExternalToolsModelMessages.getString("RunExternalToolAction.runProblem"), null);
            String[] expandedArgs = ToolUtil.expandArguments(args, context, status);
            if (status.isOK()) {
                return expandedArgs;
            }
            throw new CoreException((IStatus)status);
        }
        return null;
    }

    public static String getRefreshScope(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_SCOPE", null);
    }

    public static boolean isRefreshRecursive(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_REFRESH_RECURSIVE", false);
    }

    public static void refreshResources(ILaunchConfiguration configuration, ExpandVariableContext context, IProgressMonitor monitor) throws CoreException {
        RefreshScopeVariableRegistry registry;
        RefreshScopeVariable variable;
        String scope = ExternalToolsUtil.getRefreshScope(configuration);
        if (scope == null) {
            return;
        }
        ToolUtil.VariableDefinition varDef = ToolUtil.extractVariableTag(scope, 0);
        if (varDef.start == -1 || varDef.end == -1 || varDef.name == null) {
            String msg = ExternalToolsModelMessages.format("DefaultRunnerContext.invalidRefreshVarFormat", new Object[]{configuration.getName()});
            ExternalToolsUtil.abort(msg, null, 0);
        }
        if ((variable = (registry = ExternalToolsPlugin.getDefault().getRefreshVariableRegistry()).getRefreshVariable(varDef.name)) == null) {
            String msg = ExternalToolsModelMessages.format("DefaultRunnerContext.noRefreshVarNamed", new Object[]{configuration.getName(), varDef.name});
            ExternalToolsUtil.abort(msg, null, 0);
        }
        int depth = 0;
        if (ExternalToolsUtil.isRefreshRecursive(configuration)) {
            depth = 2;
        }
        if (monitor.isCanceled()) {
            return;
        }
        IResource[] resources = variable.getExpander().getResources(varDef.name, varDef.argument, context);
        if (resources == null || resources.length == 0) {
            return;
        }
        monitor.beginTask(ExternalToolsModelMessages.getString("DefaultRunnerContext.refreshResources"), resources.length);
        MultiStatus status = new MultiStatus("net.sourceforge.phpeclipse.externaltools", 0, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.Exception(s)_occurred_during_refresh._2"), null);
        int i = 0;
        while (i < resources.length) {
            if (monitor.isCanceled()) break;
            if (resources[i] != null && resources[i].isAccessible()) {
                try {
                    resources[i].refreshLocal(depth, null);
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean isBackground(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_RUN_IN_BACKGROUND", false);
    }

    public static ILaunchConfiguration configFromBuildCommandArgs(Map commandArgs) {
        String configHandle = (String)commandArgs.get(LAUNCH_CONFIG_HANDLE);
        if (configHandle == null) {
            return ExternalToolMigration.configFromArgumentMap(commandArgs);
        }
        try {
            return DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(configHandle);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void execute(String command, String executable, String arguments, boolean background) {
        ExternalToolsUtil.execute(command, executable, null, arguments, background);
    }

    public static void execute(String command, String executable, String workingDirectory, String arguments, boolean background) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("net.sourceforge.phpeclipse.externaltools.ProgramLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = type.newInstance(null, command);
        }
        catch (CoreException coreException) {}
        wc.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_LOCATION", executable);
        if (workingDirectory != null) {
            wc.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_WORKING_DIRECTORY", workingDirectory);
        }
        if (arguments != null) {
            wc.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
        wc.setAttribute("net.sourceforge.phpeclipse.externaltools.ATTR_RUN_IN_BACKGROUND", background);
        try {
            ILaunchConfiguration config = wc.doSave();
            config.launch("run", null);
        }
        catch (CoreException coreException) {}
    }
}

