/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.variable;

import net.sourceforge.phpdt.externaltools.group.IGroupDialogPage;
import net.sourceforge.phpdt.externaltools.internal.model.ExternalToolsModelMessages;
import net.sourceforge.phpdt.externaltools.model.ToolUtil;
import net.sourceforge.phpdt.externaltools.variable.IVariableComponent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceComponent
implements IVariableComponent {
    private IGroupDialogPage page;
    private boolean isValid = true;
    protected Group mainGroup;
    protected Button selectedResourceButton;
    protected Button specificResourceButton;
    protected TreeViewer resourceList;
    private IResource selectedResource;

    public void createContents(Composite parent, String varTag, IGroupDialogPage page) {
        this.page = page;
        this.mainGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.mainGroup.setLayout((Layout)layout);
        this.mainGroup.setLayoutData((Object)gridData);
        this.mainGroup.setFont(parent.getFont());
        this.mainGroup.setText(ToolUtil.buildVariableTag(varTag, null));
        this.createSelectedResourceOption();
        this.createSpecificResourceOption();
        this.createResourceList();
        this.updateResourceListEnablement();
    }

    protected void createResourceList() {
        Tree tree = new Tree((Composite)this.mainGroup, 2052);
        GridData data = new GridData(1808);
        data.heightHint = tree.getItemHeight() * this.getInitialVisibleItemCount();
        tree.setLayoutData((Object)data);
        tree.setFont(this.mainGroup.getFont());
        this.resourceList = new TreeViewer(tree);
        this.resourceList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceComponent.this.validateResourceListSelection();
                ResourceComponent.this.selectedResource = (IResource)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.resourceList.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.resourceList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.resourceList.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected void createSelectedResourceOption() {
        this.selectedResourceButton = new Button((Composite)this.mainGroup, 16);
        this.selectedResourceButton.setText(ExternalToolsModelMessages.getString("ResourceComponent.selectedResLabel"));
        GridData data = new GridData(256);
        this.selectedResourceButton.setLayoutData((Object)data);
        this.selectedResourceButton.setFont(this.mainGroup.getFont());
        this.selectedResourceButton.setSelection(true);
    }

    protected void createSpecificResourceOption() {
        this.specificResourceButton = new Button((Composite)this.mainGroup, 16);
        this.specificResourceButton.setText(ExternalToolsModelMessages.getString("ResourceComponent.specificResLabel"));
        GridData data = new GridData(256);
        this.specificResourceButton.setLayoutData((Object)data);
        this.specificResourceButton.setFont(this.mainGroup.getFont());
        this.specificResourceButton.setSelection(false);
        this.specificResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceComponent.this.updateResourceListEnablement();
            }
        });
    }

    public Control getControl() {
        return this.mainGroup;
    }

    protected final IGroupDialogPage getPage() {
        return this.page;
    }

    public String getVariableValue() {
        if (this.selectedResourceButton != null && this.selectedResourceButton.getSelection()) {
            return null;
        }
        if (this.resourceList != null && this.selectedResource != null) {
            return this.selectedResource.getFullPath().toString();
        }
        return null;
    }

    protected int getInitialVisibleItemCount() {
        return 10;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected final void setIsValid(boolean isValid) {
        if (this.isValid != isValid) {
            this.isValid = isValid;
            this.page.updateValidState();
        }
    }

    protected void updateResourceListEnablement() {
        if (this.specificResourceButton != null && this.resourceList != null) {
            this.resourceList.getTree().setEnabled(this.specificResourceButton.getSelection());
        }
    }

    public void setVariableValue(String varValue) {
        if (varValue == null || varValue.length() == 0) {
            if (this.selectedResourceButton != null) {
                this.selectedResourceButton.setSelection(true);
            }
            if (this.specificResourceButton != null) {
                this.specificResourceButton.setSelection(false);
            }
            if (this.resourceList != null) {
                this.resourceList.getTree().setEnabled(false);
            }
        } else {
            if (this.selectedResourceButton != null) {
                this.selectedResourceButton.setSelection(false);
            }
            if (this.specificResourceButton != null) {
                this.specificResourceButton.setSelection(true);
            }
            if (this.resourceList != null) {
                this.resourceList.getTree().setEnabled(true);
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(varValue);
                if (member != null) {
                    this.resourceList.setSelection((ISelection)new StructuredSelection((Object)member), true);
                } else {
                    this.resourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        }
    }

    public void validate() {
        if (this.specificResourceButton != null && this.specificResourceButton.getSelection()) {
            this.validateResourceListSelection();
        }
        this.getPage().setMessage(null, 0);
        this.setIsValid(true);
    }

    protected boolean validateResourceListSelection() {
        if (this.resourceList == null) {
            return true;
        }
        if (this.resourceList.getSelection().isEmpty()) {
            this.getPage().setMessage(ExternalToolsModelMessages.getString("ResourceComponent.selectionRequired"), 2);
            this.setIsValid(false);
            return false;
        }
        return true;
    }
}

