/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.externaltools;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PHPConsole {
    private MessageConsole myConsole = new MessageConsole("PHPeclipse Console", null);
    private MessageConsoleStream stream;
    private boolean hasMessages = false;

    public PHPConsole() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.myConsole});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.myConsole);
        this.stream = this.myConsole.newMessageStream();
    }

    public Color getColor() {
        return this.stream.getColor();
    }

    public MessageConsole getConsole() {
        return this.stream.getConsole();
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    public void print(String message) {
        this.hasMessages = true;
        this.stream.print(message);
    }

    public void println() {
        this.hasMessages = true;
        this.stream.println();
    }

    public void println(String message) {
        this.hasMessages = true;
        this.stream.println(message);
    }

    public void setColor(Color color) {
        this.stream.setColor(color);
    }

    public static String getStringFromStream(InputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        byte[] b = new byte[100];
        int finished = 0;
        while (finished != -1) {
            finished = stream.read(b);
            if (finished == -1) continue;
            String current = new String(b, 0, finished);
            buffer.append(current);
        }
        return buffer.toString();
    }
}

