/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.compare;

import net.sourceforge.phpeclipse.xml.ui.XMLPlugin;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLConfiguration;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class XMLMergeViewer
extends TextMergeViewer {
    private IPreferenceStore preferenceStore;
    private IPropertyChangeListener propertyChangeListener;
    private XMLTextTools textTools;

    public XMLMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style, configuration);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        XMLPlugin plugin = XMLPlugin.getDefault();
        this.preferenceStore = plugin.getPreferenceStore();
        if (this.preferenceStore != null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    XMLMergeViewer.this.handlePreferenceStoreChanged(event);
                }
            };
            this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.textTools = plugin.getXMLTextTools();
        if (textViewer instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)textViewer;
            sourceViewer.configure((SourceViewerConfiguration)new XMLConfiguration(this.textTools));
        }
        this.updateBackgroundColor();
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return this.textTools.createXMLPartitioner();
    }

    public String getTitle() {
        return XMLPlugin.getResourceString("XMLMergeViewer.title");
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.propertyChangeListener != null) {
            if (this.preferenceStore != null) {
                this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.propertyChangeListener = null;
        }
        super.handleDispose(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.updateBackgroundColor();
        } else if (this.textTools.affectsBehavior(event)) {
            this.invalidateTextPresentation();
        }
    }

    private void updateBackgroundColor() {
        boolean defaultBackgroundColor = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (defaultBackgroundColor) {
            this.setBackgroundColor(null);
        } else {
            RGB backgroundColor = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)"AbstractTextEditor.Color.Background");
            this.setBackgroundColor(backgroundColor);
        }
    }
}

