/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.editor;

import java.net.MalformedURLException;
import net.sourceforge.phpeclipse.xml.core.internal.model.XMLDocument;
import net.sourceforge.phpeclipse.xml.core.model.IXMLDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class XMLDocumentProvider
extends TextFileDocumentProvider {
    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new XMLFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo fileInfo = super.createFileInfo(element);
        if (!(fileInfo instanceof XMLFileInfo)) {
            return null;
        }
        IDocument document = fileInfo.fTextFileBuffer.getDocument();
        String systemId = null;
        try {
            systemId = this.getSystemFile(fileInfo).toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {}
        IXMLDocument xmlDocument = this.createModel(document, systemId);
        if (xmlDocument instanceof IDocumentListener) {
            document.addDocumentListener((IDocumentListener)xmlDocument);
        }
        XMLFileInfo xmlFileInfo = (XMLFileInfo)fileInfo;
        xmlFileInfo.xmlDocument = xmlDocument;
        return xmlFileInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        IXMLDocument xmlDocument;
        IDocument document;
        if (info instanceof XMLFileInfo && (document = this.getDocument(element)) != null && (xmlDocument = ((XMLFileInfo)info).xmlDocument) instanceof IDocumentListener) {
            document.removeDocumentListener((IDocumentListener)xmlDocument);
        }
        super.disposeFileInfo(element, info);
    }

    public IXMLDocument createModel(IDocument document, String systemId) {
        return new XMLDocument(document, systemId);
    }

    public IXMLDocument getModel(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof XMLFileInfo) {
            XMLFileInfo xmlFileInfo = (XMLFileInfo)info;
            return xmlFileInfo.xmlDocument;
        }
        return null;
    }

    private class XMLFileInfo
    extends TextFileDocumentProvider.FileInfo {
        IXMLDocument xmlDocument;

        XMLFileInfo() {
        }
    }
}

