/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.editor;

import java.util.ArrayList;
import net.sourceforge.phpeclipse.core.model.ISourceReference;
import net.sourceforge.phpeclipse.ui.editor.ShowExternalPreviewAction;
import net.sourceforge.phpeclipse.ui.text.IReconcilingParticipant;
import net.sourceforge.phpeclipse.xml.ui.XMLPlugin;
import net.sourceforge.phpeclipse.xml.ui.internal.editor.XMLDocumentProvider;
import net.sourceforge.phpeclipse.xml.ui.internal.editor.XMLEditorMessages;
import net.sourceforge.phpeclipse.xml.ui.internal.outline.XMLOutlinePage;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLConfiguration;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class XMLEditor
extends TextEditor
implements IReconcilingParticipant {
    XMLOutlinePage outlinePage;
    int fType;
    private ISelectionChangedListener outlineSelectionChangedListener;
    static /* synthetic */ Class class$0;

    public XMLEditor() {
        this(1);
    }

    public XMLEditor(int type) {
        this.fType = type;
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(XMLPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()])));
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            if (this.outlinePage == null) {
                this.outlinePage = new XMLOutlinePage(this);
                this.outlineSelectionChangedListener = new OutlineSelectionChangedListener();
                this.outlinePage.addSelectionChangedListener(this.outlineSelectionChangedListener);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void reconciled() {
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (XMLEditor.this.outlinePage != null) {
                        XMLEditor.this.outlinePage.update();
                    }
                }
            });
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        XMLTextTools xmlTextTools = XMLPlugin.getDefault().getXMLTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new XMLConfiguration(xmlTextTools, (ITextEditor)this));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
        ShowExternalPreviewAction fShowExternalPreviewAction = ShowExternalPreviewAction.getInstance();
        fShowExternalPreviewAction.setEditor((ITextEditor)this);
        fShowExternalPreviewAction.update();
        if (fShowExternalPreviewAction != null) {
            fShowExternalPreviewAction.doRun(this.fType);
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return XMLPlugin.getDefault().getXMLTextTools().affectsBehavior(event);
    }

    void highlightElement(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            IRegion highlightRegion = element.getSourceRegion();
            this.setHighlightRange(highlightRegion.getOffset(), highlightRegion.getLength(), moveCursor);
        } else {
            this.resetHighlightRange();
        }
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(XMLEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    protected void editorSaved() {
        super.editorSaved();
        ShowExternalPreviewAction a = ShowExternalPreviewAction.getInstance();
        if (a != null) {
            a.refresh(this.fType);
        }
    }

    private class OutlineSelectionChangedListener
    implements ISelectionChangedListener {
        OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                XMLEditor.this.resetHighlightRange();
            } else {
                ISourceReference element = (ISourceReference)selection.getFirstElement();
                XMLEditor.this.highlightElement(element, true);
            }
        }
    }
}

