/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.preferences;

import net.sourceforge.phpeclipse.ui.templates.template.BasicCompletionProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION_TRIGGERS_HTML = "content_assist_autoactivation_triggers_html";
    private static final String ORDER_PROPOSALS = "content_assist_order_proposals";

    private static BasicCompletionProcessor getHTMLProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__xml_tag");
        if (p instanceof BasicCompletionProcessor) {
            return (BasicCompletionProcessor)p;
        }
        return null;
    }

    private static void configureHTMLProcessor(ContentAssistant assistant, IPreferenceStore store) {
        BasicCompletionProcessor hcp = ContentAssistPreference.getHTMLProcessor(assistant);
        if (hcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_HTML);
        if (triggers != null) {
            hcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        store.getBoolean(ORDER_PROPOSALS);
    }

    private static void changeHTMLProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        BasicCompletionProcessor jdcp = ContentAssistPreference.getHTMLProcessor(assistant);
        if (jdcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_HTML.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_HTML);
            if (triggers != null) {
                jdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (ORDER_PROPOSALS.equals(key)) {
            store.getBoolean(ORDER_PROPOSALS);
        }
    }
}

