/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import net.sourceforge.phpeclipse.ui.text.TextDoubleClickStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;

public class AttValueDoubleClickStrategy
extends TextDoubleClickStrategy {
    public void doubleClicked(ITextViewer viewer) {
        int offset = viewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        try {
            IDocument document = viewer.getDocument();
            ITypedRegion region = document.getPartition(offset);
            int start = region.getOffset();
            int length = region.getLength();
            int end = start + length - 1;
            if (offset == start) {
                if (document.getChar(start) == document.getChar(end)) {
                    viewer.setSelectedRange(start + 1, length - 2);
                } else {
                    viewer.setSelectedRange(start + 1, length - 1);
                }
                return;
            }
            if (offset == end && document.getChar(start) == document.getChar(end)) {
                viewer.setSelectedRange(start + 1, length - 2);
                return;
            }
            super.doubleClicked(viewer);
        }
        catch (BadLocationException badLocationException) {}
    }
}

