/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sourceforge.phpeclipse.ui.text.IReconcilingParticipant;
import net.sourceforge.phpeclipse.xml.ui.internal.text.AnnotationAdapter;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLReconcileStep;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.ITextEditor;

public class XMLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor editor;
    IProgressMonitor progressMonitor;
    private IReconcileStep firstStep;

    public XMLReconcilingStrategy(ITextEditor editor) {
        this.editor = editor;
        this.firstStep = new XMLReconcileStep(editor);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.removeTemporaryAnnotations();
        this.process(this.firstStep.reconcile(dirtyRegion, subRegion));
    }

    public void reconcile(IRegion partition) {
        this.removeTemporaryAnnotations();
        this.process(this.firstStep.reconcile(partition));
    }

    public void setDocument(IDocument document) {
        this.firstStep.setInputModel(null);
    }

    public void initialReconcile() {
        this.process(this.firstStep.reconcile(null));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.firstStep.setProgressMonitor(monitor);
        this.progressMonitor = monitor;
    }

    IAnnotationModel getAnnotationModel() {
        IEditorInput input = this.editor.getEditorInput();
        return this.editor.getDocumentProvider().getAnnotationModel((Object)input);
    }

    private void process(final IReconcileResult[] results) {
        if (results == null) {
            return;
        }
        WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                int i = 0;
                while (i < results.length) {
                    if (XMLReconcilingStrategy.this.progressMonitor != null && XMLReconcilingStrategy.this.progressMonitor.isCanceled()) {
                        return;
                    }
                    if (results[i] instanceof AnnotationAdapter) {
                        AnnotationAdapter result = (AnnotationAdapter)results[i];
                        Position pos = result.getPosition();
                        Annotation annotation = result.createAnnotation();
                        XMLReconcilingStrategy.this.getAnnotationModel().addAnnotation(annotation, pos);
                    }
                    ++i;
                }
            }
        };
        try {
            runnable.run(null);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.editor instanceof IReconcilingParticipant) {
            ((IReconcilingParticipant)this.editor).reconciled();
        }
    }

    private void removeTemporaryAnnotations() {
        Iterator i = this.getAnnotationModel().getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            if (annotation.isPersistent()) continue;
            this.getAnnotationModel().removeAnnotation(annotation);
        }
    }
}

