/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.phpdt.core.ClasspathVariableInitializer;
import net.sourceforge.phpdt.core.IBufferFactory;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IElementChangedListener;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModel;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IRegion;
import net.sourceforge.phpdt.core.IWorkingCopy;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.internal.core.BufferManager;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.Region;
import net.sourceforge.phpdt.internal.core.util.MementoTokenizer;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class JavaCore {
    public static final String PLUGIN_ID = "net.sourceforge.phpeclipse";
    public static final String CORE_ENCODING = "net.sourceforge.phpeclipse.encoding";
    public static final String FORMATTER_NEWLINE_OPENING_BRACE = "net.sourceforge.phpeclipse.formatter.newline.openingBrace";
    public static final String FORMATTER_NEWLINE_CONTROL = "net.sourceforge.phpeclipse.formatter.newline.controlStatement";
    public static final String FORMATTER_NEWLINE_ELSE_IF = "net.sourceforge.phpeclipse.formatter.newline.elseIf";
    public static final String FORMATTER_NEWLINE_EMPTY_BLOCK = "net.sourceforge.phpeclipse.formatter.newline.emptyBlock";
    public static final String FORMATTER_CLEAR_BLANK_LINES = "net.sourceforge.phpeclipse.formatter.newline.clearAll";
    public static final String FORMATTER_LINE_SPLIT = "net.sourceforge.phpeclipse.formatter.lineSplit";
    public static final String FORMATTER_COMPACT_ASSIGNMENT = "net.sourceforge.phpeclipse.formatter.style.assignment";
    public static final String FORMATTER_TAB_CHAR = "net.sourceforge.phpeclipse.formatter.tabulation.char";
    public static final String FORMATTER_TAB_SIZE = "net.sourceforge.phpeclipse.formatter.tabulation.size";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String CLEAN = "clean";
    public static final String COMPILER_TASK_TAGS = "net.sourceforge.phpeclipse.compiler.taskTags";
    protected static final String ATT_HANDLE_ID = "net.sourceforge.phpdt.internal.core.JavaModelManager.handleId";
    public static final String COMPILER_LOCAL_VARIABLE_ATTR = "net.sourceforge.phpeclipse.compiler.debug.localVariable";
    public static final String COMPILER_LINE_NUMBER_ATTR = "net.sourceforge.phpeclipse.compiler.debug.lineNumber";
    public static final String COMPILER_SOURCE_FILE_ATTR = "net.sourceforge.phpeclipse.compiler.debug.sourceFile";
    public static final String COMPILER_CODEGEN_UNUSED_LOCAL = "net.sourceforge.phpeclipse.compiler.codegen.unusedLocal";
    public static final String COMPILER_CODEGEN_TARGET_PLATFORM = "net.sourceforge.phpeclipse.compiler.codegen.targetPlatform";
    public static final String COMPILER_PB_PHP_VAR_DEPRECATED = "net.sourceforge.phpeclipse.compiler.problem.phpVarDeprecatedWarning";
    public static final String COMPILER_PB_PHP_KEYWORD = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleKeywordWarning";
    public static final String COMPILER_PB_PHP_UPPERCASE_IDENTIFIER = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleUppercaseIdentifierWarning";
    public static final String COMPILER_PB_PHP_FILE_NOT_EXIST = "net.sourceforge.phpeclipse.compiler.problem.phpIncludeNotExistWarning";
    public static final String COMPILER_PB_UNINITIALIZED_LOCAL_VARIABLE = "net.sourceforge.phpeclipse.compiler.problem.uninitializedLocalVariableWarning";
    public static final String COMPILER_PB_UNREACHABLE_CODE = "net.sourceforge.phpeclipse.compiler.problem.codeCannotBeReachedWarning";
    public static final String COMPILER_PB_INVALID_IMPORT = "net.sourceforge.phpeclipse.compiler.problem.invalidImport";
    public static final String COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD = "net.sourceforge.phpeclipse.compiler.problem.overridingPackageDefaultMethod";
    public static final String COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME = "net.sourceforge.phpeclipse.compiler.problem.methodWithConstructorName";
    public static final String COMPILER_PB_DEPRECATION = "net.sourceforge.phpeclipse.compiler.problem.deprecation";
    public static final String COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE = "net.sourceforge.phpeclipse.compiler.problem.deprecationInDeprecatedCode";
    public static final String COMPILER_PB_HIDDEN_CATCH_BLOCK = "net.sourceforge.phpeclipse.compiler.problem.hiddenCatchBlock";
    public static final String COMPILER_PB_UNUSED_LOCAL = "net.sourceforge.phpeclipse.compiler.problem.unusedLocal";
    public static final String COMPILER_PB_UNUSED_PARAMETER = "net.sourceforge.phpeclipse.compiler.problem.unusedParameter";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT = "net.sourceforge.phpeclipse.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE = "net.sourceforge.phpeclipse.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String COMPILER_PB_UNUSED_IMPORT = "net.sourceforge.phpeclipse.compiler.problem.unusedImport";
    public static final String COMPILER_PB_SYNTHETIC_ACCESS_EMULATION = "net.sourceforge.phpeclipse.compiler.problem.syntheticAccessEmulation";
    public static final String COMPILER_PB_NON_NLS_STRING_LITERAL = "net.sourceforge.phpeclipse.compiler.problem.nonExternalizedStringLiteral";
    public static final String COMPILER_PB_ASSERT_IDENTIFIER = "net.sourceforge.phpeclipse.compiler.problem.assertIdentifier";
    public static final String COMPILER_PB_STATIC_ACCESS_RECEIVER = "net.sourceforge.phpeclipse.compiler.problem.staticAccessReceiver";
    public static final String COMPILER_PB_NO_EFFECT_ASSIGNMENT = "net.sourceforge.phpeclipse.compiler.problem.noEffectAssignment";
    public static final String COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD = "net.sourceforge.phpeclipse.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String COMPILER_PB_UNUSED_PRIVATE_MEMBER = "net.sourceforge.phpeclipse.compiler.problem.unusedPrivateMember";
    public static final String COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION = "net.sourceforge.phpeclipse.compiler.problem.noImplicitStringConversion";
    public static final String COMPILER_PB_MAX_PER_UNIT = "net.sourceforge.phpeclipse.compiler.maxProblemPerUnit";
    public static final String COMPILER_SOURCE = "net.sourceforge.phpeclipse.compiler.source";
    public static final String COMPILER_COMPLIANCE = "net.sourceforge.phpeclipse.compiler.compliance";
    public static final String COMPILER_TASK_PRIORITIES = "net.sourceforge.phpeclipse.compiler.taskPriorities";
    public static final String COMPILER_TASK_PRIORITY_HIGH = "HIGH";
    public static final String COMPILER_TASK_PRIORITY_LOW = "LOW";
    public static final String COMPILER_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String CORE_JAVA_BUILD_ORDER = "net.sourceforge.phpeclipse.computeJavaBuildOrder";
    public static final String CORE_JAVA_BUILD_RESOURCE_COPY_FILTER = "net.sourceforge.phpeclipse.builder.resourceCopyExclusionFilter";
    public static final String CORE_JAVA_BUILD_DUPLICATE_RESOURCE = "net.sourceforge.phpeclipse.builder.duplicateResourceTask";
    public static final String CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER = "net.sourceforge.phpeclipse.builder.cleanOutputFolder";
    public static final String CORE_INCOMPLETE_CLASSPATH = "net.sourceforge.phpeclipse.incompleteClasspath";
    public static final String CORE_CIRCULAR_CLASSPATH = "net.sourceforge.phpeclipse.circularClasspath";
    public static final String CORE_JAVA_BUILD_INVALID_CLASSPATH = "net.sourceforge.phpeclipse.builder.invalidClasspath";
    public static final String CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS = "net.sourceforge.phpeclipse.classpath.exclusionPatterns";
    public static final String CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS = "net.sourceforge.phpeclipse.classpath.multipleOutputLocations";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_PRIORITY = "NORMAL";
    public static final String FORMATTER_SPACE_CASTEXPRESSION = "net.sourceforge.phpeclipse.formatter.space.castexpression";
    public static final String CODEASSIST_VISIBILITY_CHECK = "net.sourceforge.phpeclipse.codeComplete.visibilityCheck";
    public static final String CODEASSIST_IMPLICIT_QUALIFICATION = "net.sourceforge.phpeclipse.codeComplete.forceImplicitQualification";
    public static final String CODEASSIST_FIELD_PREFIXES = "net.sourceforge.phpeclipse.codeComplete.fieldPrefixes";
    public static final String CODEASSIST_STATIC_FIELD_PREFIXES = "net.sourceforge.phpeclipse.codeComplete.staticFieldPrefixes";
    public static final String CODEASSIST_LOCAL_PREFIXES = "net.sourceforge.phpeclipse.codeComplete.localPrefixes";
    public static final String CODEASSIST_ARGUMENT_PREFIXES = "net.sourceforge.phpeclipse.codeComplete.argumentPrefixes";
    public static final String CODEASSIST_FIELD_SUFFIXES = "net.sourceforge.phpeclipse.codeComplete.fieldSuffixes";
    public static final String CODEASSIST_STATIC_FIELD_SUFFIXES = "net.sourceforge.phpeclipse.codeComplete.staticFieldSuffixes";
    public static final String CODEASSIST_LOCAL_SUFFIXES = "net.sourceforge.phpeclipse.codeComplete.localSuffixes";
    public static final String CODEASSIST_ARGUMENT_SUFFIXES = "net.sourceforge.phpeclipse.codeComplete.argumentSuffixes";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String ABORT = "abort";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String COMPUTE = "compute";

    public static IProject[] getPHPProjects() {
        ArrayList<IProject> phpProjectsList = new ArrayList<IProject>();
        IProject[] workspaceProjects = PHPeclipsePlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject iProject = workspaceProjects[i];
            if (JavaCore.isPHPProject(iProject)) {
                phpProjectsList.add(iProject);
            }
            ++i;
        }
        IProject[] phpProjects = new IProject[phpProjectsList.size()];
        return phpProjectsList.toArray(phpProjects);
    }

    public static boolean isPHPProject(IProject aProject) {
        try {
            return aProject.hasNature("net.sourceforge.phpeclipse.phpnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void addPHPNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("net.sourceforge.phpeclipse.phpnature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "net.sourceforge.phpeclipse.phpnature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static Plugin getPlugin() {
        return PHPeclipsePlugin.getDefault();
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        JavaCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        JavaModelManager.getJavaModelManager().addElementChangedListener(listener, eventMask);
    }

    public static void addJavaElementMarkerAttributes(Map attributes, IJavaElement element) {
        if (attributes != null && element != null) {
            attributes.put(ATT_HANDLE_ID, element.getHandleIdentifier());
        }
    }

    public static void addPreProcessingResourceChangedListener(IResourceChangeListener listener) {
        JavaModelManager.getJavaModelManager().deltaState.addPreResourceChangedListener(listener);
    }

    public void configureJavaElementMarker(IMarker marker, IJavaElement element) throws CoreException {
        if (marker != null && element != null) {
            marker.setAttribute(ATT_HANDLE_ID, (Object)element.getHandleIdentifier());
        }
    }

    public static IJavaElement create(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        try {
            return JavaModelManager.getJavaModelManager().getHandleFromMemento(handleIdentifier);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IJavaElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        MementoTokenizer memento = new MementoTokenizer(handleIdentifier);
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        return model.getHandleFromMemento(memento, owner);
    }

    public static IJavaElement create(IFile file) {
        return JavaModelManager.create(file, null);
    }

    public static IJavaElement create(IFolder folder) {
        return JavaModelManager.create(folder, null);
    }

    public static IJavaProject create(IProject project) {
        if (project == null) {
            return null;
        }
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        return javaModel.getJavaProject((IResource)project);
    }

    public static IJavaElement create(IResource resource) {
        return JavaModelManager.create(resource, null);
    }

    public static IJavaModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaModelManager.createCompilationUnitFrom(file, null);
    }

    public static IPath getClasspathVariable(String variableName) {
        IPath variablePath = JavaModelManager.variableGet(variableName);
        if (variablePath == JavaModelManager.VariableInitializationInProgress) {
            return null;
        }
        if (variablePath != null) {
            return variablePath;
        }
        return variablePath;
    }

    public static ClasspathVariableInitializer getClasspathVariableInitializer(String variable) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        return null;
    }

    public static Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        HashSet optionNames = JavaModelManager.OptionNames;
        String[] defaultPropertyNames = preferences.defaultPropertyNames();
        int i = 0;
        while (i < defaultPropertyNames.length) {
            String propertyName = defaultPropertyNames[i];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i;
        }
        String[] propertyNames = preferences.propertyNames();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            String propertyName = propertyNames[i2];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i2;
        }
        defaultOptions.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return defaultOptions;
    }

    public static PHPeclipsePlugin getJavaCore() {
        return (PHPeclipsePlugin)JavaCore.getPlugin();
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return ResourcesPlugin.getEncoding();
        }
        if (JavaModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public static Hashtable getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            HashSet optionNames = JavaModelManager.OptionNames;
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            int i = 0;
            while (i < defaultPropertyNames.length) {
                String propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName));
                }
                ++i;
            }
            String[] propertyNames = preferences.propertyNames();
            int i2 = 0;
            while (i2 < propertyNames.length) {
                String propertyName = propertyNames[i2];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getString(propertyName).trim());
                }
                ++i2;
            }
            options.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return options;
    }

    public static IClasspathEntry getResolvedClasspathEntry(IClasspathEntry entry) {
        IResource resolvedResource;
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath resolvedPath = JavaCore.getResolvedVariablePath(entry.getPath());
        if (resolvedPath == null) {
            return null;
        }
        Object target = JavaModel.getTarget((IContainer)workspaceRoot, resolvedPath, false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource && (resolvedResource = (IResource)target) != null) {
            switch (resolvedResource.getType()) {
                case 4: {
                    return JavaCore.newProjectEntry(resolvedPath, entry.isExported());
                }
                case 1: {
                    break;
                }
            }
        }
        if (target instanceof File) {
            File externalFile = (File)target;
            if (externalFile.isFile()) {
                externalFile.getName().toLowerCase();
            } else {
                resolvedPath.isAbsolute();
            }
        }
        return null;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath resolvedPath = JavaCore.getClasspathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = JavaModelManager.getJavaModelManager().sharedWorkingCopies).get(factory)) == null) {
            return JavaModelManager.NoWorkingCopy;
        }
        Collection copies = perFactoryWorkingCopies.values();
        IWorkingCopy[] result = new IWorkingCopy[copies.size()];
        copies.toArray(result);
        return result;
    }

    public static void initializeDefaultPluginPreferences() {
        Preferences preferences = PHPeclipsePlugin.getDefault().getPluginPreferences();
        HashSet optionNames = JavaModelManager.OptionNames;
        preferences.setDefault(COMPILER_LOCAL_VARIABLE_ATTR, GENERATE);
        optionNames.add(COMPILER_LOCAL_VARIABLE_ATTR);
        preferences.setDefault(COMPILER_LINE_NUMBER_ATTR, GENERATE);
        optionNames.add(COMPILER_LINE_NUMBER_ATTR);
        preferences.setDefault(COMPILER_SOURCE_FILE_ATTR, GENERATE);
        optionNames.add(COMPILER_SOURCE_FILE_ATTR);
        preferences.setDefault(COMPILER_CODEGEN_UNUSED_LOCAL, PRESERVE);
        optionNames.add(COMPILER_CODEGEN_UNUSED_LOCAL);
        preferences.setDefault(COMPILER_CODEGEN_TARGET_PLATFORM, VERSION_1_1);
        optionNames.add(COMPILER_CODEGEN_TARGET_PLATFORM);
        preferences.setDefault(COMPILER_PB_PHP_VAR_DEPRECATED, IGNORE);
        optionNames.add(COMPILER_PB_PHP_VAR_DEPRECATED);
        preferences.setDefault(COMPILER_PB_PHP_KEYWORD, WARNING);
        optionNames.add(COMPILER_PB_PHP_KEYWORD);
        preferences.setDefault(COMPILER_PB_PHP_UPPERCASE_IDENTIFIER, IGNORE);
        optionNames.add(COMPILER_PB_PHP_UPPERCASE_IDENTIFIER);
        preferences.setDefault(COMPILER_PB_PHP_FILE_NOT_EXIST, WARNING);
        optionNames.add(COMPILER_PB_PHP_FILE_NOT_EXIST);
        preferences.setDefault(COMPILER_PB_UNREACHABLE_CODE, WARNING);
        optionNames.add(COMPILER_PB_UNREACHABLE_CODE);
        preferences.setDefault(COMPILER_PB_UNINITIALIZED_LOCAL_VARIABLE, WARNING);
        optionNames.add(COMPILER_PB_UNINITIALIZED_LOCAL_VARIABLE);
        preferences.setDefault(COMPILER_PB_INVALID_IMPORT, ERROR);
        optionNames.add(COMPILER_PB_INVALID_IMPORT);
        preferences.setDefault(COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD, WARNING);
        optionNames.add(COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD);
        preferences.setDefault(COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME, WARNING);
        optionNames.add(COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME);
        preferences.setDefault(COMPILER_PB_DEPRECATION, WARNING);
        optionNames.add(COMPILER_PB_DEPRECATION);
        preferences.setDefault(COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE, DISABLED);
        optionNames.add(COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE);
        preferences.setDefault(COMPILER_PB_HIDDEN_CATCH_BLOCK, WARNING);
        optionNames.add(COMPILER_PB_HIDDEN_CATCH_BLOCK);
        preferences.setDefault(COMPILER_PB_UNUSED_LOCAL, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_LOCAL);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT, DISABLED);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE, DISABLED);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE);
        preferences.setDefault(COMPILER_PB_UNUSED_IMPORT, WARNING);
        optionNames.add(COMPILER_PB_UNUSED_IMPORT);
        preferences.setDefault(COMPILER_PB_UNUSED_PRIVATE_MEMBER, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_PRIVATE_MEMBER);
        preferences.setDefault(COMPILER_PB_SYNTHETIC_ACCESS_EMULATION, IGNORE);
        optionNames.add(COMPILER_PB_SYNTHETIC_ACCESS_EMULATION);
        preferences.setDefault(COMPILER_PB_NON_NLS_STRING_LITERAL, IGNORE);
        optionNames.add(COMPILER_PB_NON_NLS_STRING_LITERAL);
        preferences.setDefault(COMPILER_PB_ASSERT_IDENTIFIER, IGNORE);
        optionNames.add(COMPILER_PB_ASSERT_IDENTIFIER);
        preferences.setDefault(COMPILER_PB_STATIC_ACCESS_RECEIVER, WARNING);
        optionNames.add(COMPILER_PB_STATIC_ACCESS_RECEIVER);
        preferences.setDefault(COMPILER_PB_NO_EFFECT_ASSIGNMENT, WARNING);
        optionNames.add(COMPILER_PB_NO_EFFECT_ASSIGNMENT);
        preferences.setDefault(COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD, WARNING);
        optionNames.add(COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD);
        preferences.setDefault(COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION, WARNING);
        optionNames.add(COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION);
        preferences.setDefault(COMPILER_TASK_TAGS, DEFAULT_TASK_TAG);
        optionNames.add(COMPILER_TASK_TAGS);
        preferences.setDefault(COMPILER_TASK_PRIORITIES, "NORMAL");
        optionNames.add(COMPILER_TASK_PRIORITIES);
        preferences.setDefault(COMPILER_SOURCE, VERSION_1_3);
        optionNames.add(COMPILER_SOURCE);
        preferences.setDefault(COMPILER_COMPLIANCE, VERSION_1_3);
        optionNames.add(COMPILER_COMPLIANCE);
        preferences.setDefault(COMPILER_PB_MAX_PER_UNIT, "100");
        optionNames.add(COMPILER_PB_MAX_PER_UNIT);
        preferences.setDefault(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER, "");
        optionNames.add(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER);
        preferences.setDefault(CORE_JAVA_BUILD_INVALID_CLASSPATH, ABORT);
        optionNames.add(CORE_JAVA_BUILD_INVALID_CLASSPATH);
        preferences.setDefault(CORE_JAVA_BUILD_DUPLICATE_RESOURCE, WARNING);
        optionNames.add(CORE_JAVA_BUILD_DUPLICATE_RESOURCE);
        preferences.setDefault(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER, CLEAN);
        optionNames.add(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER);
        preferences.setDefault(CORE_JAVA_BUILD_ORDER, IGNORE);
        optionNames.add(CORE_JAVA_BUILD_ORDER);
        preferences.setDefault(CORE_CIRCULAR_CLASSPATH, ERROR);
        optionNames.add(CORE_CIRCULAR_CLASSPATH);
        preferences.setDefault(CORE_INCOMPLETE_CLASSPATH, ERROR);
        optionNames.add(CORE_INCOMPLETE_CLASSPATH);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS);
        optionNames.add(CORE_ENCODING);
        preferences.setDefault(FORMATTER_NEWLINE_OPENING_BRACE, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_OPENING_BRACE);
        preferences.setDefault(FORMATTER_NEWLINE_CONTROL, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_CONTROL);
        preferences.setDefault(FORMATTER_CLEAR_BLANK_LINES, PRESERVE_ONE);
        optionNames.add(FORMATTER_CLEAR_BLANK_LINES);
        preferences.setDefault(FORMATTER_NEWLINE_ELSE_IF, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_ELSE_IF);
        preferences.setDefault(FORMATTER_NEWLINE_EMPTY_BLOCK, INSERT);
        optionNames.add(FORMATTER_NEWLINE_EMPTY_BLOCK);
        preferences.setDefault(FORMATTER_LINE_SPLIT, "80");
        optionNames.add(FORMATTER_LINE_SPLIT);
        preferences.setDefault(FORMATTER_COMPACT_ASSIGNMENT, NORMAL);
        optionNames.add(FORMATTER_COMPACT_ASSIGNMENT);
        preferences.setDefault(FORMATTER_TAB_CHAR, TAB);
        optionNames.add(FORMATTER_TAB_CHAR);
        preferences.setDefault(FORMATTER_TAB_SIZE, "4");
        optionNames.add(FORMATTER_TAB_SIZE);
        preferences.setDefault(FORMATTER_SPACE_CASTEXPRESSION, INSERT);
        optionNames.add(FORMATTER_SPACE_CASTEXPRESSION);
        preferences.setDefault(CODEASSIST_VISIBILITY_CHECK, DISABLED);
        optionNames.add(CODEASSIST_VISIBILITY_CHECK);
        preferences.setDefault(CODEASSIST_IMPLICIT_QUALIFICATION, DISABLED);
        optionNames.add(CODEASSIST_IMPLICIT_QUALIFICATION);
        preferences.setDefault(CODEASSIST_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_PREFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_PREFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_PREFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_PREFIXES);
        preferences.setDefault(CODEASSIST_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_SUFFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_SUFFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_SUFFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_SUFFIXES);
    }

    public static boolean isReferencedBy(IJavaElement element, IMarker marker) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? null : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (marker == null) {
            return false;
        }
        String markerHandleId = (String)marker.getAttribute(ATT_HANDLE_ID);
        if (markerHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerHandleId);
        return element.equals(markerElement);
    }

    public static boolean isReferencedBy(IJavaElement element, IMarkerDelta markerDelta) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? null : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (markerDelta == null) {
            return false;
        }
        String markerDeltarHandleId = (String)markerDelta.getAttribute(ATT_HANDLE_ID);
        if (markerDeltarHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerDeltarHandleId);
        return element.equals(markerElement);
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath) {
        return JavaCore.newContainerEntry(containerPath, false);
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath, boolean isExported) {
        if (containerPath == null) {
            Assert.isTrue(false, "Container path cannot be null");
        }
        if (containerPath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal classpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new ClasspathEntry(1, 5, containerPath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported);
    }

    public static IClasspathEntry newProjectEntry(IPath path) {
        return JavaCore.newProjectEntry(path, false);
    }

    public static IClasspathEntry newProjectEntry(IPath path, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        return new ClasspathEntry(1, 2, path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static IClasspathEntry newSourceEntry(IPath path) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, exclusionPatterns, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, exclusionPatterns, specificOutputLocation);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        if (path == null) {
            Assert.isTrue(false, "Source path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue(false, "Exclusion pattern set cannot be null");
        }
        if (inclusionPatterns == null) {
            Assert.isTrue(false, "Inclusion pattern set cannot be null");
        }
        return new ClasspathEntry(1, 3, path, inclusionPatterns, exclusionPatterns, null, null, specificOutputLocation, false);
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        JavaModelManager.getJavaModelManager().removeElementChangedListener(listener);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
    }

    public static void setOptions(Hashtable newOptions) {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        if (newOptions == null) {
            newOptions = JavaCore.getDefaultOptions();
        }
        Enumeration keys = newOptions.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!JavaModelManager.OptionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        JavaCore.getPlugin().savePluginPreferences();
    }
}

