/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.ICompilerRequestor;
import net.sourceforge.phpdt.internal.compiler.IErrorHandlingPolicy;
import net.sourceforge.phpdt.internal.compiler.IProblemFactory;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.env.IBinaryType;
import net.sourceforge.phpdt.internal.compiler.env.ICompilationUnit;
import net.sourceforge.phpdt.internal.compiler.env.INameEnvironment;
import net.sourceforge.phpdt.internal.compiler.env.ISourceType;
import net.sourceforge.phpdt.internal.compiler.impl.CompilerOptions;
import net.sourceforge.phpdt.internal.compiler.impl.ITypeRequestor;
import net.sourceforge.phpdt.internal.compiler.lookup.CompilationUnitScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LookupEnvironment;
import net.sourceforge.phpdt.internal.compiler.lookup.PackageBinding;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilationUnit;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemSeverities;
import net.sourceforge.phpdt.internal.compiler.util.Util;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public UnitParser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        this.requestor = requestor;
        this.problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.problemReporter, environment);
        this.parser = new UnitParser(this.problemReporter);
    }

    public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory, boolean parseLiteralExpressionsAsConstants) {
        this.options = new CompilerOptions(settings);
        this.requestor = requestor;
        this.problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.problemReporter, environment);
        this.parser = new UnitParser(this.problemReporter);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(ICompilationUnit sourceUnit) {
        CompilationResult unitResult = new CompilationResult(sourceUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        try {
            CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult, false) : this.parser.dietParse(sourceUnit, unitResult);
            if (this.options.verbose) {
                String count = String.valueOf(this.totalUnits + 1);
                System.out.println(Util.bind("compilation.request", new String[]{count, count, new String(sourceUnit.getFileName())}));
            }
            this.lookupEnvironment.buildTypeBindings(parsedUnit);
            this.addCompilationUnit(sourceUnit, parsedUnit);
            this.lookupEnvironment.completeTypeBindings(parsedUnit);
        }
        catch (AbortCompilationUnit e) {
            if (unitResult.compilationUnit == sourceUnit) {
                this.requestor.acceptResult(unitResult.tagAsAccepted());
            }
            throw e;
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        this.problemReporter.abortDueToInternalError(Util.bind("abort.againstSourceModel ", String.valueOf(sourceTypes[0].getName()), String.valueOf(sourceTypes[0].getFileName())));
    }

    protected void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        int size = this.unitsToProcess.length;
        if (this.totalUnits == size) {
            this.unitsToProcess = new CompilationUnitDeclaration[size * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = parsedUnit;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void beginToCompile(ICompilationUnit[] sourceUnits) {
        int maxUnits = sourceUnits.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        int i = 0;
        while (true) {
            Object var6_6;
            if (i >= maxUnits) {
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            CompilationResult unitResult = new CompilationResult(sourceUnits[i], i, maxUnits, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnits[i], unitResult, false) : this.parser.dietParse(sourceUnits[i], unitResult);
                if (this.options.verbose) {
                    System.out.println(Util.bind("compilation.request", new String[]{String.valueOf(i + 1), String.valueOf(maxUnits), new String(sourceUnits[i].getFileName())}));
                }
                this.addCompilationUnit(sourceUnits[i], parsedUnit);
            }
            catch (Throwable throwable) {
                var6_6 = null;
                sourceUnits[i] = null;
                throw throwable;
            }
            {
                var6_6 = null;
                sourceUnits[i] = null;
                ++i;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(ICompilationUnit[] sourceUnits) {
        CompilationUnitDeclaration unit = null;
        int i = 0;
        try {
            try {
                this.beginToCompile(sourceUnits);
                while (i < this.totalUnits) {
                    block12: {
                        Object var4_4;
                        unit = this.unitsToProcess[i];
                        try {
                            if (this.options.verbose) {
                                System.out.println(Util.bind("compilation.process", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                            }
                            this.process(unit, i);
                        }
                        catch (Throwable throwable) {
                            var4_4 = null;
                            unit.cleanUp();
                            if (!this.options.verbose) throw throwable;
                            System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                            throw throwable;
                        }
                        {
                            var4_4 = null;
                            unit.cleanUp();
                            if (!this.options.verbose) break block12;
                        }
                        System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[i].getFileName())}));
                    }
                    this.unitsToProcess[i] = null;
                    this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                    ++i;
                }
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
            }
            catch (Error e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
            catch (RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.reset();
            throw throwable;
        }
        {
            Object var6_11 = null;
            this.reset();
            return;
        }
    }

    protected void getMethodBodies(CompilationUnitDeclaration unit, int place) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        if (place < this.parseThreshold) {
            return;
        }
        this.parser.scanner.setSource(unit.compilationResult.compilationUnit.getContents());
        if (unit.types != null) {
            int i = unit.types.size();
            while (--i >= 0) {
                if (!(unit.types.get(i) instanceof TypeDeclaration)) continue;
                ((TypeDeclaration)unit.types.get(i)).parseMethod(this.parser, unit);
            }
        }
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        internalException.printStackTrace();
        if (unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (result != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            internalException.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            String[] pbArguments = new String[]{String.valueOf(Util.bind("compilation.internalError")) + "\n" + buffer.toString()};
            result.record(this.problemReporter.createProblem(result.getFileName(), 0, pbArguments, pbArguments, 1, 0, 0, 0, unit, result), unit);
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
            }
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        if (abortException.isSilent) {
            if (abortException.silentException == null) {
                return;
            }
            throw abortException.silentException;
        }
        CompilationResult result = abortException.compilationResult;
        if (result == null && unit != null) {
            result = unit.compilationResult;
        }
        if (result == null && this.unitsToProcess != null && this.totalUnits > 0) {
            result = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (result != null && !result.hasBeenAccepted) {
            if (abortException.problemId != 0) {
                result.record(this.problemReporter.createProblem(result.getFileName(), abortException.problemId, abortException.problemArguments, abortException.messageArguments, 1, 0, 0, 0, unit, result), unit);
            } else if (abortException.exception != null) {
                this.handleInternalException(abortException.exception, null, result);
                return;
            }
            if (!result.hasBeenAccepted) {
                this.requestor.acceptResult(result.tagAsAccepted());
            }
        } else {
            abortException.printStackTrace();
        }
    }

    public void process(CompilationUnitDeclaration unit, int i) {
        this.getMethodBodies(unit, i);
        if (unit.scope != null) {
            unit.scope.faultInTypes();
        }
        unit.resolve();
        unit.analyseCode();
        unit.compilationResult.totalUnitsKnown = this.totalUnits;
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{sourceUnit});
                unit = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(unit);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.getMethodBodies(unit, 0);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode) {
        CompilationUnitDeclaration unit = null;
        try {
            this.parseThreshold = 0;
            this.beginToCompile(new ICompilationUnit[]{sourceUnit});
            unit = this.unitsToProcess[0];
            this.getMethodBodies(unit, 0);
            CompilationUnitScope cfr_ignored_0 = unit.scope;
            this.unitsToProcess[0] = null;
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }
}

