/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.DefaultErrorHandlingPolicies;
import net.sourceforge.phpdt.internal.compiler.IProblemFactory;
import net.sourceforge.phpdt.internal.compiler.ISourceElementRequestor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ConstructorDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ExplicitConstructorCall;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ImportReference;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.NameReference;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedAllocationExpression;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.env.ICompilationUnit;
import net.sourceforge.phpdt.internal.compiler.env.ISourceType;
import net.sourceforge.phpdt.internal.compiler.impl.CompilerOptions;
import net.sourceforge.phpdt.internal.compiler.impl.ReferenceContext;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;
import net.sourceforge.phpdt.internal.core.util.CommentRecorderParser;

public class SourceElementParser
extends CommentRecorderParser {
    ISourceElementRequestor requestor;
    int fieldCount;
    int localIntPtr;
    int lastFieldEndPosition;
    ISourceType sourceType;
    boolean reportReferenceInfo;
    char[][] typeNames;
    char[][] superTypeNames;
    int nestedTypeIndex;
    static final char[] JAVA_LANG_OBJECT = "java.lang.Object".toCharArray();
    NameReference[] unknownRefs;
    int unknownRefsCounter;
    LocalDeclarationVisitor localDeclarationVisitor = null;

    public SourceElementParser(final ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options) {
        super(new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, problemFactory){

            public void record(IProblem problem, CompilationResult unitResult, ReferenceContext referenceContext) {
                unitResult.record(problem, referenceContext);
                if (requestor != null) {
                    requestor.acceptProblem(problem);
                }
            }
        });
        this.requestor = requestor;
        this.typeNames = new char[4][];
        this.superTypeNames = new char[4][];
        this.nestedTypeIndex = 0;
        this.options = options;
    }

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory) {
        this(requestor, problemFactory, new CompilerOptions());
    }

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations) {
        this(requestor, problemFactory, options);
        if (reportLocalDeclarations) {
            this.localDeclarationVisitor = new LocalDeclarationVisitor();
        }
    }

    public void notifySourceElementRequestor(CompilationUnitDeclaration parsedUnit) {
        if (parsedUnit == null) {
            if (this.astStack[0] instanceof AbstractMethodDeclaration) {
                this.notifySourceElementRequestor((AbstractMethodDeclaration)this.astStack[0]);
                return;
            }
            return;
        }
        boolean isInRange = this.scanner.initialPosition <= parsedUnit.sourceStart && this.scanner.eofPosition >= parsedUnit.sourceEnd;
        int length = 0;
        ASTNode[] nodes = null;
        if (this.sourceType == null) {
            if (isInRange) {
                this.requestor.enterCompilationUnit();
            }
            ImportReference[] imports = parsedUnit.imports;
            ArrayList types = parsedUnit.types;
            if (types != null) {
                int max;
                int i;
                length = (imports == null ? 0 : imports.length) + types.size();
                nodes = new ASTNode[length];
                int index = 0;
                if (imports != null) {
                    i = 0;
                    max = imports.length;
                    while (i < max) {
                        nodes[index++] = imports[i];
                        ++i;
                    }
                }
                i = 0;
                max = types.size();
                while (i < max) {
                    nodes[index++] = (ASTNode)types.get(i);
                    ++i;
                }
            }
        } else {
            ArrayList types = parsedUnit.types;
            if (types != null) {
                length = types.size();
                nodes = new ASTNode[length];
                int i = 0;
                int max = types.size();
                while (i < max) {
                    nodes[i] = (ASTNode)types.get(i);
                    ++i;
                }
            }
        }
        if (nodes != null && length > 0) {
            SourceElementParser.quickSort(nodes, 0, length - 1);
            int i = 0;
            while (i < length) {
                ASTNode node = nodes[i];
                if (node instanceof ImportReference) {
                    ImportReference importRef = (ImportReference)node;
                    this.notifySourceElementRequestor(importRef, false);
                }
                if (node instanceof TypeDeclaration) {
                    this.notifySourceElementRequestor((TypeDeclaration)node, this.sourceType == null);
                }
                if (node instanceof AbstractMethodDeclaration) {
                    this.notifySourceElementRequestor((AbstractMethodDeclaration)node);
                }
                ++i;
            }
        }
        if (this.sourceType == null && isInRange) {
            this.requestor.exitCompilationUnit(parsedUnit.sourceEnd);
        }
    }

    public void notifySourceElementRequestor(AbstractMethodDeclaration methodDeclaration) {
        boolean isInRange;
        boolean bl = isInRange = this.scanner.initialPosition <= methodDeclaration.declarationSourceStart && this.scanner.eofPosition >= methodDeclaration.declarationSourceEnd;
        if (methodDeclaration.isClinit()) {
            this.visitIfNeeded(methodDeclaration);
            return;
        }
        if (methodDeclaration.isDefaultConstructor()) {
            if (this.reportReferenceInfo) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            return;
        }
        char[][] argumentTypes = null;
        char[][] argumentNames = null;
        Argument[] arguments = methodDeclaration.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            argumentTypes = new char[argumentLength][];
            argumentNames = new char[argumentLength][];
            int i = 0;
            while (i < argumentLength) {
                argumentTypes[i] = this.returnTypeName(arguments[i].type);
                argumentNames[i] = arguments[i].name;
                ++i;
            }
        }
        char[][] thrownExceptionTypes = null;
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionLength = thrownExceptions.length;
            thrownExceptionTypes = new char[thrownExceptionLength][];
            int i = 0;
            while (i < thrownExceptionLength) {
                thrownExceptionTypes[i] = CharOperation.concatWith(thrownExceptions[i].getTypeName(), '.');
                ++i;
            }
        }
        int selectorSourceEnd = -1;
        if (methodDeclaration.isConstructor()) {
            if (isInRange) {
                this.requestor.enterConstructor(methodDeclaration.declarationSourceStart, methodDeclaration.modifiers, methodDeclaration.selector, methodDeclaration.sourceStart, selectorSourceEnd, argumentTypes, argumentNames, thrownExceptionTypes);
            }
            if (this.reportReferenceInfo) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            this.visitIfNeeded(methodDeclaration);
            if (isInRange) {
                this.requestor.exitConstructor(methodDeclaration.declarationSourceEnd);
            }
            return;
        }
        if (isInRange) {
            int modifiers = methodDeclaration.modifiers;
            this.requestor.enterMethod(methodDeclaration.declarationSourceStart, modifiers, this.returnTypeName(((MethodDeclaration)methodDeclaration).returnType), methodDeclaration.selector, methodDeclaration.sourceStart, selectorSourceEnd, argumentTypes, argumentNames, thrownExceptionTypes);
        }
        this.visitIfNeeded(methodDeclaration);
        if (isInRange) {
            this.requestor.exitMethod(methodDeclaration.declarationSourceEnd);
        }
    }

    public void notifySourceElementRequestor(FieldDeclaration fieldDeclaration) {
        boolean isInRange;
        boolean bl = isInRange = this.scanner.initialPosition <= fieldDeclaration.declarationSourceStart && this.scanner.eofPosition >= fieldDeclaration.declarationSourceEnd;
        if (fieldDeclaration.isField()) {
            int fieldEndPosition = fieldDeclaration.declarationSourceEnd;
            if (isInRange) {
                int modifiers = fieldDeclaration.modifiers;
                boolean deprecated = (modifiers & 0x100000) != 0;
                this.requestor.enterField(fieldDeclaration.declarationSourceStart, deprecated ? modifiers & 0xFFFF | 0x100000 : modifiers & 0xFFFF, this.returnTypeName(fieldDeclaration.type), fieldDeclaration.name, fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd);
            }
            if (isInRange) {
                this.requestor.exitField(-1, fieldEndPosition, fieldDeclaration.declarationSourceEnd);
            }
        }
    }

    public void notifySourceElementRequestor(ImportReference importReference, boolean isPackage) {
        this.requestor.acceptImport(importReference.declarationSourceStart, importReference.declarationSourceEnd, importReference.getIncludeName(), importReference.onDemand);
    }

    public void notifySourceElementRequestor(TypeDeclaration typeDeclaration, boolean notifyTypePresence) {
        boolean isInRange = this.scanner.initialPosition <= typeDeclaration.declarationSourceStart && this.scanner.eofPosition >= typeDeclaration.declarationSourceEnd;
        FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int fieldCount = fields == null ? 0 : fields.length;
        int methodCount = methods == null ? 0 : methods.length;
        int memberTypeCount = memberTypes == null ? 0 : memberTypes.length;
        int fieldIndex = 0;
        int methodIndex = 0;
        int memberTypeIndex = 0;
        boolean isInterface = typeDeclaration.isInterface();
        if (notifyTypePresence) {
            QualifiedAllocationExpression alloc;
            char[][] interfaceNames = null;
            int superInterfacesLength = 0;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces != null) {
                superInterfacesLength = superInterfaces.length;
                interfaceNames = new char[superInterfacesLength][];
            } else if (typeDeclaration instanceof AnonymousLocalTypeDeclaration && (alloc = ((AnonymousLocalTypeDeclaration)typeDeclaration).allocation) != null && alloc.type != null) {
                superInterfaces = new TypeReference[]{((AnonymousLocalTypeDeclaration)typeDeclaration).allocation.type};
                superInterfacesLength = 1;
                interfaceNames = new char[1][];
            }
            if (superInterfaces != null) {
                int i = 0;
                while (i < superInterfacesLength) {
                    interfaceNames[i] = CharOperation.concatWith(superInterfaces[i].getTypeName(), '.');
                    ++i;
                }
            }
            if (isInterface) {
                if (isInRange) {
                    int modifiers = typeDeclaration.modifiers;
                    this.requestor.enterInterface(typeDeclaration.declarationSourceStart, modifiers, typeDeclaration.name, typeDeclaration.sourceStart, typeDeclaration.sourceEnd, interfaceNames);
                }
                if (this.nestedTypeIndex == this.typeNames.length) {
                    this.typeNames = new char[this.nestedTypeIndex * 2][];
                    System.arraycopy(this.typeNames, 0, this.typeNames, 0, this.nestedTypeIndex);
                    this.superTypeNames = new char[this.nestedTypeIndex * 2][];
                    System.arraycopy(this.superTypeNames, 0, this.superTypeNames, 0, this.nestedTypeIndex);
                }
                this.typeNames[this.nestedTypeIndex] = typeDeclaration.name;
                this.superTypeNames[this.nestedTypeIndex++] = JAVA_LANG_OBJECT;
            } else {
                TypeReference superclass = typeDeclaration.superclass;
                if (superclass == null) {
                    if (isInRange) {
                        this.requestor.enterClass(typeDeclaration.declarationSourceStart, typeDeclaration.modifiers, typeDeclaration.name, typeDeclaration.sourceStart, typeDeclaration.sourceEnd, null, interfaceNames);
                    }
                } else if (isInRange) {
                    this.requestor.enterClass(typeDeclaration.declarationSourceStart, typeDeclaration.modifiers, typeDeclaration.name, typeDeclaration.sourceStart, typeDeclaration.sourceEnd, CharOperation.concatWith(superclass.getTypeName(), '.'), interfaceNames);
                }
                if (this.nestedTypeIndex == this.typeNames.length) {
                    this.typeNames = new char[this.nestedTypeIndex * 2][];
                    System.arraycopy(this.typeNames, 0, this.typeNames, 0, this.nestedTypeIndex);
                    this.superTypeNames = new char[this.nestedTypeIndex * 2][];
                    System.arraycopy(this.superTypeNames, 0, this.superTypeNames, 0, this.nestedTypeIndex);
                }
                this.typeNames[this.nestedTypeIndex] = typeDeclaration.name;
                this.superTypeNames[this.nestedTypeIndex++] = superclass == null ? JAVA_LANG_OBJECT : CharOperation.concatWith(superclass.getTypeName(), '.');
            }
        }
        while (fieldIndex < fieldCount || memberTypeIndex < memberTypeCount || methodIndex < methodCount) {
            FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldIndex < fieldCount) {
                nextFieldDeclaration = fields[fieldIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodIndex < methodCount) {
                nextMethodDeclaration = methods[methodIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (memberTypeIndex < memberTypeCount) {
                nextMemberDeclaration = memberTypes[memberTypeIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    ++fieldIndex;
                    this.notifySourceElementRequestor(nextFieldDeclaration);
                    break;
                }
                case 1: {
                    ++methodIndex;
                    this.notifySourceElementRequestor(nextMethodDeclaration);
                    break;
                }
                case 2: {
                    ++memberTypeIndex;
                    this.notifySourceElementRequestor(nextMemberDeclaration, true);
                }
            }
        }
        if (notifyTypePresence) {
            if (isInRange) {
                if (isInterface) {
                    this.requestor.exitInterface(typeDeclaration.declarationSourceEnd);
                } else {
                    this.requestor.exitClass(typeDeclaration.declarationSourceEnd);
                }
            }
            --this.nestedTypeIndex;
        }
    }

    public void parseCompilationUnit(ICompilationUnit unit, int start, int end) {
        try {
            CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, 10);
            this.parse(unit, compilationUnitResult, start, end);
        }
        catch (AbortCompilation abortCompilation) {}
    }

    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse) {
        try {
            this.reportReferenceInfo = fullParse;
            CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult, false);
            if (this.scanner.recordLineSeparator) {
                this.requestor.acceptLineSeparatorPositions(this.scanner.getLineEnds());
            }
            int initialStart = this.scanner.initialPosition;
            int initialEnd = this.scanner.eofPosition;
            this.scanner.resetTo(initialStart, initialEnd);
            this.notifySourceElementRequestor(parsedUnit);
            return parsedUnit;
        }
        catch (AbortCompilation abortCompilation) {
            return null;
        }
    }

    public CompilationUnitDeclaration parseCompletionUnit(ICompilationUnit unit, boolean fullParse) {
        try {
            this.reportReferenceInfo = fullParse;
            CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult, false);
            return parsedUnit;
        }
        catch (AbortCompilation abortCompilation) {
            return null;
        }
    }

    private static void quickSort(ASTNode[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        ASTNode mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].sourceStart < mid.sourceStart) {
                ++left;
                continue;
            }
            while (mid.sourceStart < sortedCollection[right].sourceStart) {
                --right;
            }
            if (left <= right) {
                ASTNode tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            SourceElementParser.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            SourceElementParser.quickSort(sortedCollection, left, original_right);
        }
    }

    private char[] returnTypeName(TypeReference type) {
        if (type == null) {
            return null;
        }
        int dimension = type.dimensions();
        if (dimension != 0) {
            char[] dimensionsArray = new char[dimension * 2];
            int i = 0;
            while (i < dimension) {
                dimensionsArray[i * 2] = 91;
                dimensionsArray[i * 2 + 1] = 93;
                ++i;
            }
            return CharOperation.concat(CharOperation.concatWith(type.getTypeName(), '.'), dimensionsArray);
        }
        return CharOperation.concatWith(type.getTypeName(), '.');
    }

    public void addUnknownRef(NameReference nameRef) {
        if (this.unknownRefs.length == this.unknownRefsCounter) {
            this.unknownRefs = new NameReference[this.unknownRefsCounter * 2];
            System.arraycopy(this.unknownRefs, 0, this.unknownRefs, 0, this.unknownRefsCounter);
        }
        this.unknownRefs[this.unknownRefsCounter++] = nameRef;
    }

    private void visitIfNeeded(AbstractMethodDeclaration method) {
        if (this.localDeclarationVisitor != null && (method.bits & 2) != 0 && method.statements != null) {
            int statementsLength = method.statements.length;
            int i = 0;
            while (i < statementsLength) {
                method.statements[i].traverse(this.localDeclarationVisitor, method.scope);
                ++i;
            }
        }
    }

    protected CompilationUnitDeclaration endParse(int act) {
        if (this.compilationUnit != null) {
            CompilationUnitDeclaration result = super.endParse(act);
            return result;
        }
        return null;
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null);
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration, ClassScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null);
            return false;
        }
    }
}

