/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.SingleTypeReference;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.InitializationFlowContext;
import net.sourceforge.phpdt.internal.compiler.impl.ReferenceContext;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilationUnit;
import net.sourceforge.phpdt.internal.compiler.problem.AbortMethod;
import net.sourceforge.phpdt.internal.compiler.problem.AbortType;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int abortLevel) {
        if (this.scope == null) {
            throw new AbortCompilation();
        }
        CompilationResult compilationResult = this.scope.referenceCompilationUnit().compilationResult;
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(compilationResult);
            }
            case 4: {
                throw new AbortCompilationUnit(compilationResult);
            }
            case 8: {
                throw new AbortType(compilationResult);
            }
        }
        throw new AbortMethod(compilationResult);
    }

    public abstract void analyseCode(ClassScope var1, InitializationFlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            boolean used = this.binding == null || this.binding.isAbstract();
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                TypeBinding argType = this.binding == null ? null : this.binding.parameters[i];
                this.arguments[i].bind(this.scope, argType, used);
                ++i;
            }
        }
    }

    public void bindThrownExceptions() {
        block8: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block8;
            int length = this.binding.thrownExceptions.length;
            int thrownExceptionLength = this.thrownExceptions.length;
            if (length == thrownExceptionLength) {
                int i = 0;
                while (i < length) {
                    this.thrownExceptions[i].resolvedType = this.binding.thrownExceptions[i];
                    ++i;
                }
            } else {
                int bindingIndex = 0;
                int i = 0;
                while (i < thrownExceptionLength && bindingIndex < length) {
                    TypeReference thrownException = this.thrownExceptions[i];
                    ReferenceBinding thrownExceptionBinding = this.binding.thrownExceptions[bindingIndex];
                    char[][] bindingCompoundName = thrownExceptionBinding.compoundName;
                    if (thrownException instanceof SingleTypeReference) {
                        int lengthName = bindingCompoundName.length;
                        char[] thrownExceptionTypeName = thrownException.getTypeName()[0];
                        if (CharOperation.equals(thrownExceptionTypeName, bindingCompoundName[lengthName - 1])) {
                            thrownException.resolvedType = thrownExceptionBinding;
                            ++bindingIndex;
                        }
                    } else if (CharOperation.equals(thrownException.getTypeName(), bindingCompoundName)) {
                        thrownException.resolvedType = thrownExceptionBinding;
                        ++bindingIndex;
                    }
                    ++i;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(UnitParser var1, CompilationUnitDeclaration var2);

    public StringBuffer print(int tab, StringBuffer output) {
        int i;
        AbstractMethodDeclaration.printIndent(tab, output);
        AbstractMethodDeclaration.printModifiers(this.modifiers, output);
        this.printReturnType(0, output).append(this.selector).append('(');
        if (this.arguments != null) {
            i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        if (this.thrownExceptions != null) {
            output.append(" throws ");
            i = 0;
            while (i < this.thrownExceptions.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.thrownExceptions[i].print(0, output);
                ++i;
            }
        }
        this.printBody(tab + 1, output);
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return output.append(';');
        }
        output.append(" {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        }
        output.append('\n');
        AbstractMethodDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output;
    }

    public void resolve(ClassScope upperScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.bindThrownExceptions();
            this.resolveStatements();
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public String returnTypeToString(int tab) {
        return "";
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public String toString(int tab) {
        int i;
        String s = AbstractMethodDeclaration.tabString(tab);
        if (this.modifiers != 0) {
            s = String.valueOf(s) + AbstractMethodDeclaration.modifiersString(this.modifiers);
        }
        s = String.valueOf(s) + this.returnTypeToString(0);
        s = String.valueOf(s) + new String(this.selector) + "(";
        if (this.arguments != null) {
            i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toString(0);
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")";
        if (this.thrownExceptions != null) {
            s = String.valueOf(s) + " throws ";
            i = 0;
            while (i < this.thrownExceptions.length) {
                s = String.valueOf(s) + this.thrownExceptions[i].toString(0);
                if (i != this.thrownExceptions.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + this.toStringStatements(tab + 1);
        return s;
    }

    public String toStringStatements(int tab) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return ";";
        }
        String s = " {";
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                s = String.valueOf(s) + "\n" + this.statements[i].toString(tab);
                if (!(this.statements[i] instanceof Block)) {
                    s = String.valueOf(s) + ";";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "\n" + AbstractMethodDeclaration.tabString(tab == 0 ? 0 : tab - 1) + "}";
        return s;
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
    }
}

