/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.NestedTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SyntheticArgumentBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary(this.binding.declaringClass, currentScope, flowInfo);
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo, currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        this.manageSyntheticAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding checkedType, BlockScope currentScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedType;
        SyntheticArgumentBinding[] syntheticArguments;
        if (checkedType.isLocalType() && !checkedType.isAnonymousType() && !currentScope.isDefinedInType(checkedType) && (syntheticArguments = (nestedType = (NestedTypeBinding)checkedType).syntheticOuterLocalVariables()) != null) {
            int i = 0;
            int count = syntheticArguments.length;
            while (i < count) {
                SyntheticArgumentBinding syntheticArgument = syntheticArguments[i];
                if (syntheticArgument.actualOuterLocalVariable == null) {
                    // empty if block
                }
                ++i;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (allocatedType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedType.isLocalType()) {
                ((LocalTypeBinding)allocatedType).addInnerEmulationDependent(currentScope, false);
            } else {
                currentScope.propagateInnerEmulation(allocatedType, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.isPrivate() && currentScope.enclosingSourceType() != this.binding.declaringClass) {
            this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
            currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.type.printExpression(0, output);
        output.append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        this.resolvedType = this.type.resolveType(scope);
        TypeBinding[] argumentTypes = NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.canBeInstantiated()) {
            scope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding allocatedType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocatedType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = allocatedType;
            }
            scope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        return allocatedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int i) {
    }

    public void setFieldIndex(int i) {
    }

    public String toStringExpression() {
        String s = "new " + this.type.toString(0);
        if (this.arguments == null) {
            s = String.valueOf(s) + "()";
        } else {
            s = String.valueOf(s) + "(";
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                s = i == this.arguments.length - 1 ? String.valueOf(s) + ")" : String.valueOf(s) + ", ";
                ++i;
            }
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

