/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.SwitchStatement;
import net.sourceforge.phpdt.internal.compiler.codegen.CaseLabel;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public CaseLabel targetLabel;

    public CaseStatement(int sourceStart, Expression constantExpression) {
        this.constantExpression = constantExpression;
        this.sourceEnd = constantExpression.sourceEnd;
        this.sourceStart = sourceStart;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression.constant == NotAConstant) {
            currentScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
        }
        this.constantExpression.analyseCode(currentScope, flowContext, flowInfo);
        return flowInfo;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        CaseStatement.printIndent(tab, output);
        if (this.constantExpression == null) {
            output.append("default : ");
        } else {
            output.append("case ");
            this.constantExpression.printExpression(0, output).append(" : ");
        }
        return output.append(';');
    }

    public void resolve(BlockScope scope) {
    }

    public Constant resolveCase(BlockScope scope, TypeBinding switchType, SwitchStatement switchStatement) {
        switchStatement.cases[switchStatement.caseCount++] = this;
        TypeBinding caseType = this.constantExpression.resolveType(scope);
        if (caseType == null || switchType == null) {
            return null;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(caseType, switchType)) {
            return this.constantExpression.constant;
        }
        if (caseType.isCompatibleWith(switchType)) {
            return this.constantExpression.constant;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.constantExpression, caseType, switchType);
        return null;
    }

    public String toString(int tab) {
        String s = CaseStatement.tabString(tab);
        s = String.valueOf(s) + "case " + this.constantExpression.toStringExpression() + " : ";
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.constantExpression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

